/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.metadata.registry;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Map;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.wsdl.WSDLReaderConfigurator;
import org.apache.axis2.jaxws.wsdl.WSDLReaderConfiguratorImpl;
import org.apache.axis2.metadata.factory.ResourceFinderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetadataFactoryRegistry {
    private static Log log = LogFactory.getLog(MetadataFactoryRegistry.class);
    private static String configurationFileLoc = null;
    private static final Map<Class, Object> table = new Hashtable<Class, Object>();

    private MetadataFactoryRegistry() {
    }

    public static Object getFactory(Class intface) {
        return table.get(intface);
    }

    public static void setFactory(Class intface, Object factoryObject) {
        table.put(intface, factoryObject);
    }

    private static void loadConfigFromFile() {
        block18: {
            String pairSeparator = "|";
            try {
                ClassLoader classLoader = MetadataFactoryRegistry.getContextClassLoader(null);
                URL url = null;
                url = classLoader.getResource(configurationFileLoc);
                if (url == null) {
                    File file = new File(configurationFileLoc);
                    url = file.toURI().toURL();
                }
                if (url != null) {
                    BufferedReader reader;
                    String line;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found URL to MetadataFactoryRegistry configuration file: " + configurationFileLoc));
                    }
                    if ((line = (reader = new BufferedReader(new InputStreamReader(url.openStream()))).readLine()) != null && line.indexOf("|") != -1) {
                        String interfaceName = line.substring(0, line.indexOf(pairSeparator));
                        String implName = line.substring(line.indexOf(pairSeparator) + 1, line.length());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("For registered class: " + interfaceName + " the following implementation was found: " + implName));
                        }
                        Class<?> intf = classLoader.loadClass(interfaceName);
                        Class<?> impl = classLoader.loadClass(implName);
                        if (intf != null && impl != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Loaded both interface and implementation class: " + interfaceName + ":" + implName));
                            }
                            if (impl.getEnclosingClass() == null) {
                                table.put(intf, impl.newInstance());
                            } else if (log.isWarnEnabled()) {
                                log.warn((Object)("The implementation class: " + impl.getClass().getName() + " could not be lregistered because it is an inner class. In order to register file-based overrides, implementations must be public outer classes."));
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("Could not load both interface and implementation class: " + interfaceName + ":" + implName));
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("Did not find File for MetadataFactoryRegistry configuration file: " + configurationFileLoc));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Did not find URL for MetadataFactoryRegistry configuration file: " + configurationFileLoc));
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block18;
                log.debug((Object)("The MetadataFactoryRegistry could not process the configuration file: " + configurationFileLoc + " because of the following error: " + t.toString()));
            }
        }
    }

    static void setConfigurationFileLocation(String configFileLoc) {
        configurationFileLoc = configFileLoc;
        MetadataFactoryRegistry.loadConfigFromFile();
    }

    private static ClassLoader getContextClassLoader(final ClassLoader classLoader) {
        ClassLoader cl;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e.getMessage()), (Throwable)e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    static {
        table.put(ResourceFinderFactory.class, new ResourceFinderFactory());
        table.put(ClientConfigurationFactory.class, new ClientConfigurationFactory());
        table.put(WSDLReaderConfigurator.class, new WSDLReaderConfiguratorImpl());
        if (configurationFileLoc == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"A configuration file location was not set. The following location will be used: META-INF/services/org.apache.axis2.metadata.registry.MetadataFactoryRegistry");
            }
            configurationFileLoc = "META-INF/services/org.apache.axis2.metadata.registry.MetadataFactoryRegistry";
        }
        MetadataFactoryRegistry.loadConfigFromFile();
    }
}

