/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.algorithms;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis2.clustering.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.PropertyInclude;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.mediators.MediatorProperty;

public class WeightedRRLCAlgorithm
implements LoadbalanceAlgorithm,
ManagedLifecycle {
    private static final Log log = LogFactory.getLog(WeightedRRLCAlgorithm.class);
    private List<Endpoint> endpoints = null;
    private Endpoint loadBalanceEndpoint = null;
    private WeightedState[] list;
    private int endpointCursor = 0;
    private int roundsPerRecalculation = 1;
    private int currentRound = 0;
    private int totalWeight = 0;
    private int totalConnections = 0;
    public static final String LB_WEIGHTED_RRLC_ROUNDS_PER_RECAL = "loadbalance.weightedRRLC.roundsPerRecal";
    public static final String LB_WEIGHTED_RRLC_WEIGHT = "loadbalance.weight";
    public static final String LB_WEIGHTED_RRLC_WEIGHT_MIN = "loadbalance.weight.min";
    public static final String LB_WEIGHTED_RRLC_WEIGHT_MAX = "loadbalance.weight.max";
    public static final int LB_WEIGHTED_RRLC_WEIGHT_SKEW = 2;

    @Override
    public void setApplicationMembers(List<Member> members) {
    }

    @Override
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void setLoadBalanceEndpoint(Endpoint endpoint) {
        this.loadBalanceEndpoint = endpoint;
    }

    @Override
    public synchronized Endpoint getNextEndpoint(MessageContext messageContext, AlgorithmContext algorithmContext) {
        WeightedState s = this.list[this.endpointCursor];
        if (!s.isSendsAvailable()) {
            s.resetPerRound();
            do {
                if (++this.endpointCursor != this.list.length) continue;
                this.endpointCursor = 0;
                if (++this.currentRound != this.roundsPerRecalculation) continue;
                this.currentRound = 0;
                this.reCalcuateWeights(messageContext);
            } while (!(s = this.list[this.endpointCursor]).isSendsAvailable());
        }
        s.chosenToSend();
        return this.endpoints.get(s.getEndpointPosition());
    }

    private void intialize() {
        PropertyInclude include;
        PropertyInclude include2;
        Object val;
        if (this.loadBalanceEndpoint != null && this.loadBalanceEndpoint instanceof PropertyInclude && (val = (include2 = (PropertyInclude)((Object)this.loadBalanceEndpoint)).getProperty(LB_WEIGHTED_RRLC_ROUNDS_PER_RECAL)) != null) {
            this.roundsPerRecalculation = Integer.parseInt(((MediatorProperty)val).getValue());
        }
        this.list = new WeightedState[this.endpoints.size()];
        int totalWeight = 0;
        for (Endpoint endpoint : this.endpoints) {
            if (!(endpoint instanceof PropertyInclude)) continue;
            include = (PropertyInclude)((Object)endpoint);
            MediatorProperty val2 = include.getProperty(LB_WEIGHTED_RRLC_WEIGHT);
            if (val2 == null) {
                String msg = "Parameter loadbalance.weighted.weight should be specified for every endpoint in the load balance group";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            totalWeight += Integer.parseInt(val2.getValue());
        }
        this.totalWeight = totalWeight;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            MediatorProperty maxWeight;
            String msg;
            URL url;
            Endpoint e = this.endpoints.get(i);
            if (!(e instanceof PropertyInclude)) continue;
            include = (PropertyInclude)((Object)e);
            MediatorProperty weight = include.getProperty(LB_WEIGHTED_RRLC_WEIGHT);
            if (e instanceof AddressEndpoint) {
                AddressEndpoint addressEndpoint = (AddressEndpoint)e;
                try {
                    url = new URL(addressEndpoint.getDefinition().getAddress());
                }
                catch (MalformedURLException e1) {
                    msg = "Mulformed URL in address endpoint";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
            } else if (e instanceof WSDLEndpoint) {
                WSDLEndpoint wsdlEndpoint = (WSDLEndpoint)e;
                try {
                    url = new URL(wsdlEndpoint.getDefinition().getAddress());
                }
                catch (MalformedURLException e1) {
                    msg = "Mulformed URL in address endpoint";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
            } else {
                String msg2 = "Only AddressEndpoint and WSDLEndpoint can be used with WeightedRRLCAlgorithm";
                log.error((Object)msg2);
                throw new SynapseException(msg2);
            }
            String key = url.getHost() + ":" + url.getPort();
            WeightedState state = new WeightedState(Integer.parseInt(weight.getValue()), i, key);
            MediatorProperty minimumWeight = include.getProperty(LB_WEIGHTED_RRLC_WEIGHT_MIN);
            if (minimumWeight != null) {
                state.setMinWeight(Integer.parseInt(minimumWeight.getValue()));
            }
            if ((maxWeight = include.getProperty(LB_WEIGHTED_RRLC_WEIGHT_MAX)) != null) {
                state.setMaxWeight(Integer.parseInt(maxWeight.getValue()));
            }
            this.list[i] = state;
        }
        Arrays.sort(this.list, new Comparator<WeightedState>(){

            @Override
            public int compare(WeightedState o1, WeightedState o2) {
                return o2.getFixedWeight() - o1.getFixedWeight();
            }
        });
    }

    @Override
    public Member getNextApplicationMember(AlgorithmContext algorithmContext) {
        return null;
    }

    @Override
    public void reset(AlgorithmContext algorithmContext) {
        for (WeightedState state : this.list) {
            state.reset();
        }
    }

    @Override
    public String getName() {
        return WeightedRRLCAlgorithm.class.getName();
    }

    @Override
    public LoadbalanceAlgorithm clone() {
        return null;
    }

    public int getEndpointCursor() {
        return this.endpointCursor;
    }

    public int getRoundsPerRecalculation() {
        return this.roundsPerRecalculation;
    }

    public int getCurrentRound() {
        return this.currentRound;
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public int getTotalConnections() {
        return this.totalConnections;
    }

    private void reCalcuateWeights(MessageContext messageContext) {
        Axis2MessageContext axis2MessageContext;
        org.apache.axis2.context.MessageContext msgCtx;
        Object obj;
        Map connectionsMap = null;
        if (messageContext instanceof Axis2MessageContext && (obj = (msgCtx = (axis2MessageContext = (Axis2MessageContext)messageContext).getAxis2MessageContext()).getProperty("OPEN_CONNNECTIONS_MAP")) != null && obj instanceof Map) {
            connectionsMap = (Map)obj;
        }
        if (connectionsMap == null) {
            String msg = "Connections map not found.";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        for (WeightedState state : this.list) {
            String key = state.getKeyToConnectionCount();
            AtomicInteger integer = (AtomicInteger)connectionsMap.get(key);
            if (integer != null) {
                state.setCurrentConnectionCount(integer.get());
            } else {
                state.setCurrentConnectionCount(0);
            }
            this.totalConnections += state.getCurrentConnectionCount();
        }
        for (WeightedState state : this.list) {
            state.reCalcuateWeight();
        }
    }

    @Override
    public void init(SynapseEnvironment se) {
        this.intialize();
    }

    @Override
    public void destroy() {
    }

    private class WeightedState {
        private int fixedWeight = 0;
        private int endpointPosition = 0;
        private int currentWeight = 1;
        private int currentCalcWeight = 0;
        private int currentConnectionCount = 0;
        private int minWeight = 0;
        private int maxWeight = 0;
        private String keyToConnectionCount = "";

        public WeightedState(int weight, int endpointPosition, String keyToConnectionCount) {
            this.fixedWeight = weight;
            this.endpointPosition = endpointPosition;
            this.currentWeight = this.fixedWeight;
            this.currentCalcWeight = this.fixedWeight;
            this.keyToConnectionCount = keyToConnectionCount;
            this.maxWeight = this.fixedWeight + 2;
            this.minWeight = this.fixedWeight - 2 > 0 ? this.fixedWeight - 2 : 0;
        }

        public int getEndpointPosition() {
            return this.endpointPosition;
        }

        public int getFixedWeight() {
            return this.fixedWeight;
        }

        public boolean isSendsAvailable() {
            return this.currentCalcWeight > 0;
        }

        public void chosenToSend() {
            --this.currentCalcWeight;
        }

        public int getCurrentWeight() {
            return this.currentWeight;
        }

        public void setMinWeight(int minWeight) {
            this.minWeight = minWeight;
        }

        public String getKeyToConnectionCount() {
            return this.keyToConnectionCount;
        }

        public void setCurrentWeight(int currentWeight) {
            this.currentWeight = currentWeight;
        }

        public void setCurrentConnectionCount(int currentConnectionCount) {
            this.currentConnectionCount = currentConnectionCount;
        }

        public int getCurrentConnectionCount() {
            return this.currentConnectionCount;
        }

        public void setMaxWeight(int maxWeight) {
            this.maxWeight = maxWeight;
        }

        public void reCalcuateWeight() {
            if (WeightedRRLCAlgorithm.this.totalConnections > 0) {
                double connectionRatio;
                double weightRatio = (double)this.fixedWeight / (double)WeightedRRLCAlgorithm.this.totalWeight;
                double diff = weightRatio - (connectionRatio = (double)this.currentConnectionCount / (double)WeightedRRLCAlgorithm.this.totalConnections);
                double multiple = diff * (double)WeightedRRLCAlgorithm.this.totalConnections;
                double floor = Math.floor(multiple);
                this.currentWeight = floor - multiple >= -0.5 ? this.fixedWeight + (int)floor : this.fixedWeight + (int)Math.ceil(multiple);
                this.currentWeight = diff < 0.0 ? (this.minWeight > this.currentWeight ? this.minWeight : this.currentWeight) : (this.maxWeight < this.currentWeight ? this.maxWeight : this.currentWeight);
                this.currentCalcWeight = this.currentWeight;
            }
        }

        public void resetPerRound() {
            this.currentCalcWeight = this.currentWeight;
        }

        public void reset() {
            this.currentWeight = this.fixedWeight;
            this.currentConnectionCount = 0;
            this.currentCalcWeight = this.fixedWeight;
        }
    }
}

