/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.validator;

import javax.xml.namespace.QName;
import org.opensaml.saml1.core.AuthorityBinding;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityBindingSchemaValidator
implements Validator<AuthorityBinding> {
    public void validate(AuthorityBinding authorityBinding) throws ValidationException {
        this.validateAuthorityKind(authorityBinding);
        this.validateBinding(authorityBinding);
        this.validateLocation(authorityBinding);
    }

    protected void validateAuthorityKind(AuthorityBinding authorityBinding) throws ValidationException {
        QName authorityKind = authorityBinding.getAuthorityKind();
        if (authorityKind == null) {
            throw new ValidationException("No AuthorityKind attribute present");
        }
    }

    protected void validateLocation(AuthorityBinding authorityBinding) throws ValidationException {
        if (DatatypeHelper.isEmpty((String)authorityBinding.getLocation())) {
            throw new ValidationException("Location attribute not present or invalid ");
        }
    }

    protected void validateBinding(AuthorityBinding authorityBinding) throws ValidationException {
        if (DatatypeHelper.isEmpty((String)authorityBinding.getBinding())) {
            throw new ValidationException("Binding attribute not present or invalid ");
        }
    }
}

