/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.CompressionSettingsBuilder;
import org.apache.sysds.runtime.compress.CompressionStatistics;
import org.apache.sysds.runtime.compress.cocode.PlanningCoCoder;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupFactory;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorFactory;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CompressedMatrixBlockFactory {
    private static final Log LOG = LogFactory.getLog((String)CompressedMatrixBlockFactory.class.getName());
    private static final CompressionSettings defaultCompressionSettings = new CompressionSettingsBuilder().create();

    public static Pair<MatrixBlock, CompressionStatistics> compress(MatrixBlock mb) {
        return CompressedMatrixBlockFactory.compress(mb, 1, defaultCompressionSettings);
    }

    public static Pair<MatrixBlock, CompressionStatistics> compress(MatrixBlock mb, CompressionSettings customSettings) {
        return CompressedMatrixBlockFactory.compress(mb, 1, customSettings);
    }

    public static Pair<MatrixBlock, CompressionStatistics> compress(MatrixBlock mb, int k) {
        return CompressedMatrixBlockFactory.compress(mb, k, defaultCompressionSettings);
    }

    public static Pair<MatrixBlock, CompressionStatistics> compress(MatrixBlock mb, int k, CompressionSettings compSettings) {
        if (mb instanceof CompressedMatrixBlock) {
            throw new DMLRuntimeException("Redundant compression, block already compressed.");
        }
        Timing time = new Timing(true);
        CompressionStatistics _stats = new CompressionStatistics();
        int numRows = mb.getNumRows();
        int numCols = mb.getNumColumns();
        boolean sparse = mb.isInSparseFormat();
        MatrixBlock rawBlock = !compSettings.transposeInput ? new MatrixBlock(mb) : LibMatrixReorg.transpose(mb, new MatrixBlock(numCols, numRows, sparse), k);
        CompressedSizeEstimator sizeEstimator = CompressedSizeEstimatorFactory.getSizeEstimator(rawBlock, compSettings);
        CompressedSizeInfo sizeInfos = sizeEstimator.computeCompressedSizeInfos(k);
        if (compSettings.investigateEstimate) {
            _stats.estimatedSizeCols = sizeInfos.memoryEstimate();
        }
        _stats.setNextTimePhase(time.stop());
        LOG.debug((Object)"Compression statistics:");
        LOG.debug((Object)("--compression phase 1: " + _stats.getLastTimePhase()));
        if (sizeInfos.colsC.isEmpty()) {
            LOG.info((Object)"Abort block compression because all columns are incompressible.");
            return new ImmutablePair((Object)new MatrixBlock().copyShallow(mb), (Object)_stats);
        }
        List<int[]> coCodeColGroups = PlanningCoCoder.findCoCodesByPartitioning(sizeEstimator, sizeInfos, numRows, k, compSettings);
        _stats.setNextTimePhase(time.stop());
        LOG.debug((Object)("--compression phase 2: " + _stats.getLastTimePhase()));
        ColGroup[] colGroups = ColGroupFactory.compressColGroups(rawBlock, sizeInfos.compRatios, coCodeColGroups, compSettings, k);
        CompressedMatrixBlock res = new CompressedMatrixBlock(mb);
        List<ColGroup> colGroupList = ColGroupFactory.assignColumns(numCols, colGroups, rawBlock, compSettings);
        res.allocateColGroupList(colGroupList);
        _stats.setNextTimePhase(time.stop());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("--compression phase 3: " + _stats.getLastTimePhase()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("--compression phase 4: " + _stats.getLastTimePhase()));
        }
        _stats.size = res.estimateCompressedSizeInMemory();
        _stats.originalSize = mb.estimateSizeInMemory();
        _stats.ratio = (double)_stats.originalSize / (double)_stats.size;
        if (_stats.ratio < 1.0) {
            LOG.info((Object)"Abort block compression because compression ratio is less than 1.");
            return new ImmutablePair((Object)new MatrixBlock().copyShallow(mb), (Object)_stats);
        }
        rawBlock.cleanupBlock(true, true);
        res.cleanupBlock(true, true);
        _stats.setNextTimePhase(time.stop());
        _stats.setColGroupsCounts(colGroupList);
        LOG.debug((Object)("--num col groups: " + colGroupList.size() + ", -- num input cols: " + numCols));
        LOG.debug((Object)("--compression phase 5: " + _stats.getLastTimePhase()));
        LOG.debug((Object)("--col groups types " + _stats.getGroupsTypesString()));
        LOG.debug((Object)("--col groups sizes " + _stats.getGroupsSizesString()));
        LOG.debug((Object)("--compressed size: " + _stats.size));
        LOG.debug((Object)("--compression ratio: " + _stats.ratio));
        if (LOG.isTraceEnabled()) {
            for (ColGroup colGroup : colGroupList) {
                LOG.trace((Object)("--colGroups colIndexes : " + Arrays.toString(colGroup.getColIndices())));
                LOG.trace((Object)("--colGroups type       : " + colGroup.getClass().getSimpleName()));
                LOG.trace((Object)("--colGroups Values     : " + Arrays.toString(colGroup.getValues())));
            }
        }
        return new ImmutablePair((Object)res, (Object)_stats);
    }
}

