/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.NaryOp;
import org.apache.sysds.hops.ParameterizedBuiltinOp;
import org.apache.sysds.hops.ReorgOp;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.DataGenCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.MetaData;
import org.apache.sysds.utils.Explain;

public class LineageRewriteReuse {
    private static final String LR_VAR = "__lrwrt";
    private static BasicProgramBlock _lrPB = null;
    private static ExecutionContext _lrEC = null;
    private static boolean _disableReuse = true;
    private static final Log LOG = LogFactory.getLog((String)LineageRewriteReuse.class.getName());

    public static boolean executeRewrites(Instruction curr, ExecutionContext ec) {
        ExecutionContext lrwec = LineageRewriteReuse.getExecutionContext();
        Explain.ExplainType et = DMLScript.EXPLAIN;
        DMLScript.EXPLAIN = Explain.ExplainType.NONE;
        ArrayList<Instruction> newInst = LineageRewriteReuse.rewriteTsmmCbindOnes(curr, ec, lrwec);
        newInst = newInst == null ? LineageRewriteReuse.rewriteTsmmCbind(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteTsmm2Cbind(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteTsmm2CbindSameLeft(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteTsmmRbind(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteMatMulRbindLeft(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteMatMulCbindRightOnes(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteMatMulCbindRight(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteElementMulRbind(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteElementMulCbind(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteAggregateCbind(curr, ec, lrwec) : newInst;
        newInst = newInst == null ? LineageRewriteReuse.rewriteIndexingMatMul(curr, ec, lrwec) : newInst;
        ArrayList<Instruction> arrayList = newInst = newInst == null ? LineageRewriteReuse.rewritePcaTsmm(curr, ec, lrwec) : newInst;
        if (newInst == null) {
            return false;
        }
        long t0 = System.nanoTime();
        LineageRewriteReuse.executeInst(newInst, lrwec);
        long t1 = System.nanoTime();
        ec.setVariable(((ComputationCPInstruction)curr).output.getName(), lrwec.getVariable(LR_VAR));
        LineageCache.putMatrix(curr, ec, t1 - t0);
        DMLScript.EXPLAIN = et;
        lrwec.getVariables().removeAll();
        return true;
    }

    private static ArrayList<Instruction> rewriteTsmmCbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isTsmmCbind(curr, ec, inCache)) {
            return null;
        }
        MatrixObject cachedEntry = LineageRewriteReuse.toMatrixObject((MatrixBlock)inCache.get("lastMatrix"));
        lrwec.setVariable("cachedEntry", cachedEntry);
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("oldMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("oldMatrix", mo);
        DataOp oldMatrix = inCache.containsKey("X") ? LineageRewriteReuse.setupTReadCachedInput("X", inCache, lrwec) : HopRewriteUtils.createIndexingOp((Hop)newMatrix, 1L, mo.getNumRows(), 1L, mo.getNumColumns() - 1L);
        DataOp lastCol = inCache.containsKey("deltaX") ? LineageRewriteReuse.setupTReadCachedInput("deltaX", inCache, lrwec) : HopRewriteUtils.createIndexingOp((Hop)newMatrix, 1L, mo.getNumRows(), mo.getNumColumns(), mo.getNumColumns());
        Hop lrwHop = HopRewriteUtils.createPartialTsmmCbind(oldMatrix, lastCol, lastRes);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteTsmmCbind APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry", "X", "deltaX");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteTsmmCbindOnes(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isTsmmCbindOnes(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.toMatrixObject(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("newMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("newMatrix", mo);
        AggUnaryOp rowTwo = HopRewriteUtils.createAggUnaryOp(newMatrix, Types.AggOp.SUM, Types.Direction.Col);
        IndexingOp tmp = HopRewriteUtils.createIndexingOp((Hop)rowTwo, new LiteralOp(1L), new LiteralOp(1L), new LiteralOp(1L), new LiteralOp(mo.getNumColumns() - 1L));
        ReorgOp topRight = HopRewriteUtils.createTranspose(tmp);
        BinaryOp rowOne = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)topRight, Types.OpOp2.CBIND);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)rowOne, (Hop)rowTwo, Types.OpOp2.RBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteTsmmCbindOnes APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteTsmmRbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastRow;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isTsmmRbind(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.toMatrixObject(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("oldMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("oldMatrix", mo);
        if (inCache.containsKey("deltaX")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.toMatrixObject(cachedRI));
            lastRow = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            lastRow = HopRewriteUtils.createIndexingOp((Hop)newMatrix, new LiteralOp(mo.getNumRows()), new LiteralOp(mo.getNumRows()), new LiteralOp(1L), new LiteralOp(mo.getNumColumns()));
        }
        ReorgOp tlastRow = HopRewriteUtils.createTranspose(lastRow);
        AggBinaryOp tsmm_lr = HopRewriteUtils.createMatrixMultiply(tlastRow, lastRow);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)tsmm_lr, Types.OpOp2.PLUS);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteTsmmRbind APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry", "deltaX");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteTsmm2Cbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastCol;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isTsmm2Cbind(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        MatrixObject newmo = LineageRewriteReuse.toMatrixObject(cachedEntry);
        lrwec.setVariable("cachedEntry", newmo);
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("oldMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("oldMatrix", mo);
        if (inCache.containsKey("deltaX")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.toMatrixObject(cachedRI));
            lastCol = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            lastCol = HopRewriteUtils.createIndexingOp((Hop)newMatrix, new LiteralOp(1L), new LiteralOp(mo.getNumRows()), new LiteralOp(mo.getNumColumns() - 1L), new LiteralOp(mo.getNumColumns() - 1L));
        }
        ReorgOp tlastCol = HopRewriteUtils.createTranspose(lastCol);
        AggBinaryOp newCol = HopRewriteUtils.createMatrixMultiply(tlastCol, newMatrix);
        ReorgOp tnewCol = HopRewriteUtils.createTranspose(newCol);
        IndexingOp topLeft = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(1L), new LiteralOp(newmo.getNumRows() - 1L), new LiteralOp(1L), new LiteralOp(newmo.getNumColumns() - 1L));
        IndexingOp topRight = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(1L), new LiteralOp(newmo.getNumRows() - 1L), new LiteralOp(newmo.getNumColumns()), new LiteralOp(newmo.getNumColumns()));
        IndexingOp bottomLeft = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumRows()), new LiteralOp(1L), new LiteralOp(newmo.getNumColumns() - 1L));
        IndexingOp bottomRight = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumColumns()), new LiteralOp(newmo.getNumColumns()));
        IndexingOp topCol = HopRewriteUtils.createIndexingOp((Hop)tnewCol, new LiteralOp(1L), new LiteralOp(mo.getNumColumns() - 2L), new LiteralOp(1L), new LiteralOp(1L));
        IndexingOp bottomCol = HopRewriteUtils.createIndexingOp((Hop)tnewCol, new LiteralOp(mo.getNumColumns()), new LiteralOp(mo.getNumColumns()), new LiteralOp(1L), new LiteralOp(1L));
        NaryOp rowOne = HopRewriteUtils.createNary(Types.OpOpN.CBIND, topLeft, topCol, topRight);
        NaryOp rowTwo = HopRewriteUtils.createNary(Types.OpOpN.CBIND, bottomLeft, bottomCol, bottomRight);
        NaryOp lrwHop = HopRewriteUtils.createNary(Types.OpOpN.RBIND, rowOne, newCol, rowTwo);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteTsmm2Cbind APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry", "deltaX");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteTsmm2CbindSameLeft(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastCol;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isTsmm2CbindSameLeft(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        MatrixObject newmo = LineageRewriteReuse.toMatrixObject(cachedEntry);
        lrwec.setVariable("cachedEntry", newmo);
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("oldMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("oldMatrix", mo);
        if (inCache.containsKey("deltaX")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.toMatrixObject(cachedRI));
            lastCol = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            lastCol = HopRewriteUtils.createIndexingOp((Hop)newMatrix, new LiteralOp(1L), new LiteralOp(mo.getNumRows()), new LiteralOp(mo.getNumColumns() - 1L), new LiteralOp(mo.getNumColumns() - 1L));
        }
        ReorgOp tlastCol = HopRewriteUtils.createTranspose(lastCol);
        AggBinaryOp newCol = HopRewriteUtils.createMatrixMultiply(tlastCol, newMatrix);
        ReorgOp tnewCol = HopRewriteUtils.createTranspose(newCol);
        IndexingOp topLeft = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(1L), new LiteralOp(newmo.getNumRows() - 2L), new LiteralOp(1L), new LiteralOp(newmo.getNumColumns() - 2L));
        IndexingOp topRight = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(1L), new LiteralOp(newmo.getNumRows() - 2L), new LiteralOp(newmo.getNumColumns()), new LiteralOp(newmo.getNumColumns()));
        IndexingOp bottomLeft = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumRows()), new LiteralOp(1L), new LiteralOp(newmo.getNumColumns() - 2L));
        IndexingOp bottomRight = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumColumns()), new LiteralOp(newmo.getNumColumns()));
        IndexingOp topCol = HopRewriteUtils.createIndexingOp((Hop)tnewCol, new LiteralOp(1L), new LiteralOp(mo.getNumColumns() - 2L), new LiteralOp(1L), new LiteralOp(1L));
        IndexingOp bottomCol = HopRewriteUtils.createIndexingOp((Hop)tnewCol, new LiteralOp(mo.getNumColumns()), new LiteralOp(mo.getNumColumns()), new LiteralOp(1L), new LiteralOp(1L));
        NaryOp rowOne = HopRewriteUtils.createNary(Types.OpOpN.CBIND, topLeft, topCol, topRight);
        NaryOp rowTwo = HopRewriteUtils.createNary(Types.OpOpN.CBIND, bottomLeft, bottomCol, bottomRight);
        NaryOp lrwHop = HopRewriteUtils.createNary(Types.OpOpN.RBIND, rowOne, newCol, rowTwo);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteTsmm2CbindSameLeft APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry", "deltaX");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteMatMulRbindLeft(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isMatMulRbindLeft(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.toMatrixObject(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject moL = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("leftMatrix", moL);
        DataOp leftMatrix = HopRewriteUtils.createTransientRead("leftMatrix", moL);
        MatrixObject moR = ec.getMatrixObject(((ComputationCPInstruction)curr).input2);
        lrwec.setVariable("rightMatrix", moR);
        DataOp rightMatrix = HopRewriteUtils.createTransientRead("rightMatrix", moR);
        if (inCache.containsKey("deltaX")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.toMatrixObject(cachedRI));
            DataOp dataOp = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        }
        IndexingOp lastRow = HopRewriteUtils.createIndexingOp((Hop)leftMatrix, new LiteralOp(moL.getNumRows()), new LiteralOp(moL.getNumRows()), new LiteralOp(1L), new LiteralOp(moL.getNumColumns()));
        AggBinaryOp rowTwo = HopRewriteUtils.createMatrixMultiply(lastRow, rightMatrix);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)rowTwo, Types.OpOp2.RBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteMetMulRbindLeft APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry", "deltaX");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteMatMulCbindRight(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isMatMulCbindRight(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.toMatrixObject(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject moL = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("leftMatrix", moL);
        DataOp leftMatrix = HopRewriteUtils.createTransientRead("leftMatrix", moL);
        MatrixObject moR = ec.getMatrixObject(((ComputationCPInstruction)curr).input2);
        lrwec.setVariable("rightMatrix", moR);
        DataOp rightMatrix = HopRewriteUtils.createTransientRead("rightMatrix", moR);
        if (inCache.containsKey("deltaY")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaY");
            lrwec.setVariable("deltaY", LineageRewriteReuse.toMatrixObject(cachedRI));
            DataOp dataOp = HopRewriteUtils.createTransientRead("deltaY", cachedRI);
        }
        IndexingOp lastCol = HopRewriteUtils.createIndexingOp((Hop)rightMatrix, new LiteralOp(1L), new LiteralOp(moR.getNumRows()), new LiteralOp(moR.getNumColumns()), new LiteralOp(moR.getNumColumns()));
        AggBinaryOp colTwo = HopRewriteUtils.createMatrixMultiply(leftMatrix, lastCol);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)colTwo, Types.OpOp2.CBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteMatMulCbindRight APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry", "deltaY");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteMatMulCbindRightOnes(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isMatMulCbindRightOnes(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.toMatrixObject(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        MatrixObject moL = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("leftMatrix", moL);
        DataOp leftMatrix = HopRewriteUtils.createTransientRead("leftMatrix", moL);
        AggUnaryOp colTwo = HopRewriteUtils.createAggUnaryOp(leftMatrix, Types.AggOp.SUM, Types.Direction.Row);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)colTwo, Types.OpOp2.CBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteMatMulCbindRightOnes APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteElementMulRbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastRowR;
        Hop lastRowL;
        MatrixBlock cachedRI;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isElementMulRbind(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.toMatrixObject(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        if (inCache.containsKey("deltaX")) {
            cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.toMatrixObject(cachedRI));
            lastRowL = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            MatrixObject moL = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
            lrwec.setVariable("leftMatrix", moL);
            DataOp leftMatrix = HopRewriteUtils.createTransientRead("leftMatrix", moL);
            lastRowL = HopRewriteUtils.createIndexingOp((Hop)leftMatrix, new LiteralOp(moL.getNumRows()), new LiteralOp(moL.getNumRows()), new LiteralOp(1L), new LiteralOp(moL.getNumColumns()));
        }
        if (inCache.containsKey("deltaY")) {
            cachedRI = (MatrixBlock)inCache.get("deltaY");
            lrwec.setVariable("deltaY", LineageRewriteReuse.toMatrixObject(cachedRI));
            lastRowR = HopRewriteUtils.createTransientRead("deltaY", cachedRI);
        } else {
            MatrixObject moR = ec.getMatrixObject(((ComputationCPInstruction)curr).input2);
            lrwec.setVariable("rightMatrix", moR);
            DataOp rightMatrix = HopRewriteUtils.createTransientRead("rightMatrix", moR);
            lastRowR = HopRewriteUtils.createIndexingOp((Hop)rightMatrix, new LiteralOp(moR.getNumRows()), new LiteralOp(moR.getNumRows()), new LiteralOp(1L), new LiteralOp(moR.getNumColumns()));
        }
        BinaryOp rowTwo = HopRewriteUtils.createBinary(lastRowL, lastRowR, Types.OpOp2.MULT);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)rowTwo, Types.OpOp2.RBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteElementMulRbind APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry", "deltaX", "deltaY");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteElementMulCbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastColR;
        Hop lastColL;
        MatrixBlock cachedRI;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isElementMulCbind(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.toMatrixObject(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        if (inCache.containsKey("deltaX")) {
            cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.toMatrixObject(cachedRI));
            lastColL = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            MatrixObject moL = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
            lrwec.setVariable("leftMatrix", moL);
            DataOp leftMatrix = HopRewriteUtils.createTransientRead("leftMatrix", moL);
            lastColL = HopRewriteUtils.createIndexingOp((Hop)leftMatrix, new LiteralOp(1L), new LiteralOp(moL.getNumRows()), new LiteralOp(moL.getNumColumns()), new LiteralOp(moL.getNumColumns()));
        }
        if (inCache.containsKey("deltaY")) {
            cachedRI = (MatrixBlock)inCache.get("deltaY");
            lrwec.setVariable("deltaY", LineageRewriteReuse.toMatrixObject(cachedRI));
            lastColR = HopRewriteUtils.createTransientRead("deltaY", cachedRI);
        } else {
            MatrixObject moR = ec.getMatrixObject(((ComputationCPInstruction)curr).input2);
            lrwec.setVariable("rightMatrix", moR);
            DataOp rightMatrix = HopRewriteUtils.createTransientRead("rightMatrix", moR);
            lastColR = HopRewriteUtils.createIndexingOp((Hop)rightMatrix, new LiteralOp(1L), new LiteralOp(moR.getNumRows()), new LiteralOp(moR.getNumColumns()), new LiteralOp(moR.getNumColumns()));
        }
        BinaryOp rowTwo = HopRewriteUtils.createBinary(lastColL, lastColR, Types.OpOp2.MULT);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)rowTwo, Types.OpOp2.CBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteElementMulCbind APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry", "deltaX", "deltaY");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteAggregateCbind(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop lastCol;
        int ngroups;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isAggCbind(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock cachedEntry = (MatrixBlock)inCache.get("lastMatrix");
        lrwec.setVariable("cachedEntry", LineageRewriteReuse.toMatrixObject(cachedEntry));
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", cachedEntry);
        HashMap<String, String> params = ((ParameterizedBuiltinCPInstruction)curr).getParameterMap();
        MatrixObject mo = ec.getMatrixObject(params.get("target"));
        lrwec.setVariable("oldMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("oldMatrix", mo);
        MatrixObject moG = ec.getMatrixObject(params.get("groups"));
        lrwec.setVariable("groups", moG);
        DataOp groups = HopRewriteUtils.createTransientRead("groups", moG);
        String fn = params.get("fn");
        int n = ngroups = params.get("ngroups") != null ? (int)Double.parseDouble(params.get("ngroups")) : -1;
        if (inCache.containsKey("deltaX")) {
            MatrixBlock cachedRI = (MatrixBlock)inCache.get("deltaX");
            lrwec.setVariable("deltaX", LineageRewriteReuse.toMatrixObject(cachedRI));
            lastCol = HopRewriteUtils.createTransientRead("deltaX", cachedRI);
        } else {
            lastCol = HopRewriteUtils.createIndexingOp((Hop)newMatrix, new LiteralOp(1L), new LiteralOp(mo.getNumRows()), new LiteralOp(mo.getNumColumns()), new LiteralOp(mo.getNumColumns()));
        }
        LinkedHashMap<String, Hop> args = new LinkedHashMap<String, Hop>();
        args.put("target", lastCol);
        args.put("groups", groups);
        args.put("fn", new LiteralOp(fn));
        if (ngroups != -1) {
            args.put("ngroups", new LiteralOp(ngroups));
        }
        ParameterizedBuiltinOp rowTwo = HopRewriteUtils.createParameterizedBuiltinOp(newMatrix, args, Types.ParamBuiltinOp.GROUPEDAGG);
        BinaryOp lrwHop = HopRewriteUtils.createBinary((Hop)lastRes, (Hop)rowTwo, Types.OpOp2.CBIND);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteElementMulCbind APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry", "deltaX");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewriteIndexingMatMul(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        Hop matMultRes;
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isIndexingMatMul(curr, ec, inCache)) {
            return null;
        }
        MatrixBlock indexSource = (MatrixBlock)inCache.get("indexSource");
        lrwec.setVariable("indexSource", LineageRewriteReuse.toMatrixObject(indexSource));
        DataOp input2Index = HopRewriteUtils.createTransientRead("indexSource", indexSource);
        MatrixObject moL = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        if (inCache.containsKey("BigMatMult")) {
            MatrixObject BigMatMult = LineageRewriteReuse.toMatrixObject((MatrixBlock)inCache.get("BigMatMult"));
            lrwec.setVariable("BigMatMult", BigMatMult);
            matMultRes = HopRewriteUtils.createTransientRead("BigMatMult", BigMatMult);
        } else {
            lrwec.setVariable("left", moL);
            DataOp leftMatrix = HopRewriteUtils.createTransientRead("left", moL);
            matMultRes = HopRewriteUtils.createMatrixMultiply(leftMatrix, input2Index);
        }
        MatrixObject moR = ec.getMatrixObject(((ComputationCPInstruction)curr).input2);
        IndexingOp lrwHop = HopRewriteUtils.createIndexingOp(matMultRes, new LiteralOp(1L), new LiteralOp(moL.getNumRows()), new LiteralOp(1L), new LiteralOp(moR.getNumColumns()));
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewriteIndexingMatMul APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = false;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "indexSource", "BigMatMult");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static ArrayList<Instruction> rewritePcaTsmm(Instruction curr, ExecutionContext ec, ExecutionContext lrwec) {
        HashMap<String, MatrixBlock> inCache = new HashMap<String, MatrixBlock>();
        if (!LineageRewriteReuse.isPcaTsmm(curr, ec, inCache)) {
            return null;
        }
        MatrixObject newmo = LineageRewriteReuse.toMatrixObject((MatrixBlock)inCache.get("lastMatrix"));
        lrwec.setVariable("cachedEntry", newmo);
        DataOp lastRes = HopRewriteUtils.createTransientRead("cachedEntry", newmo);
        MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)curr).input1);
        lrwec.setVariable("oldMatrix", mo);
        DataOp newMatrix = HopRewriteUtils.createTransientRead("oldMatrix", mo);
        MatrixObject projmo = LineageRewriteReuse.toMatrixObject((MatrixBlock)inCache.get("projected"));
        lrwec.setVariable("projected", projmo);
        DataOp projRes = HopRewriteUtils.createTransientRead("projected", projmo);
        IndexingOp lastCol = HopRewriteUtils.createIndexingOp((Hop)projRes, new LiteralOp(1L), new LiteralOp(projmo.getNumRows()), new LiteralOp(projmo.getNumColumns()), new LiteralOp(projmo.getNumColumns()));
        ReorgOp tlastCol = HopRewriteUtils.createTranspose(lastCol);
        AggBinaryOp newCol = HopRewriteUtils.createMatrixMultiply(tlastCol, newMatrix);
        ReorgOp tnewCol = HopRewriteUtils.createTranspose(newCol);
        IndexingOp topLeft = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(1L), new LiteralOp(newmo.getNumRows() - 1L), new LiteralOp(1L), new LiteralOp(newmo.getNumColumns() - 1L));
        IndexingOp topRight = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(1L), new LiteralOp(newmo.getNumRows() - 1L), new LiteralOp(newmo.getNumColumns()), new LiteralOp(newmo.getNumColumns()));
        IndexingOp bottomLeft = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumRows()), new LiteralOp(1L), new LiteralOp(newmo.getNumColumns() - 1L));
        IndexingOp bottomRight = HopRewriteUtils.createIndexingOp((Hop)lastRes, new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumRows()), new LiteralOp(newmo.getNumColumns()), new LiteralOp(newmo.getNumColumns()));
        IndexingOp topCol = HopRewriteUtils.createIndexingOp((Hop)tnewCol, new LiteralOp(1L), new LiteralOp(mo.getNumColumns() - 2L), new LiteralOp(1L), new LiteralOp(1L));
        IndexingOp bottomCol = HopRewriteUtils.createIndexingOp((Hop)tnewCol, new LiteralOp(mo.getNumColumns()), new LiteralOp(mo.getNumColumns()), new LiteralOp(1L), new LiteralOp(1L));
        NaryOp rowOne = HopRewriteUtils.createNary(Types.OpOpN.CBIND, topLeft, topCol, topRight);
        NaryOp rowTwo = HopRewriteUtils.createNary(Types.OpOpN.CBIND, bottomLeft, bottomCol, bottomRight);
        NaryOp lrwHop = HopRewriteUtils.createNary(Types.OpOpN.RBIND, rowOne, newCol, rowTwo);
        DataOp lrwWrite = HopRewriteUtils.createTransientWrite(LR_VAR, lrwHop);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LINEAGE REWRITE rewritePcaTsmm APPLIED");
        }
        ArrayList<Instruction> inst = LineageRewriteReuse.genInst(lrwWrite, lrwec);
        _disableReuse = true;
        LineageRewriteReuse.addRmvarInstructions(inst, lrwec, "cachedEntry", "projected");
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementPRewrites();
        }
        return inst;
    }

    private static boolean isTsmmCbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        LineageItem source;
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("tsmm") && (source = item.getInputs()[0]).getOpcode().equalsIgnoreCase("cbind")) {
            LineageItem input1 = source.getInputs()[0];
            LineageItem tmp = new LineageItem(curr.getOpcode(), new LineageItem[]{input1});
            if (LineageCache.probe(tmp)) {
                inCache.put("lastMatrix", LineageCache.getMatrix(tmp));
            }
            if (LineageCache.probe(input1)) {
                inCache.put("X", LineageCache.getMatrix(input1));
            }
            if (LineageCache.probe(source.getInputs()[1])) {
                inCache.put("deltaX", LineageCache.getMatrix(source.getInputs()[1]));
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isTsmmCbindOnes(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        LineageItem source;
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("tsmm") && (source = item.getInputs()[0]).getOpcode().equalsIgnoreCase("cbind")) {
            LineageItem input2 = source.getInputs()[1];
            if (input2.getType() != LineageItem.LineageItemType.Creation) {
                return false;
            }
            Instruction ins = InstructionParser.parseSingleInstruction(input2.getData());
            if (!((DataGenCPInstruction)ins).isOnesCol()) {
                return false;
            }
            LineageItem input1 = source.getInputs()[0];
            LineageItem tmp = new LineageItem(curr.getOpcode(), new LineageItem[]{input1});
            if (LineageCache.probe(input1)) {
                inCache.put("X", LineageCache.getMatrix(input1));
            }
            if (LineageCache.probe(tmp)) {
                inCache.put("lastMatrix", LineageCache.getMatrix(tmp));
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isTsmmRbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        LineageItem source;
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("tsmm") && (source = item.getInputs()[0]).getOpcode().equalsIgnoreCase("rbind")) {
            LineageItem input1 = source.getInputs()[0];
            LineageItem tmp = new LineageItem(curr.getOpcode(), new LineageItem[]{input1});
            if (LineageCache.probe(tmp)) {
                inCache.put("lastMatrix", LineageCache.getMatrix(tmp));
            }
            if (source.getInputs().length > 1 && LineageCache.probe(source.getInputs()[1])) {
                inCache.put("deltaX", LineageCache.getMatrix(source.getInputs()[1]));
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isTsmm2Cbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        LineageItem input;
        LineageItem source;
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("tsmm") && (source = item.getInputs()[0]).getOpcode().equalsIgnoreCase("cbind") && (input = source.getInputs()[0]).getOpcode().equalsIgnoreCase("cbind")) {
            LineageItem L2appin1 = input.getInputs()[0];
            LineageItem tmp = new LineageItem("cbind", new LineageItem[]{L2appin1, source.getInputs()[1]});
            LineageItem toProbe = new LineageItem(curr.getOpcode(), new LineageItem[]{tmp});
            if (LineageCache.probe(toProbe)) {
                inCache.put("lastMatrix", LineageCache.getMatrix(toProbe));
            }
            if (LineageCache.probe(input.getInputs()[1])) {
                inCache.put("deltaX", LineageCache.getMatrix(input.getInputs()[1]));
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isTsmm2CbindSameLeft(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        LineageItem input;
        LineageItem source;
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("tsmm") && (source = item.getInputs()[0]).getOpcode().equalsIgnoreCase("cbind") && (input = source.getInputs()[0]).getOpcode().equalsIgnoreCase("cbind")) {
            LineageItem L2appin1 = input.getInputs()[0];
            if (!L2appin1.getOpcode().equalsIgnoreCase("rightIndex")) {
                return false;
            }
            LineageItem RI = input.getInputs()[1];
            if (LineageCache.probe(RI)) {
                inCache.put("deltaX", LineageCache.getMatrix(RI));
            }
            LineageItem cu = RI.getInputs()[4];
            LineageItem old_cu = LineageRewriteReuse.reduceColByOne(cu);
            LineageItem old_RI = new LineageItem("rightIndex", new LineageItem[]{RI.getInputs()[0], RI.getInputs()[1], RI.getInputs()[2], old_cu, old_cu});
            LineageItem old_cbind = new LineageItem("cbind", new LineageItem[]{L2appin1, old_RI});
            LineageItem tmp = new LineageItem("cbind", new LineageItem[]{old_cbind, source.getInputs()[1]});
            LineageItem toProbe = new LineageItem(curr.getOpcode(), new LineageItem[]{tmp});
            if (LineageCache.probe(toProbe)) {
                inCache.put("lastMatrix", LineageCache.getMatrix(toProbe));
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isMatMulRbindLeft(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("ba+*")) {
            LineageItem left = item.getInputs()[0];
            LineageItem right = item.getInputs()[1];
            if (left.getOpcode().equalsIgnoreCase("rbind")) {
                LineageItem leftSource = left.getInputs()[0];
                LineageItem tmp = new LineageItem(curr.getOpcode(), new LineageItem[]{leftSource, right});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.getMatrix(tmp));
                }
                if (LineageCache.probe(left.getInputs()[1])) {
                    inCache.put("deltaX", LineageCache.getMatrix(left.getInputs()[1]));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isMatMulCbindRight(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("ba+*")) {
            LineageItem left = item.getInputs()[0];
            LineageItem right = item.getInputs()[1];
            if (right.getOpcode().equalsIgnoreCase("cbind")) {
                LineageItem rightSource = right.getInputs()[0];
                LineageItem tmp = new LineageItem(curr.getOpcode(), new LineageItem[]{left, rightSource});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.getMatrix(tmp));
                }
                if (LineageCache.probe(right.getInputs()[1])) {
                    inCache.put("deltaY", LineageCache.getMatrix(right.getInputs()[1]));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isMatMulCbindRightOnes(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("ba+*")) {
            LineageItem left = item.getInputs()[0];
            LineageItem right = item.getInputs()[1];
            if (right.getOpcode().equalsIgnoreCase("cbind")) {
                LineageItem rightSource1 = right.getInputs()[0];
                LineageItem rightSource2 = right.getInputs()[1];
                if (rightSource2.getType() != LineageItem.LineageItemType.Creation) {
                    return false;
                }
                Instruction ins = InstructionParser.parseSingleInstruction(rightSource2.getData());
                if (!((DataGenCPInstruction)ins).isOnesCol()) {
                    return false;
                }
                LineageItem tmp = new LineageItem(curr.getOpcode(), new LineageItem[]{left, rightSource1});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.getMatrix(tmp));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isElementMulRbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("*")) {
            LineageItem left = item.getInputs()[0];
            LineageItem right = item.getInputs()[1];
            if (left.getOpcode().equalsIgnoreCase("rbind") && right.getOpcode().equalsIgnoreCase("rbind")) {
                LineageItem leftSource = left.getInputs()[0];
                LineageItem rightSource = right.getInputs()[0];
                LineageItem tmp = new LineageItem(curr.getOpcode(), new LineageItem[]{leftSource, rightSource});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.getMatrix(tmp));
                }
                if (LineageCache.probe(left.getInputs()[1])) {
                    inCache.put("deltaX", LineageCache.getMatrix(left.getInputs()[1]));
                }
                if (LineageCache.probe(right.getInputs()[1])) {
                    inCache.put("deltaY", LineageCache.getMatrix(right.getInputs()[1]));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isElementMulCbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("*")) {
            LineageItem left = item.getInputs()[0];
            LineageItem right = item.getInputs()[1];
            if (left.getOpcode().equalsIgnoreCase("cbind") && right.getOpcode().equalsIgnoreCase("cbind")) {
                LineageItem leftSource = left.getInputs()[0];
                LineageItem rightSource = right.getInputs()[0];
                LineageItem tmp = new LineageItem(curr.getOpcode(), new LineageItem[]{leftSource, rightSource});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.getMatrix(tmp));
                }
                if (LineageCache.probe(left.getInputs()[1])) {
                    inCache.put("deltaX", LineageCache.getMatrix(left.getInputs()[1]));
                }
                if (LineageCache.probe(right.getInputs()[1])) {
                    inCache.put("deltaY", LineageCache.getMatrix(right.getInputs()[1]));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isAggCbind(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("groupedagg")) {
            LineageItem target = item.getInputs()[0];
            LineageItem groups = item.getInputs()[1];
            LineageItem weights = item.getInputs()[2];
            LineageItem fn = item.getInputs()[3];
            LineageItem ngroups = item.getInputs()[4];
            if (target.getOpcode().equalsIgnoreCase("cbind")) {
                LineageItem input1 = target.getInputs()[0];
                LineageItem tmp = new LineageItem(curr.getOpcode(), new LineageItem[]{input1, groups, weights, fn, ngroups});
                if (LineageCache.probe(tmp)) {
                    inCache.put("lastMatrix", LineageCache.getMatrix(tmp));
                }
                if (LineageCache.probe(target.getInputs()[1])) {
                    inCache.put("deltaX", LineageCache.getMatrix(target.getInputs()[1]));
                }
            }
        }
        return inCache.containsKey("lastMatrix");
    }

    private static boolean isIndexingMatMul(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("ba+*")) {
            LineageItem left = item.getInputs()[0];
            LineageItem right = item.getInputs()[1];
            if (right.getOpcode().equalsIgnoreCase("rightIndex")) {
                LineageItem tmp;
                LineageItem indexSource = right.getInputs()[0];
                if (LineageCache.probe(indexSource) && indexSource.getOpcode().equalsIgnoreCase("ba+*")) {
                    inCache.put("indexSource", LineageCache.getMatrix(indexSource));
                }
                if (LineageCache.probe(tmp = new LineageItem(item.getOpcode(), new LineageItem[]{left, indexSource}))) {
                    inCache.put("BigMatMult", LineageCache.getMatrix(tmp));
                }
            }
        }
        return inCache.containsKey("indexSource");
    }

    private static boolean isPcaTsmm(Instruction curr, ExecutionContext ec, Map<String, MatrixBlock> inCache) {
        LineageItem src1;
        if (!LineageCacheConfig.isReusable(curr, ec)) {
            return false;
        }
        LineageItem item = (LineageItem)((ComputationCPInstruction)curr).getLineageItem(ec).getValue();
        if (curr.getOpcode().equalsIgnoreCase("tsmm") && (src1 = item.getInputs()[0]).getOpcode().equalsIgnoreCase("cbind")) {
            LineageItem src21 = src1.getInputs()[0];
            LineageItem src22 = src1.getInputs()[1];
            if (src21.getOpcode().equalsIgnoreCase("ba+*")) {
                if (LineageCache.probe(src21)) {
                    inCache.put("projected", LineageCache.getMatrix(src21));
                }
                LineageItem src31 = src21.getInputs()[1];
                LineageItem src32 = src21.getInputs()[0];
                if (src31.getOpcode().equalsIgnoreCase("rightIndex")) {
                    LineageItem cu = src31.getInputs()[4];
                    LineageItem old_cu = LineageRewriteReuse.reduceColByOne(cu);
                    LineageItem old_RI = new LineageItem("rightIndex", new LineageItem[]{src31.getInputs()[0], src31.getInputs()[1], src31.getInputs()[2], src31.getInputs()[3], old_cu});
                    LineageItem old_ba = new LineageItem("ba+*", new LineageItem[]{src32, old_RI});
                    LineageItem old_cbind = new LineageItem("cbind", new LineageItem[]{old_ba, src22});
                    LineageItem old_tsmm = new LineageItem("tsmm", new LineageItem[]{old_cbind});
                    if (LineageCache.probe(old_tsmm)) {
                        inCache.put("lastMatrix", LineageCache.getMatrix(old_tsmm));
                    }
                }
            }
        }
        return inCache.containsKey("projected") && inCache.containsKey("lastMatrix");
    }

    private static ArrayList<Instruction> genInst(Hop hops, ExecutionContext ec) {
        ArrayList<Instruction> newInst = Recompiler.recompileHopsDag(hops, ec.getVariables(), null, true, true, 0L);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"COMPENSATION PLAN: ");
            LOG.debug((Object)("EXPLAIN LINEAGE REWRITE (HOP) \n" + Explain.explain(hops, 1)));
            LOG.debug((Object)("EXPLAIN LINEAGE REWRITE (INSTRUCTION) \n" + Explain.explain(newInst, 1)));
        }
        return newInst;
    }

    private static DataOp setupTReadCachedInput(String name, Map<String, MatrixBlock> inCache, ExecutionContext ec) {
        MatrixBlock cachedRI = inCache.get(name);
        ec.setVariable(name, LineageRewriteReuse.toMatrixObject(cachedRI));
        return HopRewriteUtils.createTransientRead(name, cachedRI);
    }

    private static void executeInst(ArrayList<Instruction> newInst, ExecutionContext lrwec) {
        DMLScript.EXPLAIN = Explain.ExplainType.NONE;
        try {
            BasicProgramBlock pb = LineageRewriteReuse.getProgramBlock();
            pb.setInstructions(newInst);
            LineageCacheConfig.ReuseCacheType oldReuseOption = DMLScript.LINEAGE_REUSE;
            if (_disableReuse) {
                LineageCacheConfig.shutdownReuse();
            }
            pb.execute(lrwec);
            if (_disableReuse) {
                LineageCacheConfig.restartReuse(oldReuseOption);
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Error executing lineage rewrites", e);
        }
    }

    private static MatrixObject toMatrixObject(MatrixBlock mb) {
        MetaData md = new MetaData(mb.getDataCharacteristics());
        MatrixObject mo = new MatrixObject(Types.ValueType.FP64, null, md);
        mo.acquireModify(mb);
        mo.release();
        return mo;
    }

    private static void addRmvarInstructions(ArrayList<Instruction> inst, ExecutionContext ec, String ... varnames) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (String varname : varnames) {
            if (!ec.containsVariable(varname)) continue;
            tmp.add(varname);
        }
        inst.add(VariableCPInstruction.prepareRemoveInstruction(tmp.toArray(new String[0])));
    }

    private static LineageItem reduceColByOne(LineageItem cu) {
        String old_data = null;
        try {
            String data = cu.getData();
            String[] parts = data.split("\u00b7");
            float cuNum = Float.valueOf(parts[0]).floatValue();
            parts[0] = String.valueOf((int)cuNum - 1);
            old_data = InstructionUtils.concatOperandParts(parts);
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Error reading 'cu' from RightIndex instruction", e);
        }
        return new LineageItem(old_data);
    }

    private static ExecutionContext getExecutionContext() {
        if (_lrEC == null) {
            _lrEC = ExecutionContextFactory.createContext();
        }
        return _lrEC;
    }

    private static BasicProgramBlock getProgramBlock() {
        if (_lrPB == null) {
            _lrPB = new BasicProgramBlock(new Program());
        }
        return _lrPB;
    }
}

