/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDenseSingleBlockTransposed
extends ReaderColumnSelection {
    private double[] _data;

    public ReaderColumnSelectionDenseSingleBlockTransposed(MatrixBlock data, int[] colIndexes) {
        super((int[])colIndexes.clone(), data.getNumColumns());
        this._data = data.getDenseBlockValues();
        if (data.getDenseBlock().numBlocks() > 1) {
            throw new DMLCompressionException("Not handling multi block data reading in dense transposed reader");
        }
        for (int i = 0; i < this._colIndexes.length; ++i) {
            this._colIndexes[i] = this._colIndexes[i] * data.getNumColumns();
        }
    }

    @Override
    protected DblArray getNextRow() {
        if (this._lastRow == this._numRows - 1) {
            return null;
        }
        ++this._lastRow;
        boolean empty = true;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            int n = i;
            int n2 = this._colIndexes[n];
            this._colIndexes[n] = n2 + 1;
            double v = this._data[n2];
            if (v != 0.0) {
                empty = false;
            }
            this.reusableArr[i] = v;
        }
        return empty ? this.emptyReturn : this.reusableReturn;
    }
}

