/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.tokenize;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.transform.tokenize.Tokenizer;
import org.apache.sysds.runtime.transform.tokenize.TokenizerPost;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONObject;

public class TokenizerPostPosition
implements TokenizerPost {
    private static final long serialVersionUID = 3563407270742660830L;
    private final int numIdCols;
    private final int maxTokens;
    private final boolean wideFormat;

    public TokenizerPostPosition(JSONObject params, int numIdCols, int maxTokens, boolean wideFormat) {
        this.numIdCols = numIdCols;
        this.maxTokens = maxTokens;
        this.wideFormat = wideFormat;
    }

    @Override
    public FrameBlock tokenizePost(List<Tokenizer.DocumentToTokens> tl, FrameBlock out) {
        for (Tokenizer.DocumentToTokens docToToken : tl) {
            List<Object> keys = docToToken.keys;
            List<Tokenizer.Token> tokenList = docToToken.tokens;
            if (this.wideFormat) {
                this.appendTokensWide(keys, tokenList, out);
                continue;
            }
            this.appendTokensLong(keys, tokenList, out);
        }
        return out;
    }

    public void appendTokensLong(List<Object> keys, List<Tokenizer.Token> tokenList, FrameBlock out) {
        int numTokens = 0;
        for (Tokenizer.Token token : tokenList) {
            if (numTokens >= this.maxTokens) break;
            ArrayList<Object> rowList = new ArrayList<Object>(keys);
            rowList.add(token.startIndex + 1L);
            rowList.add(token.textToken);
            Object[] row = new Object[rowList.size()];
            rowList.toArray(row);
            out.appendRow(row);
            ++numTokens;
        }
    }

    public void appendTokensWide(List<Object> keys, List<Tokenizer.Token> tokenList, FrameBlock out) {
        ArrayList<Object> rowList = new ArrayList<Object>(keys);
        int numTokens = 0;
        for (Tokenizer.Token token : tokenList) {
            if (numTokens >= this.maxTokens) break;
            rowList.add(token.textToken);
            ++numTokens;
        }
        while (numTokens < this.maxTokens) {
            rowList.add("");
            ++numTokens;
        }
        Object[] row = new Object[rowList.size()];
        rowList.toArray(row);
        out.appendRow(row);
    }

    @Override
    public Types.ValueType[] getOutSchema() {
        if (this.wideFormat) {
            return TokenizerPostPosition.getOutSchemaWide(this.numIdCols, this.maxTokens);
        }
        return TokenizerPostPosition.getOutSchemaLong(this.numIdCols);
    }

    private static Types.ValueType[] getOutSchemaWide(int numIdCols, int maxTokens) {
        Types.ValueType[] schema = UtilFunctions.nCopies(numIdCols + maxTokens, Types.ValueType.STRING);
        return schema;
    }

    private static Types.ValueType[] getOutSchemaLong(int numIdCols) {
        Types.ValueType[] schema = new Types.ValueType[numIdCols + 2];
        for (int i = 0; i < numIdCols; ++i) {
            schema[i] = Types.ValueType.STRING;
        }
        schema[i] = Types.ValueType.INT64;
        schema[i + 1] = Types.ValueType.STRING;
        return schema;
    }

    @Override
    public long getNumRows(long inRows) {
        if (this.wideFormat) {
            return inRows;
        }
        return inRows * (long)this.maxTokens;
    }

    @Override
    public long getNumCols() {
        return this.getOutSchema().length;
    }
}

