/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.parser.DataExpression;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.ExecutionContextMap;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkerHandlerException;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataAll;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.privacy.DMLPrivacyException;
import org.apache.sysds.runtime.privacy.PrivacyMonitor;
import org.apache.sysds.utils.Statistics;

public class FederatedWorkerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(FederatedWorkerHandler.class);
    private final ExecutionContextMap _ecm;

    public FederatedWorkerHandler(ExecutionContextMap ecm) {
        this._ecm = ecm;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ctx.writeAndFlush((Object)this.createResponse(msg)).addListener((GenericFutureListener)new CloseListener());
    }

    protected FederatedResponse createResponse(Object msg) {
        if (!(msg instanceof FederatedRequest[])) {
            return new FederatedResponse(FederatedResponse.ResponseType.ERROR, new FederatedWorkerHandlerException("Received object of wrong instance 'FederatedRequest[]'."));
        }
        Object[] requests = (FederatedRequest[])msg;
        try {
            return this.createResponse((FederatedRequest[])requests);
        }
        catch (FederatedWorkerHandlerException | DMLPrivacyException ex) {
            return new FederatedResponse(FederatedResponse.ResponseType.ERROR, ex);
        }
        catch (Exception ex) {
            String error = "Exception thrown while processing requests:\n" + Arrays.toString(requests);
            LOG.error((Object)error, (Throwable)ex);
            return new FederatedResponse(FederatedResponse.ResponseType.ERROR, new FederatedWorkerHandlerException(error));
        }
    }

    private FederatedResponse createResponse(FederatedRequest[] requests) throws DMLPrivacyException, FederatedWorkerHandlerException, Exception {
        FederatedResponse response = null;
        boolean containsCLEAR = false;
        for (int i = 0; i < requests.length; ++i) {
            FederatedRequest request = requests[i];
            FederatedRequest.RequestType t = request.getType();
            FederatedWorkerHandler.logRequests(request, i, requests.length);
            PrivacyMonitor.setCheckPrivacy(request.checkPrivacy());
            PrivacyMonitor.clearCheckedConstraints();
            FederatedResponse tmp = this.executeCommand(request);
            FederatedWorkerHandler.conditionalAddCheckedConstraints(request, tmp);
            if (!tmp.isSuccessful()) {
                LOG.error((Object)("Command " + (Object)((Object)t) + " resulted in error:\n" + tmp.getErrorMessage()));
                return tmp;
            }
            if (t == FederatedRequest.RequestType.GET_VAR) {
                if (response != null) {
                    String message = "Multiple GET_VAR are not supported in single batch of requests.";
                    LOG.error((Object)message);
                    throw new FederatedWorkerHandlerException(message);
                }
                response = tmp;
            } else if (response == null && i == requests.length - 1) {
                response = tmp;
            }
            if (t != FederatedRequest.RequestType.CLEAR) continue;
            containsCLEAR = true;
        }
        if (containsCLEAR) {
            FederatedWorkerHandler.printStatistics();
        }
        return response;
    }

    private static void printStatistics() {
        if (DMLScript.STATISTICS && Statistics.allowWorkerStatistics) {
            System.out.println("Federated Worker " + Statistics.display());
            Statistics.reset();
        }
    }

    private static void logRequests(FederatedRequest request, int nrRequest, int totalRequests) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing command " + (nrRequest + 1) + "/" + totalRequests + ": " + request.getType().name()));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("full command: " + request.toString()));
            }
        }
    }

    private static void conditionalAddCheckedConstraints(FederatedRequest request, FederatedResponse response) {
        if (request.checkPrivacy()) {
            response.setCheckedConstraints(PrivacyMonitor.getCheckedConstraints());
        }
    }

    private FederatedResponse executeCommand(FederatedRequest request) throws DMLPrivacyException, FederatedWorkerHandlerException, Exception {
        FederatedRequest.RequestType method = request.getType();
        switch (method) {
            case READ_VAR: {
                return this.readData(request);
            }
            case PUT_VAR: {
                return this.putVariable(request);
            }
            case GET_VAR: {
                return this.getVariable(request);
            }
            case EXEC_INST: {
                return this.execInstruction(request);
            }
            case EXEC_UDF: {
                return this.execUDF(request);
            }
            case CLEAR: {
                return this.execClear();
            }
            case NOOP: {
                return FederatedWorkerHandler.execNoop();
            }
        }
        String message = String.format("Method %s is not supported.", new Object[]{method});
        throw new FederatedWorkerHandlerException(message);
    }

    private FederatedResponse readData(FederatedRequest request) {
        FederatedWorkerHandler.checkNumParams(request.getNumParams(), 2);
        String filename = (String)request.getParam(0);
        Types.DataType dt = Types.DataType.valueOf((String)request.getParam(1));
        return this.readData(filename, dt, request.getID(), request.getTID());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FederatedResponse readData(String filename, Types.DataType dataType, long id, long tid) {
        CacheableData cd;
        MatrixCharacteristics mc = new MatrixCharacteristics();
        mc.setBlocksize(ConfigurationManager.getBlocksize());
        switch (dataType) {
            case MATRIX: {
                cd = new MatrixObject(Types.ValueType.FP64, filename);
                break;
            }
            case FRAME: {
                cd = new FrameObject(filename);
                break;
            }
            default: {
                throw new FederatedWorkerHandlerException("Could not recognize datatype");
            }
        }
        Types.FileFormat fmt = null;
        boolean header = false;
        String delim = null;
        FileSystem fs = null;
        try {
            String mtdName = DataExpression.getMTDFileName(filename);
            Path path = new Path(mtdName);
            fs = IOUtilFunctions.getFileSystem(mtdName);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));){
                MetaDataAll mtd = new MetaDataAll(br);
                if (!mtd.mtdExists()) {
                    throw new FederatedWorkerHandlerException("Could not parse metadata file");
                }
                mc.setRows(mtd.getDim1());
                mc.setCols(mtd.getDim2());
                mc.setNonZeros(mtd.getNnz());
                header = mtd.getHasHeader();
                cd = mtd.parseAndSetPrivacyConstraint(cd);
                fmt = mtd.getFileFormat();
                delim = mtd.getDelim();
            }
        }
        catch (FederatedWorkerHandlerException | DMLPrivacyException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new DMLRuntimeException(ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtilFunctions.closeSilently(fs);
                throw throwable;
            }
        }
        IOUtilFunctions.closeSilently((Closeable)fs);
        cd.setMetaData(new MetaDataFormat(mc, fmt));
        if (fmt == Types.FileFormat.CSV) {
            cd.setFileFormatProperties(new FileFormatPropertiesCSV(header, delim, false));
        }
        cd.enableCleanup(false);
        this._ecm.get(tid).setVariable(String.valueOf(id), cd);
        if (DMLScript.LINEAGE) {
            this._ecm.get(tid).getLineage().set(String.valueOf(id), new LineageItem(filename));
        }
        if (dataType == Types.DataType.FRAME) {
            FrameObject frameObject = (FrameObject)cd;
            frameObject.acquireRead();
            frameObject.refreshMetaData();
            frameObject.release();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{id, frameObject.getSchema(), mc});
        }
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{id, mc});
    }

    private FederatedResponse putVariable(FederatedRequest request) {
        CacheableData data;
        FederatedWorkerHandler.checkNumParams(request.getNumParams(), 1, 2);
        String varName = String.valueOf(request.getID());
        ExecutionContext ec = this._ecm.get(request.getTID());
        if (ec.containsVariable(varName)) {
            Data tgtData = ec.removeVariable(varName);
            if (tgtData != null) {
                ec.cleanupDataObject(tgtData);
            }
            LOG.warn((Object)("Variable" + request.getID() + " already existing, fallback to overwritten."));
        }
        if (request.getParam(0) instanceof CacheBlock) {
            data = ExecutionContext.createCacheableData((CacheBlock)request.getParam(0));
        } else if (request.getParam(0) instanceof ScalarObject) {
            data = (ScalarObject)request.getParam(0);
        } else if (request.getParam(0) instanceof ListObject) {
            data = (ListObject)request.getParam(0);
        } else if (request.getNumParams() == 2) {
            data = request.getParam(1) == Types.DataType.MATRIX ? ExecutionContext.createMatrixObject((MatrixCharacteristics)request.getParam(0)) : ExecutionContext.createFrameObject((MatrixCharacteristics)request.getParam(0));
        } else {
            throw new FederatedWorkerHandlerException("Unsupported object type, has to be of type CacheBlock or ScalarObject");
        }
        ec.setVariable(varName, data);
        if (DMLScript.LINEAGE) {
            ec.getLineage().set(varName, new LineageItem(String.valueOf(request.getChecksum(0))));
        }
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
    }

    private FederatedResponse getVariable(FederatedRequest request) {
        FederatedWorkerHandler.checkNumParams(request.getNumParams(), 0);
        ExecutionContext ec = this._ecm.get(request.getTID());
        if (!ec.containsVariable(String.valueOf(request.getID()))) {
            throw new FederatedWorkerHandlerException("Variable " + request.getID() + " does not exist at federated worker.");
        }
        Data dataObject = ec.getVariable(String.valueOf(request.getID()));
        dataObject = PrivacyMonitor.handlePrivacy(dataObject);
        switch (dataObject.getDataType()) {
            case MATRIX: 
            case FRAME: 
            case TENSOR: {
                return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, ((CacheableData)dataObject).acquireReadAndRelease());
            }
            case LIST: {
                return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, ((ListObject)dataObject).getData());
            }
            case SCALAR: {
                return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, dataObject);
            }
        }
        throw new FederatedWorkerHandlerException("Unsupported return datatype " + dataObject.getDataType().name());
    }

    private FederatedResponse execInstruction(FederatedRequest request) throws Exception {
        ExecutionContext ec = this._ecm.get(request.getTID());
        BasicProgramBlock pb = new BasicProgramBlock(null);
        pb.getInstructions().clear();
        Instruction receivedInstruction = InstructionParser.parseSingleInstruction((String)request.getParam(0));
        pb.getInstructions().add(receivedInstruction);
        if (DMLScript.LINEAGE) {
            LineageCacheConfig.setCompAssRW(false);
        }
        pb.execute(ec);
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
    }

    private FederatedResponse execUDF(FederatedRequest request) {
        FederatedWorkerHandler.checkNumParams(request.getNumParams(), 1);
        ExecutionContext ec = this._ecm.get(request.getTID());
        FederatedUDF udf = (FederatedUDF)request.getParam(0);
        Data[] inputs = (Data[])Arrays.stream(udf.getInputIDs()).mapToObj(id -> ec.getVariable(String.valueOf(id))).map(PrivacyMonitor::handlePrivacy).toArray(Data[]::new);
        if (DMLScript.LINEAGE) {
            LineageItemUtils.traceFedUDF(ec, udf);
        }
        try {
            FederatedResponse reuse = LineageCache.reuse(udf, ec);
            if (reuse.isSuccessful()) {
                return reuse;
            }
            long t0 = !LineageCacheConfig.ReuseCacheType.isNone() ? System.nanoTime() : 0L;
            FederatedResponse res = udf.execute(ec, inputs);
            long t1 = !LineageCacheConfig.ReuseCacheType.isNone() ? System.nanoTime() : 0L;
            LineageCache.putValue(udf, ec, t1 - t0);
            return res;
        }
        catch (FederatedWorkerHandlerException | DMLPrivacyException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = "Exception of type " + ex.getClass() + " thrown when processing EXEC_UDF request";
            throw new FederatedWorkerHandlerException(msg);
        }
    }

    private FederatedResponse execClear() {
        try {
            this._ecm.clear();
        }
        catch (FederatedWorkerHandlerException | DMLPrivacyException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = "Exception of type " + ex.getClass() + " thrown when processing CLEAR request";
            throw new FederatedWorkerHandlerException(msg);
        }
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
    }

    private static FederatedResponse execNoop() {
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
    }

    private static void checkNumParams(int actual, int ... expected) {
        if (Arrays.stream(expected).anyMatch(x -> x == actual)) {
            return;
        }
        throw new DMLRuntimeException("FederatedWorkerHandler: Received wrong amount of params: expected=" + Arrays.toString(expected) + ", actual=" + actual);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    private static class CloseListener
    implements ChannelFutureListener {
        private CloseListener() {
        }

        public void operationComplete(ChannelFuture channelFuture) throws InterruptedException {
            if (!channelFuture.isSuccess()) {
                LOG.error((Object)"Federated Worker Write failed");
                channelFuture.channel().writeAndFlush((Object)new FederatedResponse(FederatedResponse.ResponseType.ERROR, new FederatedWorkerHandlerException("Error while sending response."))).channel().close().sync();
            } else {
                PrivacyMonitor.clearCheckedConstraints();
                channelFuture.channel().close().sync();
            }
        }
    }
}

