/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlockDataInput;

public class FastBufferedDataInputStream
extends FilterInputStream
implements DataInput,
MatrixBlockDataInput {
    protected byte[] _buff;
    protected int _bufflen;

    public FastBufferedDataInputStream(InputStream in) {
        this(in, 8192);
    }

    public FastBufferedDataInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this._buff = new byte[size];
        this._bufflen = size;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.read() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.in.read();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public short readShort() throws IOException {
        this.readFully(this._buff, 0, 2);
        return (short)FastBufferedDataInputStream.baToShort(this._buff, 0);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.readFully(this._buff, 0, 2);
        return FastBufferedDataInputStream.baToShort(this._buff, 0);
    }

    @Override
    public char readChar() throws IOException {
        this.readFully(this._buff, 0, 2);
        return (char)FastBufferedDataInputStream.baToShort(this._buff, 0);
    }

    @Override
    public int readInt() throws IOException {
        this.readFully(this._buff, 0, 4);
        return FastBufferedDataInputStream.baToInt(this._buff, 0);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this._buff, 0, 8);
        return FastBufferedDataInputStream.baToLong(this._buff, 0);
    }

    @Override
    public float readFloat() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public double readDouble() throws IOException {
        this.readFully(this._buff, 0, 8);
        long tmp = FastBufferedDataInputStream.baToLong(this._buff, 0);
        return Double.longBitsToDouble(tmp);
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public long readDoubleArray(int len, double[] varr) throws IOException {
        if (len <= 0 || len > varr.length) {
            throw new IndexOutOfBoundsException("len=" + len + ", varr.length=" + varr.length);
        }
        long nnz = 0L;
        for (int i = 0; i < len; i += this._bufflen / 8) {
            int maxNB = (int)Math.min((long)this._bufflen, ((long)len - (long)i) * 8L);
            this.readFully(this._buff, 0, maxNB);
            int j = 0;
            int ix = i;
            while (j < maxNB) {
                long tmp = FastBufferedDataInputStream.baToLong(this._buff, j);
                varr[ix] = Double.longBitsToDouble(tmp);
                nnz += varr[ix] != 0.0 ? 1L : 0L;
                j += 8;
                ++ix;
            }
        }
        return nnz;
    }

    @Override
    public long readSparseRows(int rlen, long nnz, SparseBlock rows) throws IOException {
        if (rows instanceof SparseBlockCSR) {
            ((SparseBlockCSR)rows).initSparse(rlen, (int)nnz, this);
            return nnz;
        }
        long gnnz = 0L;
        for (int i = 0; i < rlen; ++i) {
            double aval;
            long tmp;
            int aix;
            int j;
            int lnnz = this.readInt();
            if (lnnz <= 0) continue;
            rows.allocate(i, lnnz);
            if ((long)lnnz * 12L < (long)this._bufflen) {
                this.readFully(this._buff, 0, lnnz * 12);
                for (j = 0; j < lnnz * 12; j += 12) {
                    aix = FastBufferedDataInputStream.baToInt(this._buff, j);
                    tmp = FastBufferedDataInputStream.baToLong(this._buff, j + 4);
                    aval = Double.longBitsToDouble(tmp);
                    rows.append(i, aix, aval);
                }
            } else {
                for (j = 0; j < lnnz; ++j) {
                    this.readFully(this._buff, 0, 12);
                    aix = FastBufferedDataInputStream.baToInt(this._buff, 0);
                    tmp = FastBufferedDataInputStream.baToLong(this._buff, 4);
                    aval = Double.longBitsToDouble(tmp);
                    rows.append(i, aix, aval);
                }
            }
            gnnz += (long)lnnz;
        }
        if (gnnz != nnz) {
            throw new IOException("Invalid number of read nnz: " + gnnz + " vs " + nnz);
        }
        return nnz;
    }

    private static int baToShort(byte[] ba, int off) {
        return IOUtilFunctions.baToShort(ba, off);
    }

    private static int baToInt(byte[] ba, int off) {
        return IOUtilFunctions.baToInt(ba, off);
    }

    private static long baToLong(byte[] ba, int off) {
        return IOUtilFunctions.baToLong(ba, off);
    }
}

