# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/outlierByIQRApply.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def outlierByIQRApply(X: Matrix,
                      Q1: Matrix,
                      Q3: Matrix,
                      IQR: Matrix,
                      k: float,
                      repairMethod: int):
    """
     Builtin function for repairing outliers by IQR 
    
    
    
    :param X: Matrix X
    :param Q1: first quartile
    :param Q3: third quartile
    :param IQR: Inter-quartile range
    :param k: a constant used to discern outliers k*IQR
    :param repairMethod: values: 0 = delete rows having outliers,
        1 = replace outliers with zeros
        2 = replace outliers as missing values
    :return: Matrix X with no outliers
    """

    params_dict = {'X': X, 'Q1': Q1, 'Q3': Q3, 'IQR': IQR, 'k': k, 'repairMethod': repairMethod}
    return Matrix(X.sds_context,
        'outlierByIQRApply',
        named_input_nodes=params_dict)
