# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/statsNA.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def statsNA(X: Matrix,
            **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     The statsNA-function Print summary stats about the distribution of missing values in a univariate time series.
    
     result matrix contains the following:
      1. Length of time series (including NAs)
      2. Number of Missing Values (NAs)
      3. Percentage of Missing Values (#2/#1)
      4. Number of Gaps (consisting of one or more consecutive NAs)
      5. Average Gap Size - Average size of consecutive NAs for the NA gaps
      6. Longest NA gap - Longest series of consecutive missing values
      7. Most frequent gap size - Most frequently occurring gap size
      8. Gap size accounting for most NAs
    
    
    
    
    :param X: Numeric Vector ('vector') object containing NAs
    :param bins: Split number for bin stats. Number of bins the time series gets
        divided into. For each bin information about amount/percentage of
        missing values is printed.
    :param verbose: Print detailed information.
        For print_only = TRUE, the missing value stats are printed with
        more information ("Stats for Bins" and "overview NA series").
    :return: Column vector where each row correspond to described values
    """

    params_dict = {'X': X}
    params_dict.update(kwargs)
    return Matrix(X.sds_context,
        'statsNA',
        named_input_nodes=params_dict)
