/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.plan.IPlanEncode;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class NaivePlanEncode
implements IPlanEncode {
    private final ICLAScheme[] schemes;
    private final int k;
    private final boolean overlapping;

    public NaivePlanEncode(ICLAScheme[] schemes, int k, boolean overlapping) {
        this.schemes = schemes;
        this.k = k;
        this.overlapping = overlapping;
    }

    @Override
    public CompressedMatrixBlock encode(MatrixBlock in) {
        try {
            List<AColGroup> groups = this.k <= 1 ? this.encodeSingleThread(in) : this.encodeMultiThread(in);
            return new CompressedMatrixBlock(in.getNumRows(), in.getNumColumns(), in.getNonZeros(), this.overlapping, groups);
        }
        catch (Exception e) {
            throw new DMLCompressionException("Failed encoding matrix", e);
        }
    }

    private List<AColGroup> encodeSingleThread(MatrixBlock in) {
        ArrayList<AColGroup> groups = new ArrayList<AColGroup>(this.schemes.length);
        for (int i = 0; i < this.schemes.length; ++i) {
            groups.add(this.schemes[i].encode(in));
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AColGroup> encodeMultiThread(MatrixBlock in) throws Exception {
        ExecutorService pool = CommonThreadPool.get(this.k);
        try {
            ArrayList<EncodeTask> t = new ArrayList<EncodeTask>(this.schemes.length);
            for (int i = 0; i < this.schemes.length; ++i) {
                t.add(new EncodeTask(in, this.schemes[i]));
            }
            ArrayList<AColGroup> groups = new ArrayList<AColGroup>(this.schemes.length);
            for (Future f : pool.invokeAll(t)) {
                groups.add((AColGroup)f.get());
            }
            ArrayList<AColGroup> arrayList = groups;
            return arrayList;
        }
        finally {
            pool.shutdown();
        }
    }

    @Override
    public void expandPlan(MatrixBlock in) {
        try {
            if (this.k <= 1) {
                this.expandPlanSingleThread(in);
            } else {
                this.expandPlanMultiThread(in);
            }
        }
        catch (Exception e) {
            throw new DMLCompressionException("Failed expanding plan", e);
        }
    }

    public void expandPlanSingleThread(MatrixBlock in) {
        for (int i = 0; i < this.schemes.length; ++i) {
            this.schemes[i] = this.schemes[i].update(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandPlanMultiThread(MatrixBlock in) throws Exception {
        ExecutorService pool = CommonThreadPool.get(this.k);
        try {
            int i;
            ArrayList<ExpandTask> t = new ArrayList<ExpandTask>(this.schemes.length);
            for (i = 0; i < this.schemes.length; ++i) {
                t.add(new ExpandTask(in, this.schemes[i]));
            }
            i = 0;
            for (Future f : pool.invokeAll(t)) {
                this.schemes[i++] = (ICLAScheme)f.get();
            }
        }
        finally {
            pool.shutdown();
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" Parallelization: " + this.k);
        sb.append(" Overlapping: " + this.overlapping);
        sb.append("\n");
        for (int i = 0; i < this.schemes.length; ++i) {
            sb.append(this.schemes[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static class ExpandTask
    implements Callable<ICLAScheme> {
        private final MatrixBlock in;
        private final ICLAScheme sc;

        protected ExpandTask(MatrixBlock in, ICLAScheme sc) {
            this.in = in;
            this.sc = sc;
        }

        @Override
        public ICLAScheme call() throws Exception {
            try {
                return this.sc.update(this.in);
            }
            catch (Exception e) {
                throw new DMLCompressionException("Failed Expanding schema");
            }
        }
    }

    private static class EncodeTask
    implements Callable<AColGroup> {
        private final MatrixBlock in;
        private final ICLAScheme sc;

        protected EncodeTask(MatrixBlock in, ICLAScheme sc) {
            this.in = in;
            this.sc = sc;
        }

        @Override
        public AColGroup call() throws Exception {
            try {
                return this.sc.encode(this.in);
            }
            catch (Exception e) {
                throw new DMLCompressionException("Failed encoding schema");
            }
        }
    }
}

