/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.iterators;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.iterators.ObjectRowIterator;
import org.apache.sysds.runtime.frame.data.iterators.RowIterator;
import org.apache.sysds.runtime.frame.data.iterators.StringRowIterator;

public interface IteratorFactory {
    public static RowIterator<String> getStringRowIterator(FrameBlock fb) {
        return new StringRowIterator(fb, 0, fb.getNumRows());
    }

    public static RowIterator<String> getStringRowIterator(FrameBlock fb, int[] cols) {
        return new StringRowIterator(fb, 0, fb.getNumRows(), cols);
    }

    public static RowIterator<String> getStringRowIterator(FrameBlock fb, int colID) {
        return new StringRowIterator(fb, 0, fb.getNumRows(), new int[]{colID});
    }

    public static RowIterator<String> getStringRowIterator(FrameBlock fb, int rl, int ru) {
        return new StringRowIterator(fb, rl, ru);
    }

    public static RowIterator<String> getStringRowIterator(FrameBlock fb, int rl, int ru, int[] cols) {
        return new StringRowIterator(fb, rl, ru, cols);
    }

    public static RowIterator<String> getStringRowIterator(FrameBlock fb, int rl, int ru, int colID) {
        return new StringRowIterator(fb, rl, ru, new int[]{colID});
    }

    public static RowIterator<Object> getObjectRowIterator(FrameBlock fb) {
        return new ObjectRowIterator(fb, 0, fb.getNumRows());
    }

    public static RowIterator<Object> getObjectRowIterator(FrameBlock fb, Types.ValueType[] schema) {
        return new ObjectRowIterator(fb, 0, fb.getNumRows(), schema);
    }

    public static RowIterator<Object> getObjectRowIterator(FrameBlock fb, int[] cols) {
        return new ObjectRowIterator(fb, 0, fb.getNumRows(), cols);
    }

    public static RowIterator<Object> getObjectRowIterator(FrameBlock fb, int colID) {
        return new ObjectRowIterator(fb, 0, fb.getNumRows(), new int[]{colID});
    }

    public static RowIterator<Object> getObjectRowIterator(FrameBlock fb, int rl, int ru) {
        return new ObjectRowIterator(fb, rl, ru);
    }

    public static RowIterator<Object> getObjectRowIterator(FrameBlock fb, int rl, int ru, int[] cols) {
        return new ObjectRowIterator(fb, rl, ru, cols);
    }

    public static RowIterator<Object> getObjectRowIterator(FrameBlock fb, int rl, int ru, int colID) {
        return new ObjectRowIterator(fb, rl, ru, new int[]{colID});
    }
}

