/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LocalCPInstruction
extends ComputationCPInstruction {
    private LocalCPInstruction(CPOperand in, CPOperand out, String instruction) {
        super(CPInstruction.CPType.Local, null, in, null, null, out, "LOCAL", instruction);
    }

    public static LocalCPInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 2);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new LocalCPInstruction(in, out, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock in = ec.getMatrixInput(this.input1.getName());
        ec.releaseMatrixInput(this.input1.getName());
        ec.setMatrixOutput(this.output.getName(), in);
    }
}

