/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetSocketAddress;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.DataObjectModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.RequestModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.TrafficModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.UtilizationModel;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.utils.Statistics;

public class FederatedStatistics {
    protected static Logger LOG = Logger.getLogger(FederatedStatistics.class);
    private static Set<Pair<String, Integer>> _fedWorkerAddresses = new HashSet<Pair<String, Integer>>();
    private static final LongAdder readCount = new LongAdder();
    private static final LongAdder putCount = new LongAdder();
    private static final LongAdder getCount = new LongAdder();
    private static final LongAdder executeInstructionCount = new LongAdder();
    private static final LongAdder executeUDFCount = new LongAdder();
    private static final LongAdder transferredScalarCount = new LongAdder();
    private static final LongAdder transferredListCount = new LongAdder();
    private static final LongAdder transferredMatrixCount = new LongAdder();
    private static final LongAdder transferredFrameCount = new LongAdder();
    private static final LongAdder transferredMatCharCount = new LongAdder();
    private static final LongAdder transferredMatrixBytes = new LongAdder();
    private static final LongAdder transferredFrameBytes = new LongAdder();
    private static final LongAdder asyncPrefetchCount = new LongAdder();
    private static final LongAdder bytesSent = new LongAdder();
    private static final LongAdder bytesReceived = new LongAdder();
    private static final LongAdder fedLookupTableGetCount = new LongAdder();
    private static final LongAdder fedLookupTableGetTime = new LongAdder();
    private static final LongAdder fedLookupTableEntryCount = new LongAdder();
    private static final LongAdder fedReuseReadHitCount = new LongAdder();
    private static final LongAdder fedReuseReadBytesCount = new LongAdder();
    private static final LongAdder fedBytesSent = new LongAdder();
    private static final LongAdder fedBytesReceived = new LongAdder();
    private static final LongAdder fedPutLineageCount = new LongAdder();
    private static final LongAdder fedPutLineageItems = new LongAdder();
    private static final LongAdder fedSerializationReuseCount = new LongAdder();
    private static final LongAdder fedSerializationReuseBytes = new LongAdder();
    private static final List<TrafficModel> coordinatorsTrafficBytes = new ArrayList<TrafficModel>();
    private static final List<EventModel> workerEvents = new ArrayList<EventModel>();
    private static final Map<String, DataObjectModel> workerDataObjects = new HashMap<String, DataObjectModel>();
    private static final Map<String, RequestModel> workerFederatedRequests = new HashMap<String, RequestModel>();

    public static void logServerTraffic(long read, long written) {
        bytesReceived.add(read);
        bytesSent.add(written);
    }

    public static void logWorkerTraffic(long read, long written) {
        fedBytesReceived.add(read);
        fedBytesSent.add(written);
    }

    public static synchronized void incFederated(FederatedRequest.RequestType rqt, List<Object> data) {
        switch (rqt) {
            case READ_VAR: {
                readCount.increment();
                break;
            }
            case PUT_VAR: {
                putCount.increment();
                FederatedStatistics.incFedTransfer(data.get(0));
                break;
            }
            case GET_VAR: {
                getCount.increment();
                break;
            }
            case EXEC_INST: {
                executeInstructionCount.increment();
                break;
            }
            case EXEC_UDF: {
                executeUDFCount.increment();
                FederatedStatistics.incFedTransfer(data);
                break;
            }
        }
    }

    private static void incFedTransfer(List<Object> data) {
        for (Object dataObj : data) {
            FederatedStatistics.incFedTransfer(dataObj);
        }
    }

    private static void incFedTransfer(Object dataObj) {
        FederatedStatistics.incFedTransfer(dataObj, null, null);
    }

    public static void incFedTransfer(Object dataObj, String host, Long pid) {
        long byteAmount = 0L;
        if (dataObj instanceof MatrixBlock) {
            transferredMatrixCount.increment();
            byteAmount = ((MatrixBlock)dataObj).getInMemorySize();
            transferredMatrixBytes.add(byteAmount);
        } else if (dataObj instanceof FrameBlock) {
            transferredFrameCount.increment();
            byteAmount = ((FrameBlock)dataObj).getInMemorySize();
            transferredFrameBytes.add(byteAmount);
        } else if (dataObj instanceof ScalarObject) {
            transferredScalarCount.increment();
        } else if (dataObj instanceof ListObject) {
            transferredListCount.increment();
            List<Data> listData = ((ListObject)dataObj).getData();
            for (Data entry : listData) {
                if (entry.getDataType().isMatrix()) {
                    byteAmount += ((MatrixObject)entry).getDataSize();
                    continue;
                }
                if (!entry.getDataType().isFrame()) continue;
                byteAmount += ((FrameObject)entry).getDataSize();
            }
        } else if (dataObj instanceof MatrixCharacteristics) {
            transferredMatCharCount.increment();
        }
        if (host != null && pid != null) {
            String coordinatorHostId = String.format("%s-%d", host, pid);
            coordinatorsTrafficBytes.add(new TrafficModel(LocalDateTime.now(), coordinatorHostId, (Long)byteAmount));
        }
    }

    public static void incAsyncPrefetchCount(long c) {
        asyncPrefetchCount.add(c);
    }

    public static long getTotalFedTransferCount() {
        return transferredScalarCount.longValue() + transferredListCount.longValue() + transferredMatrixCount.longValue() + transferredFrameCount.longValue() + transferredMatCharCount.longValue();
    }

    public static void reset() {
        readCount.reset();
        putCount.reset();
        getCount.reset();
        executeInstructionCount.reset();
        executeUDFCount.reset();
        transferredScalarCount.reset();
        transferredListCount.reset();
        transferredMatrixCount.reset();
        transferredFrameCount.reset();
        transferredMatCharCount.reset();
        transferredMatrixBytes.reset();
        transferredFrameBytes.reset();
        asyncPrefetchCount.reset();
        fedLookupTableGetCount.reset();
        fedLookupTableGetTime.reset();
        fedLookupTableEntryCount.reset();
        fedReuseReadHitCount.reset();
        fedReuseReadBytesCount.reset();
        fedPutLineageCount.reset();
        fedPutLineageItems.reset();
        fedSerializationReuseCount.reset();
        fedSerializationReuseBytes.reset();
        bytesSent.reset();
        bytesReceived.reset();
        fedBytesSent.reset();
        fedBytesReceived.reset();
        coordinatorsTrafficBytes.clear();
        workerEvents.clear();
        workerDataObjects.clear();
    }

    public static String displayFedIOExecStatistics() {
        if (readCount.longValue() > 0L) {
            StringBuilder sb = new StringBuilder();
            sb.append("Federated I/O (Read, Put, Get):\t" + readCount.longValue() + "/" + putCount.longValue() + "/" + getCount.longValue() + ".\n");
            sb.append("Federated Execute (Inst, UDF):\t" + executeInstructionCount.longValue() + "/" + executeUDFCount.longValue() + ".\n");
            if (FederatedStatistics.getTotalFedTransferCount() > 0L) {
                sb.append("Fed Put Count (Sc/Li/Ma/Fr/MC):\t" + transferredScalarCount.longValue() + "/" + transferredListCount.longValue() + "/" + transferredMatrixCount.longValue() + "/" + transferredFrameCount.longValue() + "/" + transferredMatCharCount.longValue() + ".\n");
            }
            if (transferredMatrixBytes.longValue() > 0L || transferredFrameBytes.longValue() > 0L) {
                sb.append("Fed Put Bytes (Mat/Frame):\t" + transferredMatrixBytes.longValue() + "/" + transferredFrameBytes.longValue() + " Bytes.\n");
            }
            sb.append("Federated prefetch count:\t" + asyncPrefetchCount.longValue() + ".\n");
            return sb.toString();
        }
        return "";
    }

    public static String displayNetworkTrafficStatistics() {
        return "Server I/O bytes (read/written):\t" + bytesReceived.longValue() + "/" + bytesSent.longValue() + "\nWorker I/O bytes (read/written):\t" + fedBytesReceived.longValue() + "/" + fedBytesSent.longValue() + "\n";
    }

    public static void registerFedWorker(String host, int port) {
        _fedWorkerAddresses.add((Pair<String, Integer>)new ImmutablePair((Object)host, (Object)port));
    }

    public static String displayFedWorkers() {
        StringBuilder sb = new StringBuilder();
        sb.append("Federated Worker Addresses:\n");
        for (Pair<String, Integer> fedAddr : _fedWorkerAddresses) {
            sb.append(String.format("  %s:%d", fedAddr.getLeft(), (int)((Integer)fedAddr.getRight())));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String displayFedWorkerStats() {
        if (readCount.longValue() > 0L) {
            StringBuilder sb = new StringBuilder();
            sb.append(FederatedStatistics.displayFedLookupTableStats());
            sb.append(FederatedStatistics.displayFedReuseReadStats());
            sb.append(FederatedStatistics.displayFedPutLineageStats());
            sb.append(FederatedStatistics.displayFedSerializationReuseStats());
            return sb.toString();
        }
        return "";
    }

    public static String displayStatistics(int numHeavyHitters) {
        FedStatsCollection fedStats = FederatedStatistics.collectFedStats();
        return FederatedStatistics.displayStatistics(fedStats, numHeavyHitters);
    }

    public static String displayStatistics(FedStatsCollection fedStats, int numHeavyHitters) {
        StringBuilder sb = new StringBuilder();
        sb.append("SystemDS Federated Statistics:\n");
        sb.append(FederatedStatistics.displayCacheStats(fedStats.cacheStats));
        sb.append(String.format("Total JIT compile time:\t\t%.3f sec.\n", fedStats.jitCompileTime));
        sb.append(FederatedStatistics.displayGCStats(fedStats.gcStats));
        sb.append(FederatedStatistics.displayLinCacheStats(fedStats.linCacheStats));
        sb.append(FederatedStatistics.displayMultiTenantStats(fedStats.mtStats));
        sb.append(FederatedStatistics.displayFedTransfer());
        sb.append(FederatedStatistics.displayHeavyHitters(fedStats.heavyHitters, numHeavyHitters));
        sb.append(FederatedStatistics.displayNetworkTrafficStatistics());
        return sb.toString();
    }

    private static String displayCacheStats(FedStatsCollection.CacheStatsCollection csc) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Cache hits (Mem/Li/WB/FS/HDFS):\t%d/%d/%d/%d/%d.\n", csc.memHits, csc.linHits, csc.fsBuffHits, csc.fsHits, csc.hdfsHits));
        sb.append(String.format("Cache writes (Li/WB/FS/HDFS):\t%d/%d/%d/%d.\n", csc.linWrites, csc.fsBuffWrites, csc.fsWrites, csc.hdfsWrites));
        sb.append(String.format("Cache times (ACQr/m, RLS, EXP):\t%.3f/%.3f/%.3f/%.3f sec.\n", csc.acqRTime, csc.acqMTime, csc.rlsTime, csc.expTime));
        return sb.toString();
    }

    private static String displayGCStats(FedStatsCollection.GCStatsCollection gcsc) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Total JVM GC count:\t\t%d.\n", gcsc.gcCount));
        sb.append(String.format("Total JVM GC time:\t\t%.3f sec.\n", gcsc.gcTime));
        return sb.toString();
    }

    private static String displayLinCacheStats(FedStatsCollection.LineageCacheStatsCollection lcsc) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("LinCache hits (Mem/FS/Del):\t%d/%d/%d.\n", lcsc.numHitsMem, lcsc.numHitsFS, lcsc.numHitsDel));
        sb.append(String.format("LinCache MultiLvl (Ins/SB/Fn):\t%d/%d/%d.\n", lcsc.numHitsInst, lcsc.numHitsSB, lcsc.numHitsFunc));
        sb.append(String.format("LinCache writes (Mem/FS/Del):\t%d/%d/%d.\n", lcsc.numWritesMem, lcsc.numWritesFS, lcsc.numMemDel));
        return sb.toString();
    }

    private static String displayMultiTenantStats(FedStatsCollection.MultiTenantStatsCollection mtsc) {
        StringBuilder sb = new StringBuilder();
        sb.append(FederatedStatistics.displayFedLookupTableStats(mtsc.fLTGetCount, mtsc.fLTEntryCount, mtsc.fLTGetTime));
        sb.append(FederatedStatistics.displayFedReuseReadStats(mtsc.reuseReadHits, mtsc.reuseReadBytes));
        sb.append(FederatedStatistics.displayFedPutLineageStats(mtsc.putLineageCount, mtsc.putLineageItems));
        sb.append(FederatedStatistics.displayFedSerializationReuseStats(mtsc.serializationReuseCount, mtsc.serializationReuseBytes));
        return sb.toString();
    }

    private static String displayHeavyHitters(HashMap<String, Pair<Long, Double>> heavyHitters) {
        return FederatedStatistics.displayHeavyHitters(heavyHitters, 10);
    }

    private static String displayFedTransfer() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transferred bytes (Host/Datetime/ByteAmount):\n");
        for (TrafficModel entry : coordinatorsTrafficBytes) {
            sb.append(String.format("%s/%s/%d.\n", entry.getCoordinatorHostId(), entry.timestamp, entry.byteAmount));
        }
        return sb.toString();
    }

    private static String displayHeavyHitters(HashMap<String, Pair<Long, Double>> heavyHitters, int num) {
        int counter;
        StringBuilder sb = new StringBuilder();
        Map.Entry[] hhArr = heavyHitters.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(hhArr, new Comparator<Map.Entry<String, Pair<Long, Double>>>(){

            @Override
            public int compare(Map.Entry<String, Pair<Long, Double>> e1, Map.Entry<String, Pair<Long, Double>> e2) {
                return ((Double)e1.getValue().getRight()).compareTo((Double)e2.getValue().getRight());
            }
        });
        sb.append("Heavy hitter instructions:\n");
        String numCol = "#";
        String instCol = "Instruction";
        String timeSCol = "Time(s)";
        String countCol = "Count";
        int numHittersToDisplay = Math.min(num, hhArr.length);
        int maxNumLen = String.valueOf(numHittersToDisplay).length();
        int maxInstLen = "Instruction".length();
        int maxTimeSLen = "Time(s)".length();
        int maxCountLen = "Count".length();
        DecimalFormat sFormat = new DecimalFormat("#,##0.000");
        for (counter = 0; counter < numHittersToDisplay; ++counter) {
            Map.Entry hh = hhArr[hhArr.length - 1 - counter];
            String instruction = (String)hh.getKey();
            maxInstLen = Math.max(maxInstLen, instruction.length());
            String timeString = sFormat.format(((Pair)hh.getValue()).getRight());
            maxTimeSLen = Math.max(maxTimeSLen, timeString.length());
            maxCountLen = Math.max(maxCountLen, String.valueOf(((Pair)hh.getValue()).getLeft()).length());
        }
        maxInstLen = Math.min(maxInstLen, DMLScript.STATISTICS_MAX_WRAP_LEN);
        sb.append(String.format(" %" + maxNumLen + "s  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "s", "#", "Instruction", "Time(s)", "Count"));
        sb.append("\n");
        for (counter = 0; counter < numHittersToDisplay; ++counter) {
            String instruction = (String)hhArr[hhArr.length - 1 - counter].getKey();
            String[] wrappedInstruction = Statistics.wrap(instruction, maxInstLen);
            String timeSString = sFormat.format(((Pair)hhArr[hhArr.length - 1 - counter].getValue()).getRight());
            long count = (Long)((Pair)hhArr[hhArr.length - 1 - counter].getValue()).getLeft();
            int numLines = wrappedInstruction.length;
            for (int wrapIter = 0; wrapIter < numLines; ++wrapIter) {
                String instStr;
                String string = instStr = wrapIter < wrappedInstruction.length ? wrappedInstruction[wrapIter] : "";
                if (wrapIter == 0) {
                    sb.append(String.format(" %" + maxNumLen + "d  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "d", counter + 1, instStr, timeSString, count));
                } else {
                    sb.append(String.format(" %" + maxNumLen + "s  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "s", "", instStr, "", ""));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private static FedStatsCollection collectFedStats() {
        Future<FederatedResponse>[] responses = FederatedStatistics.getFederatedResponses();
        FedStatsCollection aggFedStats = new FedStatsCollection();
        int timeout = ConfigurationManager.getFederatedTimeout();
        for (Future<FederatedResponse> res : responses) {
            try {
                Object[] tmp;
                Object[] objectArray = tmp = timeout > 0 ? res.get(timeout, TimeUnit.SECONDS).getData() : res.get().getData();
                if (!(tmp[0] instanceof FedStatsCollection)) continue;
                aggFedStats.aggregate((FedStatsCollection)tmp[0]);
            }
            catch (Exception e) {
                throw new DMLRuntimeException("Exception of type " + e.getClass().toString() + " thrown while getting the federated stats of the federated response: ", e);
            }
        }
        return aggFedStats;
    }

    private static Future<FederatedResponse>[] getFederatedResponses() {
        ArrayList<Future<FederatedResponse>> ret = new ArrayList<Future<FederatedResponse>>();
        for (Pair<String, Integer> fedAddr : _fedWorkerAddresses) {
            InetSocketAddress isa = new InetSocketAddress((String)fedAddr.getLeft(), (int)((Integer)fedAddr.getRight()));
            FederatedRequest frUDF = new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new FedStatsCollectFunction());
            try {
                ret.add(FederatedData.executeFederatedOperation(isa, frUDF));
            }
            catch (DMLRuntimeException dMLRuntimeException) {
            }
            catch (Exception e) {
                System.out.println("Exeption of type " + e.getClass().getName() + " thrown while getting stats from federated worker: " + e.getMessage());
            }
        }
        Future[] retArr = ret.toArray(new Future[0]);
        return retArr;
    }

    public static long getFedLookupTableGetCount() {
        return fedLookupTableGetCount.longValue();
    }

    public static List<TrafficModel> getCoordinatorsTrafficBytes() {
        ArrayList<TrafficModel> result = new ArrayList<TrafficModel>(coordinatorsTrafficBytes);
        coordinatorsTrafficBytes.clear();
        return result;
    }

    public static List<EventModel> getWorkerEvents() {
        ArrayList<EventModel> result = new ArrayList<EventModel>(workerEvents);
        workerEvents.clear();
        return result;
    }

    public static List<RequestModel> getWorkerRequests() {
        return new ArrayList<RequestModel>(workerFederatedRequests.values());
    }

    public static List<DataObjectModel> getWorkerDataObjects() {
        return new ArrayList<DataObjectModel>(workerDataObjects.values());
    }

    public static synchronized void addEvent(EventModel event) {
        workerEvents.add(event);
    }

    public static void addWorkerRequest(RequestModel request) {
        if (!workerFederatedRequests.containsKey(request.type)) {
            workerFederatedRequests.put(request.type, request);
        }
        RequestModel requestModel = workerFederatedRequests.get(request.type);
        Long l = requestModel.count;
        Long l2 = requestModel.count = Long.valueOf(requestModel.count + 1L);
    }

    public static void addDataObject(DataObjectModel dataObject) {
        workerDataObjects.put(dataObject.varName, dataObject);
    }

    public static void removeDataObjects() {
        workerDataObjects.clear();
    }

    public static UtilizationModel getUtilization() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        double cpuUsage = osMXBean.getSystemLoadAverage();
        double memoryUsage = 0.0;
        double maxMemory = (double)memoryMXBean.getHeapMemoryUsage().getMax() / 1.073741824E9;
        double usedMemory = (double)memoryMXBean.getHeapMemoryUsage().getUsed() / 1.073741824E9;
        memoryUsage = usedMemory / maxMemory * 100.0;
        return new UtilizationModel(cpuUsage, memoryUsage);
    }

    public static long getFedLookupTableGetTime() {
        return fedLookupTableGetTime.longValue();
    }

    public static long getFedLookupTableEntryCount() {
        return fedLookupTableEntryCount.longValue();
    }

    public static long getFedReuseReadHitCount() {
        return fedReuseReadHitCount.longValue();
    }

    public static long getFedReuseReadBytesCount() {
        return fedReuseReadBytesCount.longValue();
    }

    public static long getFedPutLineageCount() {
        return fedPutLineageCount.longValue();
    }

    public static long getFedPutLineageItems() {
        return fedPutLineageItems.longValue();
    }

    public static long getFedSerializationReuseCount() {
        return fedSerializationReuseCount.longValue();
    }

    public static long getFedSerializationReuseBytes() {
        return fedSerializationReuseBytes.longValue();
    }

    public static void incFedLookupTableGetCount() {
        fedLookupTableGetCount.increment();
    }

    public static void incFedLookupTableGetTime(long time) {
        fedLookupTableGetTime.add(time);
    }

    public static void incFedLookupTableEntryCount() {
        fedLookupTableEntryCount.increment();
    }

    public static void incFedReuseReadHitCount() {
        fedReuseReadHitCount.increment();
    }

    public static void incFedReuseReadBytesCount(CacheableData<?> data) {
        fedReuseReadBytesCount.add(data.getDataSize());
    }

    public static void incFedReuseReadBytesCount(CacheBlock<?> cb) {
        fedReuseReadBytesCount.add(cb.getInMemorySize());
    }

    public static void aggFedPutLineage(String serializedLineage) {
        fedPutLineageCount.increment();
        fedPutLineageItems.add(serializedLineage.lines().count());
    }

    public static void aggFedSerializationReuse(long bytes) {
        fedSerializationReuseCount.increment();
        fedSerializationReuseBytes.add(bytes);
    }

    public static String displayFedLookupTableStats() {
        return FederatedStatistics.displayFedLookupTableStats(fedLookupTableGetCount.longValue(), fedLookupTableEntryCount.longValue(), fedLookupTableGetTime.doubleValue() / 1.0E9);
    }

    public static String displayFedLookupTableStats(long fltGetCount, long fltEntryCount, double fltGetTime) {
        if (fltGetCount > 0L) {
            return InstructionUtils.concatStrings("Fed LookupTable (Get, Entries):\t", String.valueOf(fltGetCount), "/", String.valueOf(fltEntryCount), ".\n");
        }
        return "";
    }

    public static String displayFedReuseReadStats() {
        return FederatedStatistics.displayFedReuseReadStats(fedReuseReadHitCount.longValue(), fedReuseReadBytesCount.longValue());
    }

    public static String displayFedReuseReadStats(long rrHits, long rrBytes) {
        if (rrHits > 0L) {
            return InstructionUtils.concatStrings("Fed ReuseRead (Hits, Bytes):\t", String.valueOf(rrHits), "/", String.valueOf(rrBytes), ".\n");
        }
        return "";
    }

    public static String displayFedPutLineageStats() {
        return FederatedStatistics.displayFedPutLineageStats(fedPutLineageCount.longValue(), fedPutLineageItems.longValue());
    }

    public static String displayFedPutLineageStats(long plCount, long plItems) {
        if (plCount > 0L) {
            return InstructionUtils.concatStrings("Fed PutLineage (Count, Items):\t", String.valueOf(plCount), "/", String.valueOf(plItems), ".\n");
        }
        return "";
    }

    public static String displayFedSerializationReuseStats() {
        return FederatedStatistics.displayFedSerializationReuseStats(fedSerializationReuseCount.longValue(), fedSerializationReuseBytes.longValue());
    }

    public static String displayFedSerializationReuseStats(long srCount, long srBytes) {
        if (srCount > 0L) {
            return InstructionUtils.concatStrings("Fed SerialReuse (Count, Bytes):\t", String.valueOf(srCount), "/", String.valueOf(srBytes), ".\n");
        }
        return "";
    }

    public static class FedStatsCollection
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CacheStatsCollection cacheStats = new CacheStatsCollection();
        public double jitCompileTime = 0.0;
        public UtilizationModel utilization = new UtilizationModel(0.0, 0.0);
        private GCStatsCollection gcStats = new GCStatsCollection();
        private LineageCacheStatsCollection linCacheStats = new LineageCacheStatsCollection();
        private MultiTenantStatsCollection mtStats = new MultiTenantStatsCollection();
        public HashMap<String, Pair<Long, Double>> heavyHitters = new HashMap();
        public List<TrafficModel> coordinatorsTrafficBytes = new ArrayList<TrafficModel>();
        public List<EventModel> workerEvents = new ArrayList<EventModel>();
        public List<DataObjectModel> workerDataObjects = new ArrayList<DataObjectModel>();
        public List<RequestModel> workerRequests = new ArrayList<RequestModel>();

        private void collectStats() {
            this.cacheStats.collectStats();
            this.jitCompileTime = (double)Statistics.getJITCompileTime() / 1000.0;
            this.utilization = FederatedStatistics.getUtilization();
            this.gcStats.collectStats();
            this.linCacheStats.collectStats();
            this.mtStats.collectStats();
            this.heavyHitters = Statistics.getHeavyHittersHashMap();
            this.coordinatorsTrafficBytes = FederatedStatistics.getCoordinatorsTrafficBytes();
            this.workerEvents = FederatedStatistics.getWorkerEvents();
            this.workerDataObjects = FederatedStatistics.getWorkerDataObjects();
            this.workerRequests = FederatedStatistics.getWorkerRequests();
        }

        public void aggregate(FedStatsCollection that) {
            this.cacheStats.aggregate(that.cacheStats);
            this.jitCompileTime += that.jitCompileTime;
            this.utilization = that.utilization;
            this.gcStats.aggregate(that.gcStats);
            this.linCacheStats.aggregate(that.linCacheStats);
            this.mtStats.aggregate(that.mtStats);
            that.heavyHitters.forEach((key, value) -> this.heavyHitters.merge((String)key, (Pair<Long, Double>)value, (v1, v2) -> new ImmutablePair((Object)((Long)v1.getLeft() + (Long)v2.getLeft()), (Object)((Double)v1.getRight() + (Double)v2.getRight()))));
            this.coordinatorsTrafficBytes.addAll(that.coordinatorsTrafficBytes);
            this.workerEvents.addAll(that.workerEvents);
            this.workerDataObjects.addAll(that.workerDataObjects);
            this.workerRequests.addAll(that.workerRequests);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\nFedStatsCollection: ");
            sb.append("\ncacheStats " + this.cacheStats);
            sb.append("\njit " + this.jitCompileTime);
            sb.append("\nutilization " + this.utilization);
            sb.append("\ngcStats " + this.gcStats);
            sb.append("\nlinCacheStats " + this.linCacheStats);
            sb.append("\nmtStats " + this.mtStats);
            sb.append("\nheavyHitters " + this.heavyHitters);
            sb.append("\ncoordinatorsTrafficBytes " + this.coordinatorsTrafficBytes);
            sb.append("\nworkerEvents " + this.workerEvents);
            sb.append("\nworkerDataObjects " + this.workerDataObjects);
            sb.append("\nworkerRequests " + this.workerRequests);
            sb.append("\n\n");
            return sb.toString();
        }

        protected static class MultiTenantStatsCollection
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private long fLTGetCount = 0L;
            private double fLTGetTime = 0.0;
            private long fLTEntryCount = 0L;
            private long reuseReadHits = 0L;
            private long reuseReadBytes = 0L;
            private long putLineageCount = 0L;
            private long putLineageItems = 0L;
            private long serializationReuseCount = 0L;
            private long serializationReuseBytes = 0L;

            protected MultiTenantStatsCollection() {
            }

            private void collectStats() {
                this.fLTGetCount = FederatedStatistics.getFedLookupTableGetCount();
                this.fLTGetTime = (double)FederatedStatistics.getFedLookupTableGetTime() / 1.0E9;
                this.fLTEntryCount = FederatedStatistics.getFedLookupTableEntryCount();
                this.reuseReadHits = FederatedStatistics.getFedReuseReadHitCount();
                this.reuseReadBytes = FederatedStatistics.getFedReuseReadBytesCount();
                this.putLineageCount = FederatedStatistics.getFedPutLineageCount();
                this.putLineageItems = FederatedStatistics.getFedPutLineageItems();
                this.serializationReuseCount = FederatedStatistics.getFedSerializationReuseCount();
                this.serializationReuseBytes = FederatedStatistics.getFedSerializationReuseBytes();
            }

            private void aggregate(MultiTenantStatsCollection that) {
                this.fLTGetCount += that.fLTGetCount;
                this.fLTGetTime += that.fLTGetTime;
                this.fLTEntryCount += that.fLTEntryCount;
                this.reuseReadHits += that.reuseReadHits;
                this.reuseReadBytes += that.reuseReadBytes;
                this.putLineageCount += that.putLineageCount;
                this.putLineageItems += that.putLineageItems;
                this.serializationReuseCount += that.serializationReuseCount;
                this.serializationReuseBytes += that.serializationReuseBytes;
            }
        }

        protected static class LineageCacheStatsCollection
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private long numHitsMem = 0L;
            private long numHitsFS = 0L;
            private long numHitsDel = 0L;
            private long numHitsInst = 0L;
            private long numHitsSB = 0L;
            private long numHitsFunc = 0L;
            private long numWritesMem = 0L;
            private long numWritesFS = 0L;
            private long numMemDel = 0L;

            protected LineageCacheStatsCollection() {
            }

            private void collectStats() {
                this.numHitsMem = LineageCacheStatistics.getMemHits();
                this.numHitsFS = LineageCacheStatistics.getFSHits();
                this.numHitsDel = LineageCacheStatistics.getDelHits();
                this.numHitsInst = LineageCacheStatistics.getInstHits();
                this.numHitsSB = LineageCacheStatistics.getSBHits();
                this.numHitsFunc = LineageCacheStatistics.getFuncHits();
                this.numWritesMem = LineageCacheStatistics.getMemWrites();
                this.numWritesFS = LineageCacheStatistics.getFSWrites();
                this.numMemDel = LineageCacheStatistics.getMemDeletes();
            }

            private void aggregate(LineageCacheStatsCollection that) {
                this.numHitsMem += that.numHitsMem;
                this.numHitsFS += that.numHitsFS;
                this.numHitsDel += that.numHitsDel;
                this.numHitsInst += that.numHitsInst;
                this.numHitsSB += that.numHitsSB;
                this.numHitsFunc += that.numHitsFunc;
                this.numWritesMem += that.numWritesMem;
                this.numWritesFS += that.numWritesFS;
                this.numMemDel += that.numMemDel;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("numHitsMem: " + this.numHitsMem);
                sb.append("\tnumHitsFS: " + this.numHitsFS);
                sb.append("\tnumHitsDel: " + this.numHitsDel);
                sb.append("\tnumHitsInst: " + this.numHitsInst);
                sb.append("\tnumHitsSB: " + this.numHitsSB);
                sb.append("\tnumHitsFunc: " + this.numHitsFunc);
                sb.append("\tnumWritesMem: " + this.numWritesMem);
                sb.append("\tnumWritesFS: " + this.numWritesFS);
                sb.append("\tnumMemDel: " + this.numMemDel);
                return sb.toString();
            }
        }

        protected static class GCStatsCollection
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private long gcCount = 0L;
            private double gcTime = 0.0;

            protected GCStatsCollection() {
            }

            private void collectStats() {
                this.gcCount = Statistics.getJVMgcCount();
                this.gcTime = (double)Statistics.getJVMgcTime() / 1000.0;
            }

            private void aggregate(GCStatsCollection that) {
                this.gcCount += that.gcCount;
                this.gcTime += that.gcTime;
            }
        }

        protected static class CacheStatsCollection
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private long memHits = 0L;
            private long linHits = 0L;
            private long fsBuffHits = 0L;
            private long fsHits = 0L;
            private long hdfsHits = 0L;
            private long linWrites = 0L;
            private long fsBuffWrites = 0L;
            private long fsWrites = 0L;
            private long hdfsWrites = 0L;
            private double acqRTime = 0.0;
            private double acqMTime = 0.0;
            private double rlsTime = 0.0;
            private double expTime = 0.0;

            protected CacheStatsCollection() {
            }

            private void collectStats() {
                this.memHits = CacheStatistics.getMemHits();
                this.linHits = CacheStatistics.getLinHits();
                this.fsBuffHits = CacheStatistics.getFSBuffHits();
                this.fsHits = CacheStatistics.getFSHits();
                this.hdfsHits = CacheStatistics.getHDFSHits();
                this.linWrites = CacheStatistics.getLinWrites();
                this.fsBuffWrites = CacheStatistics.getFSBuffWrites();
                this.fsWrites = CacheStatistics.getFSWrites();
                this.hdfsWrites = CacheStatistics.getHDFSWrites();
                this.acqRTime = (double)CacheStatistics.getAcquireRTime() / 1.0E9;
                this.acqMTime = (double)CacheStatistics.getAcquireMTime() / 1.0E9;
                this.rlsTime = (double)CacheStatistics.getReleaseTime() / 1.0E9;
                this.expTime = (double)CacheStatistics.getExportTime() / 1.0E9;
            }

            private void aggregate(CacheStatsCollection that) {
                this.memHits += that.memHits;
                this.linHits += that.linHits;
                this.fsBuffHits += that.fsBuffHits;
                this.fsHits += that.fsHits;
                this.hdfsHits += that.hdfsHits;
                this.linWrites += that.linWrites;
                this.fsBuffWrites += that.fsBuffWrites;
                this.fsWrites += that.fsWrites;
                this.hdfsWrites += that.hdfsWrites;
                this.acqRTime += that.acqRTime;
                this.acqMTime += that.acqMTime;
                this.rlsTime += that.rlsTime;
                this.expTime += that.expTime;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("CacheStatsCollection:");
                sb.append("\tmemHits:" + this.memHits);
                sb.append("\tlinHits:" + this.linHits);
                sb.append("\tfsBuffHits:" + this.fsBuffHits);
                sb.append("\tfsHits:" + this.fsHits);
                sb.append("\thdfsHits:" + this.hdfsHits);
                sb.append("\tlinWrites:" + this.linWrites);
                sb.append("\tfsBuffWrites:" + this.fsBuffWrites);
                sb.append("\tfsWrites:" + this.fsWrites);
                sb.append("\thdfsWrites:" + this.hdfsWrites);
                sb.append("\tacqRTime:" + this.acqRTime);
                sb.append("\tacqMTime:" + this.acqMTime);
                sb.append("\trlsTime:" + this.rlsTime);
                sb.append("\texpTime:" + this.expTime);
                return sb.toString();
            }
        }
    }

    public static class FedStatsCollectFunction
    extends FederatedUDF {
        private static final long serialVersionUID = 1L;

        public FedStatsCollectFunction() {
            super(new long[0]);
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            FedStatsCollection fedStats = new FedStatsCollection();
            fedStats.collectStats();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, fedStats);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }
}

