/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.io.IOUtilFunctions;

public class PlaceHolderDict
extends ADictionary {
    private static final long serialVersionUID = 9176356558592L;
    private static final String errMessage = "PlaceHolderDict does not support Operations, and is purely intended for serialization";
    private final int nVal;

    public PlaceHolderDict(int nVal) {
        this.nVal = nVal;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 5L;
    }

    @Override
    public long getInMemorySize() {
        return 20L;
    }

    @Override
    public int getNumberOfValues(int nCol) {
        return this.nVal;
    }

    @Override
    public int getNumberOfColumns(int nrow) {
        throw new RuntimeException("invalid to get number of columns for PlaceHolderDict");
    }

    @Override
    public MatrixBlockDictionary getMBDict() {
        throw new RuntimeException(errMessage);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        byte[] o = new byte[5];
        o[0] = (byte)DictionaryFactory.Type.PLACE_HOLDER.ordinal();
        IOUtilFunctions.intToBa(this.nVal, o, 1);
        out.write(o);
    }

    public static PlaceHolderDict read(DataInput in) throws IOException {
        int nVals = in.readInt();
        return new PlaceHolderDict(nVals);
    }

    @Override
    public String getString(int colIndexes) {
        return "";
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        return -1L;
    }

    @Override
    public boolean equals(IDictionary o) {
        return o instanceof PlaceHolderDict;
    }

    @Override
    public IDictionary clone() {
        return new PlaceHolderDict(this.nVal);
    }

    @Override
    public IDictionary.DictType getDictType() {
        throw new RuntimeException("invalid to get dictionary type for PlaceHolderDict");
    }
}

