/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.functionobjects.ReduceRow;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateTernaryOperator;

public final class CLALibAggTernaryOp {
    private static final Log LOG = LogFactory.getLog((String)CLALibAggTernaryOp.class.getName());
    private final MatrixBlock m1;
    private final MatrixBlock m2;
    private final MatrixBlock m3;
    private final MatrixBlock ret;
    private final AggregateTernaryOperator op;
    private final boolean inCP;
    private static boolean warned = false;

    public static MatrixBlock agg(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, AggregateTernaryOperator op, boolean inCP) {
        int cl;
        int rl = op.indexFn instanceof ReduceRow ? 2 : 1;
        int n = cl = op.indexFn instanceof ReduceRow ? m1.getNumColumns() : 2;
        if (ret == null) {
            ret = new MatrixBlock(rl, cl, false);
        } else {
            ret.reset(rl, cl, false);
        }
        ret = new CLALibAggTernaryOp(m1, m2, m3, ret, op, inCP).exec();
        return ret;
    }

    private CLALibAggTernaryOp(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, AggregateTernaryOperator op, boolean inCP) {
        this.m1 = m1;
        this.m2 = m2;
        this.m3 = m3;
        this.ret = ret;
        this.op = op;
        this.inCP = inCP;
    }

    private MatrixBlock exec() {
        if (this.op.indexFn instanceof ReduceAll && this.op.aggOp.increOp.fn instanceof KahanPlus && this.op.binaryFn instanceof Multiply) {
            double v;
            if (this.m1.isEmptyBlock(false) || this.m2.isEmptyBlock(false) || this.m3 != null && this.m3.isEmptyBlock(false)) {
                if (this.op.aggOp.existsCorrection() && this.inCP) {
                    this.ret.dropLastRowsOrColumns(this.op.aggOp.correction);
                }
                return this.ret;
            }
            if (CLALibAggTernaryOp.isConst(this.m1) && (v = this.m1.get(0, 0)) == 1.0) {
                return new CLALibAggTernaryOp(this.m2, this.m3, null, this.ret, this.op, this.inCP).exec();
            }
        }
        return this.fallBack();
    }

    private static boolean isConst(MatrixBlock m) {
        if (m != null && m instanceof CompressedMatrixBlock) {
            List<AColGroup> gs = ((CompressedMatrixBlock)m).getColGroups();
            return gs.size() == 1 && gs.get(0) instanceof ColGroupConst;
        }
        return false;
    }

    private MatrixBlock fallBack() {
        this.warnDecompression();
        MatrixBlock m1UC = CompressedMatrixBlock.getUncompressed(this.m1);
        MatrixBlock m2UC = CompressedMatrixBlock.getUncompressed(this.m2);
        MatrixBlock m3UC = CompressedMatrixBlock.getUncompressed(this.m3);
        MatrixBlock ret2 = MatrixBlock.aggregateTernaryOperations(m1UC, m2UC, m3UC, this.ret, this.op, this.inCP);
        if (ret2.getNumRows() == 0 || ret2.getNumColumns() == 0) {
            throw new DMLCompressionException("Invalid output");
        }
        return ret2;
    }

    private void warnDecompression() {
        if (!warned) {
            boolean m1C = this.m1 instanceof CompressedMatrixBlock;
            boolean m2C = this.m2 instanceof CompressedMatrixBlock;
            boolean m3C = this.m3 instanceof CompressedMatrixBlock;
            StringBuilder sb = new StringBuilder(120);
            sb.append("aggregateTernaryOperations ");
            sb.append(this.op.aggOp.getClass().getSimpleName());
            sb.append(" ");
            sb.append(this.op.indexFn.getClass().getSimpleName());
            sb.append(" ");
            sb.append(this.op.aggOp.increOp.fn.getClass().getSimpleName());
            sb.append(" ");
            sb.append(this.op.binaryFn.getClass().getSimpleName());
            sb.append(" m1,m2,m3 ");
            sb.append(m1C);
            sb.append(" ");
            sb.append(m2C);
            sb.append(" ");
            sb.append(m3C);
            LOG.warn((Object)sb.toString());
            warned = true;
        }
    }
}

