/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.Renderable;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.SelectModelVisitor;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.Request;

public class Checklist
extends AbstractField {
    @Parameter(required=true)
    private SelectModel model;
    @Parameter(required=true, autoconnect=true)
    private List<Object> selected;
    @Parameter(required=true, allowNull=false)
    private ValueEncoder<Object> encoder;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Inject
    private Request request;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    @Property
    private List<Renderable> availableOptions;

    void setupRender() {
        this.availableOptions = CollectionFactory.newList();
        SelectModelVisitor visitor = new SelectModelVisitor(){

            @Override
            public void beginOptionGroup(OptionGroupModel groupModel) {
            }

            @Override
            public void option(OptionModel optionModel) {
                Checklist.this.availableOptions.add(new RenderCheckbox(optionModel));
            }

            @Override
            public void endOptionGroup(OptionGroupModel groupModel) {
            }
        };
        this.model.visit(visitor);
    }

    @Override
    protected void processSubmission(String controlName) {
        String[] parameters = this.request.getParameters(controlName);
        List selected = this.selected;
        if (selected == null) {
            selected = CollectionFactory.newList();
        } else {
            selected.clear();
        }
        if (parameters != null) {
            for (String value : parameters) {
                Object objectValue = this.encoder.toValue(value);
                selected.add(objectValue);
            }
        }
        this.putPropertyNameIntoBeanValidationContext("selected");
        try {
            this.fieldValidationSupport.validate(selected, this.resources, this.validate);
            this.selected = selected;
        }
        catch (ValidationException e) {
            this.validationTracker.recordError(this, e.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    Set<Object> getSelected() {
        if (this.selected == null) {
            return Collections.emptySet();
        }
        return CollectionFactory.newSet(this.selected);
    }

    Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("selected", this.resources);
    }

    @Override
    public boolean isRequired() {
        return this.validate.isRequired();
    }

    void beginRender(MarkupWriter writer) {
        writer.element("div", "id", this.getClientId());
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    private final class RenderCheckbox
    implements Renderable {
        private final OptionModel model;

        private RenderCheckbox(OptionModel model) {
            this.model = model;
        }

        @Override
        public void render(MarkupWriter writer) {
            String clientValue = Checklist.this.encoder.toClient(this.model.getValue());
            writer.element("label", new Object[0]);
            Element checkbox = writer.element("input", "type", "checkbox", "name", Checklist.this.getControlName(), "value", clientValue);
            if (Checklist.this.getSelected().contains(this.model.getValue())) {
                checkbox.attribute("checked", "checked");
            }
            if (Checklist.this.isDisabled()) {
                writer.attributes("disabled", "disabled");
            }
            writer.write(this.model.getLabel());
            writer.end();
            writer.end();
        }
    }
}

