/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.dom.DefaultMarkupModel;
import org.apache.tapestry5.dom.Html5MarkupModel;
import org.apache.tapestry5.dom.MarkupModel;
import org.apache.tapestry5.dom.XMLMarkupModel;
import org.apache.tapestry5.internal.parser.DTDToken;
import org.apache.tapestry5.internal.parser.TemplateToken;
import org.apache.tapestry5.internal.parser.TokenType;
import org.apache.tapestry5.internal.services.ComponentTemplateSource;
import org.apache.tapestry5.internal.services.MarkupWriterImpl;
import org.apache.tapestry5.internal.services.PageContentTypeAnalyzer;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.services.MarkupWriterFactory;
import org.apache.tapestry5.services.pageload.ComponentRequestSelectorAnalyzer;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;

public class MarkupWriterFactoryImpl
implements MarkupWriterFactory {
    private final PageContentTypeAnalyzer pageContentTypeAnalyzer;
    private final RequestPageCache cache;
    private final ComponentTemplateSource templateSource;
    private final ComponentRequestSelectorAnalyzer componentRequestSelectorAnalyzer;
    private final MarkupModel htmlModel = new DefaultMarkupModel();
    private final MarkupModel xmlModel = new XMLMarkupModel();
    private final MarkupModel htmlPartialModel = new DefaultMarkupModel(true);
    private final MarkupModel xmlPartialModel = new XMLMarkupModel(true);
    private final MarkupModel html5Model = new Html5MarkupModel();
    private final MarkupModel html5PartialModel = new Html5MarkupModel(true);

    public MarkupWriterFactoryImpl(PageContentTypeAnalyzer pageContentTypeAnalyzer, RequestPageCache cache, ComponentTemplateSource templateSource, ComponentRequestSelectorAnalyzer componentRequestSelectorAnalyzer) {
        this.pageContentTypeAnalyzer = pageContentTypeAnalyzer;
        this.cache = cache;
        this.templateSource = templateSource;
        this.componentRequestSelectorAnalyzer = componentRequestSelectorAnalyzer;
    }

    @Override
    public MarkupWriter newMarkupWriter(ContentType contentType) {
        return this.constructMarkupWriter(contentType, false, false);
    }

    @Override
    public MarkupWriter newPartialMarkupWriter(ContentType contentType) {
        return this.constructMarkupWriter(contentType, true, false);
    }

    private MarkupWriter constructMarkupWriter(ContentType contentType, boolean partial, boolean HTML5) {
        String mimeType = contentType.getMimeType();
        boolean isHTML = mimeType.equalsIgnoreCase("text/html");
        MarkupModel model = isHTML ? (HTML5 ? (partial ? this.html5PartialModel : this.html5Model) : (partial ? this.htmlPartialModel : this.htmlModel)) : (partial ? this.xmlPartialModel : this.xmlModel);
        return new MarkupWriterImpl(model, contentType.getCharset(), mimeType);
    }

    @Override
    public MarkupWriter newMarkupWriter(String pageName) {
        Page page = this.cache.get(pageName);
        return this.newMarkupWriter(page);
    }

    private boolean hasHTML5Doctype(Page page) {
        ComponentModel componentModel = page.getRootComponent().getComponentResources().getComponentModel();
        ComponentResourceSelector selector = this.componentRequestSelectorAnalyzer.buildSelectorForRequest();
        List<TemplateToken> tokens = this.templateSource.getTemplate(componentModel, selector).getTokens();
        DTDToken dtd = null;
        for (TemplateToken token : tokens) {
            if (token.getTokenType() != TokenType.DTD) continue;
            dtd = (DTDToken)token;
            break;
        }
        return dtd != null && dtd.name.equalsIgnoreCase("html") && dtd.publicId == null && dtd.systemId == null;
    }

    @Override
    public MarkupWriter newMarkupWriter(Page page) {
        boolean isHTML5 = this.hasHTML5Doctype(page);
        ContentType contentType = this.pageContentTypeAnalyzer.findContentType(page);
        return this.constructMarkupWriter(contentType, false, isHTML5);
    }

    @Override
    public MarkupWriter newPartialMarkupWriter(Page page) {
        boolean isHTML5 = this.hasHTML5Doctype(page);
        ContentType contentType = this.pageContentTypeAnalyzer.findContentType(page);
        return this.constructMarkupWriter(contentType, true, isHTML5);
    }

    @Override
    public MarkupWriter newPartialMarkupWriter(String pageName) {
        Page page = this.cache.get(pageName);
        return this.newPartialMarkupWriter(page);
    }
}

