/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import org.apache.tapestry5.internal.services.DocumentLinker;
import org.apache.tapestry5.internal.services.ModuleInitsManager;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.ModuleConfigurationCallback;
import org.apache.tapestry5.services.javascript.StylesheetLink;

public class PartialMarkupDocumentLinker
implements DocumentLinker {
    private final JSONArray libraryURLs = new JSONArray();
    private final JSONArray stylesheets = new JSONArray();
    private final ModuleInitsManager initsManager = new ModuleInitsManager();

    @Override
    public void addCoreLibrary(String libraryURL) {
        this.notImplemented("addCoreLibrary");
    }

    @Override
    public void addLibrary(String libraryURL) {
        this.libraryURLs.put((Object)libraryURL);
    }

    @Override
    public void addStylesheetLink(StylesheetLink stylesheet) {
        JSONObject object = new JSONObject(new Object[]{"href", stylesheet.getURL(), "media", stylesheet.getOptions().media});
        this.stylesheets.put((Object)object);
    }

    private void notImplemented(String methodName) {
        throw new UnsupportedOperationException(String.format("DocumentLinker.%s() is not implemented for partial page renders.", methodName));
    }

    @Override
    public void addScript(InitializationPriority priority, String script) {
        this.notImplemented("addScript");
    }

    @Override
    public void addModuleConfigurationCallback(ModuleConfigurationCallback callback) {
        this.notImplemented("moduleConfigurationCallback");
    }

    @Override
    public void addInitialization(InitializationPriority priority, String moduleName, String functionName, JSONArray arguments) {
        this.initsManager.addInitialization(priority, moduleName, functionName, arguments);
    }

    public void commit(JSONObject reply) {
        List<?> inits;
        if (this.libraryURLs.length() > 0) {
            reply.in("_tapestry").put("libraries", (Object)this.libraryURLs);
        }
        if (this.stylesheets.length() > 0) {
            reply.in("_tapestry").put("stylesheets", (Object)this.stylesheets);
        }
        if ((inits = this.initsManager.getSortedInits()).size() > 0) {
            reply.in("_tapestry").put("inits", (Object)JSONArray.from(inits));
        }
    }
}

