/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Locale;
import java.util.Set;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.services.PersistentLocale;

public class PersistentLocaleImpl
implements PersistentLocale {
    private final String supportedLocales;
    private final PerThreadValue<Locale> localeValue;
    private final Set<String> localeNames = CollectionFactory.newSet();

    public PersistentLocaleImpl(PerthreadManager perThreadManager, @Symbol(value="tapestry.supported-locales") String supportedLocales) {
        this.supportedLocales = supportedLocales;
        this.localeValue = perThreadManager.createValue();
        for (String name : TapestryInternalUtils.splitAtCommas(supportedLocales)) {
            this.localeNames.add(name.toLowerCase());
        }
    }

    @Override
    public void set(Locale locale) {
        assert (locale != null);
        if (!this.localeNames.contains(locale.toString().toLowerCase())) {
            String message = String.format("Locale '%s' is not supported by this application. Supported locales are '%s'; this is configured via the %s symbol.", locale, this.supportedLocales, "tapestry.supported-locales");
            throw new IllegalArgumentException(message);
        }
        this.localeValue.set((Object)locale);
    }

    @Override
    public Locale get() {
        return (Locale)this.localeValue.get();
    }

    @Override
    public boolean isSet() {
        return this.localeValue.exists();
    }
}

