/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import javax.persistence.PersistenceContext;
import org.apache.tapestry5.internal.jpa.JpaInternalUtils;
import org.apache.tapestry5.internal.transform.ReadOnlyComponentFieldConduit;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class PersistenceContextWorker
implements ComponentClassTransformWorker2 {
    private final EntityManagerManager entityManagerManager;

    public PersistenceContextWorker(EntityManagerManager entityManagerManager) {
        this.entityManagerManager = entityManagerManager;
    }

    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(PersistenceContext.class)) {
            final PersistenceContext annotation = (PersistenceContext)field.getAnnotation(PersistenceContext.class);
            field.claim((Object)annotation);
            field.setConduit((FieldConduit)new ReadOnlyComponentFieldConduit(plasticClass.getClassName(), field.getName()){

                public Object get(Object instance, InstanceContext context) {
                    return JpaInternalUtils.getEntityManager(PersistenceContextWorker.this.entityManagerManager, annotation);
                }
            });
        }
    }
}

