/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.internal.webresources.ResourceLessSource;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.assets.ResourceDependencies;
import org.apache.tapestry5.services.assets.ResourceTransformer;

public class LessResourceTransformer
implements ResourceTransformer {
    private static final ContentType CSS = new ContentType("text/css");
    private final LessCompiler compiler = new DefaultLessCompiler();

    public ContentType getTransformedContentType() {
        return CSS;
    }

    public InputStream transform(Resource source, ResourceDependencies dependencies) throws IOException {
        BytestreamCache compiled = this.invokeLessCompiler(source, dependencies);
        return compiled.openStream();
    }

    private BytestreamCache invokeLessCompiler(Resource source, ResourceDependencies dependencies) throws IOException {
        try {
            ResourceLessSource lessSource = new ResourceLessSource(source, dependencies);
            LessCompiler.CompilationResult compilationResult = this.compile(this.compiler, lessSource);
            return new BytestreamCache(compilationResult.getCss().getBytes("utf-8"));
        }
        catch (Less4jException ex) {
            throw new IOException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException(ex);
        }
    }

    protected LessCompiler.CompilationResult compile(LessCompiler compiler, LessSource lessSource) throws Less4jException {
        return compiler.compile(lessSource);
    }
}

