/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.cache;

import jakarta.annotation.PreDestroy;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.apache.cxf.jaxrs.client.cache.CacheControlClientReaderInterceptor;
import org.apache.cxf.jaxrs.client.cache.CacheControlClientRequestFilter;
import org.apache.cxf.jaxrs.client.cache.Entry;
import org.apache.cxf.jaxrs.client.cache.Key;

@Provider
public class CacheControlFeature
implements Feature,
Closeable {
    private CachingProvider provider;
    private CacheManager manager;
    private Cache<Key, Entry> cache;
    private boolean cacheResponseInputStream;

    @Override
    public boolean configure(FeatureContext context) {
        Cache<Key, Entry> entryCache = this.createCache(context.getConfiguration().getProperties());
        context.register(new CacheControlClientRequestFilter(entryCache));
        CacheControlClientReaderInterceptor reader = new CacheControlClientReaderInterceptor(entryCache);
        reader.setCacheResponseInputStream(this.cacheResponseInputStream);
        context.register(reader);
        return true;
    }

    @Override
    @PreDestroy
    public void close() {
        for (Closeable c : Arrays.asList(this.cache, this.manager, this.provider)) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (Exception exception) {}
        }
    }

    private Cache<Key, Entry> createCache(Map<String, Object> properties) {
        Properties props = new Properties();
        props.putAll(properties);
        String prefix = this.getClass().getName() + ".";
        String uri = props.getProperty(prefix + "config-uri");
        String name = props.getProperty(prefix + "name", this.getClass().getName());
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.provider = (CachingProvider)Caching.getCachingProviders().iterator().next();
        try {
            String expiry;
            String writer;
            this.manager = this.provider.getCacheManager(uri == null ? this.provider.getDefaultURI() : new URI(uri), contextClassLoader, props);
            MutableConfiguration configuration = new MutableConfiguration().setReadThrough("true".equalsIgnoreCase(props.getProperty(prefix + "readThrough", "false"))).setWriteThrough("true".equalsIgnoreCase(props.getProperty(prefix + "writeThrough", "false"))).setManagementEnabled("true".equalsIgnoreCase(props.getProperty(prefix + "managementEnabled", "false"))).setStatisticsEnabled("true".equalsIgnoreCase(props.getProperty(prefix + "statisticsEnabled", "false"))).setStoreByValue("true".equalsIgnoreCase(props.getProperty(prefix + "storeByValue", "false")));
            String loader = props.getProperty(prefix + "loaderFactory");
            if (loader != null) {
                Factory f = CacheControlFeature.newInstance(contextClassLoader, loader, Factory.class);
                configuration.setCacheLoaderFactory(f);
            }
            if ((writer = props.getProperty(prefix + "writerFactory")) != null) {
                Factory f = CacheControlFeature.newInstance(contextClassLoader, writer, Factory.class);
                configuration.setCacheWriterFactory(f);
            }
            if ((expiry = props.getProperty(prefix + "expiryFactory")) != null) {
                Factory f = CacheControlFeature.newInstance(contextClassLoader, expiry, Factory.class);
                configuration.setExpiryPolicyFactory(f);
            }
            this.cache = this.manager.createCache(name, (Configuration)configuration);
            return this.cache;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static <T> T newInstance(ClassLoader contextClassLoader, String clazz, Class<T> cast) {
        try {
            return (T)contextClassLoader.loadClass(clazz).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setCacheResponseInputStream(boolean cacheStream) {
        this.cacheResponseInputStream = cacheStream;
    }
}

