/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.cxf.jaxrs.impl.AbstractInterceptorContextImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class WriterInterceptorContextImpl
extends AbstractInterceptorContextImpl
implements WriterInterceptorContext {
    private List<WriterInterceptor> writers;
    private OutputStream os;
    private Object entity;

    public WriterInterceptorContextImpl(Object entity, Class<?> cls, Type type, Annotation[] anns, OutputStream os, Message message, List<WriterInterceptor> writers) {
        super(cls, type, anns, message);
        this.entity = entity;
        this.os = os;
        this.writers = writers;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public MultivaluedMap<String, Object> getHeaders() {
        return HttpUtils.getModifiableHeaders(this.m);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void proceed() throws IOException {
        if (this.writers == null || this.writers.isEmpty()) {
            return;
        }
        WriterInterceptor next = this.writers.remove(0);
        next.aroundWriteTo(this);
    }

    @Override
    public void setEntity(Object object) {
        this.entity = object;
        super.setType(this.entity != null ? this.entity.getClass() : null);
    }

    @Override
    public void setOutputStream(OutputStream stream) {
        this.os = stream;
        this.m.put(OutputStream.class, stream);
    }

    @Override
    public MediaType getMediaType() {
        Object value = this.getHeaders().getFirst("Content-Type");
        return value instanceof MediaType ? (MediaType)value : JAXRSUtils.toMediaType((String)value);
    }

    @Override
    public void setMediaType(MediaType mt) {
        if (!this.getMediaType().isCompatible(mt)) {
            this.providerSelectionPropertyChanged();
        }
        this.m.put("Content-Type", JAXRSUtils.mediaTypeToString(mt, new String[0]));
        this.getHeaders().putSingle("Content-Type", mt);
    }
}

