/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ColorPatternPanel;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;

public class ArtworkLook
extends EDialog {
    ColorPatternPanel.Info li;
    ElectricObject eObj;
    private JButton cancel;
    private JButton ok;

    public static void showArtworkLookDialog() {
        ArcInst ai;
        EditWindow wnd = EditWindow.getCurrent();
        Highlight h = wnd.getHighlighter().getOneHighlight();
        if (h == null) {
            return;
        }
        if (h.getType() != Highlight.Type.EOBJ) {
            System.out.println("Must select a single artwork node or arc");
            return;
        }
        ElectricObject eObj = h.getElectricObject();
        if (eObj instanceof PortInst) {
            eObj = ((PortInst)eObj).getNodeInst();
        }
        boolean foundArt = false;
        if (eObj instanceof NodeInst) {
            NodeInst ni = (NodeInst)eObj;
            if (ni.getProto() instanceof PrimitiveNode && ni.getProto().getTechnology() == Artwork.tech) {
                foundArt = true;
            }
        } else if (eObj instanceof ArcInst && (ai = (ArcInst)eObj).getProto().getTechnology() == Artwork.tech) {
            foundArt = true;
        }
        if (!foundArt) {
            System.out.println("Selected object must be from the Artwork technology");
            return;
        }
        ArtworkLook dialog = new ArtworkLook((Frame)TopLevel.getCurrentJFrame(), true, eObj);
        dialog.setVisible(true);
    }

    public ArtworkLook(Frame parent, boolean modal, ElectricObject eObj) {
        super(parent, modal);
        this.initComponents();
        this.eObj = eObj;
        this.getRootPane().setDefaultButton(this.ok);
        ColorPatternPanel colorPatternPanel = new ColorPatternPanel(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)colorPatternPanel, gbc);
        this.pack();
        EGraphics graphics = Artwork.makeGraphics(eObj);
        if (graphics == null) {
            graphics = new EGraphics(0, 0, 0, 0, 0, 0, 0.8, true, new int[]{65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535});
        }
        this.li = new ColorPatternPanel.Info(graphics);
        colorPatternPanel.setColorPattern(this.li);
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void applyDialog() {
        if (this.li.updateGraphics()) {
            ApplyChanges applyChanges = new ApplyChanges(this);
        }
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Appearance of Artwork");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ArtworkLook.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArtworkLook.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArtworkLook.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        this.applyDialog();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class ApplyChanges
    extends Job {
        ArtworkLook dialog;

        protected ApplyChanges(ArtworkLook dialog) {
            super("Update Edit Options", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            Artwork.setGraphics(this.dialog.li.graphics, this.dialog.eObj);
            return true;
        }
    }
}

