/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.id.LayerId;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.util.math.DBMath;
import java.awt.Color;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class Layer
implements Serializable,
Comparable {
    public static final double DEFAULT_THICKNESS = 0.0;
    public static final double DEFAULT_DISTANCE = 0.0;
    private static final int PTYPE = 64;
    private static final int NTYPE = 128;
    private static final int DEPLETION = 256;
    private static final int ENHANCEMENT = 512;
    private static final int LIGHT = 1024;
    private static final int HEAVY = 2048;
    private static final int DEEP = 4096;
    private static final int NONELEC = 8192;
    private static final int CONMETAL = 16384;
    private static final int CONPOLY = 32768;
    private static final int CONDIFF = 65536;
    private static final int NATIVE = 131072;
    private static final int HLVT = 0x200000;
    private static final int INTRANS = 0x400000;
    private static final int THICK = 0x800000;
    private static final int CARBNANO = 0x1000000;
    private static final LayerNumbers metalLayers = new LayerNumbers();
    private static final LayerNumbers contactLayers = new LayerNumbers();
    private static final LayerNumbers polyLayers = new LayerNumbers();
    private static List<Function> allFunctions;
    public static final LayerSortByFunctionLevel layerSortByFunctionLevel;
    public static final LayerSortByName layerSortByName;
    private final LayerId layerId;
    private int index = -1;
    private final Technology tech;
    private EGraphics factoryGraphics;
    private Function function;
    private static final int NO_FUNCTION_EXTRAS = 0;
    private int functionExtras;
    private final boolean pseudo;
    private Setting cifLayerSetting;
    private Setting dxfLayerSetting;
    private Setting skillLayerSetting;
    private Setting resistanceSetting;
    private Setting capacitanceSetting;
    private Setting edgeCapacitanceSetting;
    private Setting layer3DThicknessSetting;
    private Setting layer3DDistanceSetting;
    private Layer pseudoLayer;
    private Layer nonPseudoLayer;
    private boolean dimmed;
    private PrimitiveNode pureLayerNode;

    public static Function.Set getMultiLayersSet(Layer layer) {
        Function.Set thisLayerFunction = layer.getFunction().isPoly() ? new Function.Set(Function.POLY1, Function.GATE) : new Function.Set(layer);
        return thisLayerFunction;
    }

    public int compareTo(Object other) {
        String s = this.toString();
        String sOther = other.toString();
        return s.compareToIgnoreCase(sOther);
    }

    private Layer(String name, boolean pseudo, Technology tech, EGraphics graphics) {
        this.layerId = tech.getId().newLayerId(name);
        this.tech = tech;
        if (graphics == null) {
            throw new NullPointerException();
        }
        this.factoryGraphics = graphics;
        this.nonPseudoLayer = this;
        this.pseudo = pseudo;
        this.dimmed = false;
        this.function = Function.UNKNOWN;
    }

    protected Object writeReplace() {
        return new LayerKey(this);
    }

    public static Layer newInstance(Technology tech, String name, EGraphics graphics) {
        Color colorFromMap;
        if (tech == null) {
            throw new NullPointerException();
        }
        int transparent = graphics.getTransparentLayer();
        if (transparent != 0 && ((colorFromMap = tech.getFactoryTransparentLayerColors()[transparent - 1]).getRGB() & 0xFFFFFF) != graphics.getRGB()) {
            throw new IllegalArgumentException();
        }
        Layer layer = new Layer(name, false, tech, graphics);
        tech.addLayer(layer);
        return layer;
    }

    public Layer makePseudo() {
        assert (this.pseudoLayer == null);
        String pseudoLayerName = "Pseudo-" + this.getName();
        this.pseudoLayer = new Layer(pseudoLayerName, true, this.tech, this.factoryGraphics);
        this.pseudoLayer.setFunction(this.function, this.functionExtras);
        this.pseudoLayer.nonPseudoLayer = this;
        return this.pseudoLayer;
    }

    public LayerId getId() {
        return this.layerId;
    }

    public String getName() {
        return this.layerId.name;
    }

    public String getFullName() {
        return this.layerId.fullName;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    public void setGraphics(EGraphics graphics) {
        UserInterfaceMain.setGraphicsPreferences(UserInterfaceMain.getGraphicsPreferences().withGraphics(this, graphics));
    }

    public EGraphics getGraphics() {
        return UserInterfaceMain.getGraphicsPreferences().getGraphics(this);
    }

    public EGraphics getFactoryGraphics() {
        return this.factoryGraphics;
    }

    public void setFunction(Function function) {
        this.function = function;
        this.functionExtras = 0;
    }

    public void setFunction(Function function, int functionExtras) {
        this.function = function;
        int numBits = 0;
        for (int i = 0; i < 32; ++i) {
            if ((functionExtras & 1 << i) == 0) continue;
            ++numBits;
        }
        if (numBits >= 2 && functionExtras != 2304 && functionExtras != 1280 && functionExtras != 2560 && functionExtras != 1536 || numBits == 1 && Function.getExtraConstantName(functionExtras).length() == 0) {
            throw new IllegalArgumentException("functionExtras=" + Integer.toHexString(functionExtras));
        }
        this.functionExtras = functionExtras;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getFunctionExtras() {
        return this.functionExtras;
    }

    public void setPureLayerNode(PrimitiveNode pln) {
        this.pureLayerNode = pln;
    }

    public PrimitiveNode makePureLayerNode(String nodeName, double size2, Poly.Type style, String portName, ArcProto ... connections) {
        PrimitiveNode pln = PrimitiveNode.newInstance0(nodeName, this.tech, size2, size2, new Technology.NodeLayer[]{new Technology.NodeLayer(this, 0, style, 1, Technology.TechPoint.makeFullBox())});
        pln.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this.tech, pln, connections, portName, 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())}, false);
        pln.setFunction(PrimitiveNode.Function.NODE);
        pln.setHoldsOutline();
        pln.setSpecialType(2);
        this.pureLayerNode = pln;
        return pln;
    }

    public PrimitiveNode getPureLayerNode() {
        return this.pureLayerNode;
    }

    public boolean isNonElectrical() {
        return (this.functionExtras & 0x2000) != 0;
    }

    public boolean isDiffusionLayer() {
        return !this.isPseudoLayer() && this.getFunction().isDiff();
    }

    public boolean isVTImplantLayer() {
        return this.function.isImplant() && (this.functionExtras & 0x200000) != 0;
    }

    public boolean isPolyCutLayer() {
        return this.function.isContact() && (this.functionExtras & 0x8000) != 0;
    }

    public boolean isCarbonNanotubeLayer() {
        return (this.functionExtras & 0x1000000) != 0;
    }

    public boolean isPseudoLayer() {
        return this.pseudo;
    }

    public Layer getPseudoLayer() {
        return this.pseudoLayer;
    }

    public Layer getNonPseudoLayer() {
        return this.nonPseudoLayer;
    }

    private Setting makeLayerSetting(String what, String factory) {
        String techName = this.tech.getTechName();
        return this.getSubNode(what).makeStringSetting(what + "LayerFor" + this.getName() + "IN" + techName, "technology/technologies", this.getName(), what + " tab", what + " for layer " + this.getName() + " in technology " + techName, factory);
    }

    private Setting makeParasiticSetting(String what, double factory) {
        return this.getSubNode(what).makeDoubleSetting(what + "ParasiticFor" + this.getName() + "IN" + this.tech.getTechName(), "technology/technologies", this.getName(), "Parasitic tab", "Technology " + this.tech.getTechName() + ", " + what + " for layer " + this.getName(), factory);
    }

    private Setting make3DSetting(String what, double factory) {
        factory = DBMath.round(factory);
        return this.getSubNode(what).makeDoubleSetting(what + "Of" + this.getName() + "IN" + this.tech.getTechName(), "technology/technologies", this.getName(), "3D tab", "Technology " + this.tech.getTechName() + ", 3D " + what + " for layer " + this.getName(), factory);
    }

    private Setting.Group getSubNode(String type) {
        return this.tech.getProjectSettings().node(type);
    }

    public void setFactory3DInfo(double thickness, double distance) {
        assert (!this.isPseudoLayer());
        thickness = DBMath.round(thickness);
        distance = DBMath.round(distance);
        this.layer3DDistanceSetting = this.make3DSetting("Distance", distance);
        this.layer3DThicknessSetting = this.make3DSetting("Thickness", thickness);
    }

    public double getDistance() {
        return this.layer3DDistanceSetting.getDouble();
    }

    public Setting getDistanceSetting() {
        return this.layer3DDistanceSetting;
    }

    public double getThickness() {
        return this.layer3DThicknessSetting.getDouble();
    }

    public Setting getThicknessSetting() {
        return this.layer3DThicknessSetting;
    }

    public double getDepth() {
        return DBMath.round(this.getDistance() + this.getThickness());
    }

    public void setFactoryCIFLayer(String cifLayer) {
        assert (!this.isPseudoLayer());
        this.cifLayerSetting = this.makeLayerSetting("CIF", cifLayer);
    }

    public String getCIFLayer() {
        return this.cifLayerSetting.getString();
    }

    public Setting getCIFLayerSetting() {
        return this.cifLayerSetting;
    }

    public void setFactoryDXFLayer(String dxfLayer) {
        assert (!this.isPseudoLayer());
        this.dxfLayerSetting = this.makeLayerSetting("DXF", dxfLayer);
    }

    public String getDXFLayer() {
        if (this.dxfLayerSetting == null) {
            return "";
        }
        return this.dxfLayerSetting.getString();
    }

    public Setting getDXFLayerSetting() {
        return this.dxfLayerSetting;
    }

    public void setFactorySkillLayer(String skillLayer) {
        assert (!this.isPseudoLayer());
        this.skillLayerSetting = this.makeLayerSetting("Skill", skillLayer);
    }

    public String getSkillLayer() {
        return this.skillLayerSetting.getString();
    }

    public Setting getSkillLayerSetting() {
        return this.skillLayerSetting;
    }

    public void setFactoryParasitics(double resistance, double capacitance, double edgeCapacitance) {
        assert (!this.isPseudoLayer());
        this.resistanceSetting = this.makeParasiticSetting("Resistance", resistance);
        this.capacitanceSetting = this.makeParasiticSetting("Capacitance", capacitance);
        this.edgeCapacitanceSetting = this.makeParasiticSetting("EdgeCapacitance", edgeCapacitance);
    }

    public double getResistance() {
        return this.resistanceSetting.getDouble();
    }

    public Setting getResistanceSetting() {
        return this.resistanceSetting;
    }

    public double getCapacitance() {
        return this.capacitanceSetting.getDouble();
    }

    public Setting getCapacitanceSetting() {
        return this.capacitanceSetting;
    }

    public double getEdgeCapacitance() {
        return this.edgeCapacitanceSetting.getDouble();
    }

    public Setting getEdgeCapacitanceSetting() {
        return this.edgeCapacitanceSetting;
    }

    void finish() {
        if (this.resistanceSetting == null || this.capacitanceSetting == null || this.edgeCapacitanceSetting == null) {
            this.setFactoryParasitics(0.0, 0.0, 0.0);
        }
        if (this.cifLayerSetting == null) {
            this.setFactoryCIFLayer("");
        }
        if (this.dxfLayerSetting == null) {
            this.setFactoryDXFLayer("");
        }
        if (this.skillLayerSetting == null) {
            this.setFactorySkillLayer("");
        }
        if (this.layer3DThicknessSetting == null || this.layer3DDistanceSetting == null) {
            double thickness = this.layer3DThicknessSetting != null ? this.getThickness() : 0.0;
            double distance = this.layer3DDistanceSetting != null ? this.getDistance() : 0.0;
            this.setFactory3DInfo(thickness, distance);
        }
    }

    public String toString() {
        return "Layer " + this.getName();
    }

    public void copyState(Layer that) {
        assert (this.getName().equals(that.getName()));
        if (this.pureLayerNode != null) assert (this.pureLayerNode.getId() == that.pureLayerNode.getId());
    }

    void dump(PrintWriter out, Map<Setting, Object> settings) {
        EGraphics factoryDesc;
        String[] layerBits = new String[]{null, null, null, null, null, null, "PTYPE", "NTYPE", "DEPLETION", "ENHANCEMENT", "LIGHT", "HEAVY", null, "NONELEC", "CONMETAL", "CONPOLY", "CONDIFF", null, null, null, null, "HLVT", "INTRANS", "THICK"};
        out.print("Layer " + this.getName() + " " + this.getFunction().name());
        Technology.printlnBits(out, layerBits, this.getFunctionExtras());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getCIFLayerSetting());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getDXFLayerSetting());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getSkillLayerSetting());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getResistanceSetting());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getCapacitanceSetting());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getEdgeCapacitanceSetting());
        EGraphics desc = factoryDesc = this.getFactoryGraphics();
        out.println("\tpatternedOnDisplay=" + desc.isPatternedOnDisplay() + "(" + factoryDesc.isPatternedOnDisplay() + ")");
        out.println("\tpatternedOnPrinter=" + desc.isPatternedOnPrinter() + "(" + factoryDesc.isPatternedOnPrinter() + ")");
        out.println("\toutlined=" + (Object)((Object)desc.getOutlined()) + "(" + (Object)((Object)factoryDesc.getOutlined()) + ")");
        out.println("\ttransparent=" + desc.getTransparentLayer() + "(" + factoryDesc.getTransparentLayer() + ")");
        out.println("\tcolor=" + Integer.toHexString(desc.getColor().getRGB()) + "(" + Integer.toHexString(factoryDesc.getRGB()) + ")");
        out.println("\topacity=" + desc.getOpacity() + "(" + factoryDesc.getOpacity() + ")");
        out.println("\tforeground=" + factoryDesc.getForeground());
        int[] pattern = factoryDesc.getPattern();
        out.print("\tpattern");
        for (int p : pattern) {
            out.print(" " + Integer.toHexString(p));
        }
        out.println();
        out.println("\tdistance3D=" + this.getDistanceSetting().getDoubleFactoryValue());
        out.println("\tthickness3D=" + this.getThicknessSetting().getDoubleFactoryValue());
        out.println("\tmode3D=" + (Object)((Object)factoryDesc.getTransparencyMode()));
        out.println("\tfactor3D=" + factoryDesc.getTransparencyFactor());
        if (this.getPseudoLayer() != null) {
            out.println("\tpseudoLayer=" + this.getPseudoLayer().getName());
        }
    }

    Xml.Layer makeXml() {
        Xml.Layer l = new Xml.Layer();
        l.name = this.getName();
        l.function = this.getFunction();
        l.extraFunction = this.getFunctionExtras();
        l.desc = this.getFactoryGraphics();
        l.height3D = this.getDistanceSetting().getDoubleFactoryValue();
        l.thick3D = this.getThicknessSetting().getDoubleFactoryValue();
        l.cif = (String)this.getCIFLayerSetting().getFactoryValue();
        l.skill = (String)this.getSkillLayerSetting().getFactoryValue();
        l.resistance = this.getResistanceSetting().getDoubleFactoryValue();
        l.capacitance = this.getCapacitanceSetting().getDoubleFactoryValue();
        l.edgeCapacitance = this.getEdgeCapacitanceSetting().getDoubleFactoryValue();
        if (this.pureLayerNode != null) {
            l.pureLayerNode = new Xml.PureLayerNode();
            l.pureLayerNode.name = this.pureLayerNode.getName();
            for (Map.Entry<String, PrimitiveNode> e : this.tech.getOldNodeNames().entrySet()) {
                if (e.getValue() != this.pureLayerNode) continue;
                assert (l.pureLayerNode.oldName == null);
                l.pureLayerNode.oldName = e.getKey();
            }
            l.pureLayerNode.style = this.pureLayerNode.getNodeLayers()[0].getStyle();
            l.pureLayerNode.port = this.pureLayerNode.getPort(0).getName();
            l.pureLayerNode.size.addLambda(DBMath.gridToLambda(2L * this.pureLayerNode.getFactoryDefaultGridExtendX()));
            for (ArcProto ap : this.pureLayerNode.getPort(0).getConnections()) {
                if (ap.getTechnology() != this.tech) continue;
                l.pureLayerNode.portArcs.add(ap.getName());
            }
        }
        return l;
    }

    static {
        layerSortByFunctionLevel = new LayerSortByFunctionLevel();
        layerSortByName = new LayerSortByName();
    }

    private static class LayerKey
    extends EObjectInputStream.Key<Layer> {
        public LayerKey() {
        }

        private LayerKey(Layer layer) {
            super(layer);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, Layer layer) throws IOException {
            out.writeObject(layer.getTechnology());
            out.writeInt(layer.getId().chronIndex);
        }

        @Override
        public Layer readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int chronIndex;
            Technology tech = (Technology)in.readObject();
            Layer layer = tech.getLayerByChronIndex(chronIndex = in.readInt());
            if (layer == null) {
                throw new InvalidObjectException("arc proto not found");
            }
            return layer;
        }
    }

    private static class LayerSortByName
    implements Comparator<Layer> {
        private LayerSortByName() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            String s1 = l1.getName();
            String s2 = l2.getName();
            return s1.compareToIgnoreCase(s2);
        }
    }

    public static class LayerSortByFunctionLevel
    implements Comparator<Layer> {
        @Override
        public int compare(Layer l1, Layer l2) {
            int level1 = l1.getFunction().getLevel();
            int level2 = l2.getFunction().getLevel();
            return level1 - level2;
        }

        public static int getNeighborLevel(Layer l1, Layer l2) {
            int level1 = l1.getFunction().getLevel();
            int level2 = l2.getFunction().getLevel();
            return level2 - level1;
        }
    }

    public static enum Function {
        UNKNOWN("unknown", 0, 0, 0, 35, 0, 0),
        METALNEG2("metal-2-local", -2, 0, 0, 13, 0, 0),
        METALNEG1("metal-1-local", -1, 0, 0, 15, 0, 0),
        METAL1("metal-1", 1, 0, 0, 17, 0, 0),
        METAL2("metal-2", 2, 0, 0, 19, 0, 0),
        METAL3("metal-3", 3, 0, 0, 21, 0, 0),
        METAL4("metal-4", 4, 0, 0, 23, 0, 0),
        METAL5("metal-5", 5, 0, 0, 25, 0, 0),
        METAL6("metal-6", 6, 0, 0, 27, 0, 0),
        METAL7("metal-7", 7, 0, 0, 29, 0, 0),
        METAL8("metal-8", 8, 0, 0, 31, 0, 0),
        METAL9("metal-9", 9, 0, 0, 33, 0, 0),
        METAL10("metal-10", 10, 0, 0, 35, 0, 0),
        METAL11("metal-11", 11, 0, 0, 37, 0, 0),
        METAL12("metal-12", 12, 0, 0, 39, 0, 0),
        POLY1("poly-1", 0, 0, 1, 12, 0, 0),
        POLY2("poly-2", 0, 0, 2, 13, 0, 0),
        POLY3("poly-3", 0, 0, 3, 14, 0, 0),
        GATE("gate", 0, 0, 0, 15, 0x400000, 0),
        DIFF("diffusion", 0, 0, 0, 11, 0, 0),
        DIFFP("p-diffusion", 0, 0, 0, 11, 64, 0),
        DIFFN("n-diffusion", 0, 0, 0, 11, 128, 0),
        DIFFNCN("n-diffusion-cn", 0, 0, 0, 11, 0x1000080, 0),
        DIFFPCN("n-diffusion-cn", 0, 0, 0, 11, 0x1000080, 0),
        IMPLANT("implant", 0, 0, 0, 2, 0, 0),
        IMPLANTP("p-implant", 0, 0, 0, 2, 64, 0),
        IMPLANTN("n-implant", 0, 0, 0, 2, 128, 0),
        CONTACT1("contact-1", 0, 1, 0, 16, 0, 0),
        CONTACT2("contact-2", 0, 2, 0, 18, 0, 0),
        CONTACT3("contact-3", 0, 3, 0, 20, 0, 0),
        CONTACT4("contact-4", 0, 4, 0, 22, 0, 0),
        CONTACT5("contact-5", 0, 5, 0, 24, 0, 0),
        CONTACT6("contact-6", 0, 6, 0, 26, 0, 0),
        CONTACT7("contact-7", 0, 7, 0, 28, 0, 0),
        CONTACT8("contact-8", 0, 8, 0, 30, 0, 0),
        CONTACT9("contact-9", 0, 9, 0, 32, 0, 0),
        CONTACT10("contact-10", 0, 10, 0, 34, 0, 0),
        CONTACT11("contact-11", 0, 11, 0, 36, 0, 0),
        CONTACT12("contact-12", 0, 12, 0, 38, 0, 0),
        PLUG("plug", 0, 0, 0, 40, 0, 0),
        OVERGLASS("overglass", 0, 0, 0, 41, 0, 0),
        RESISTOR("resistor", 0, 0, 0, 4, 0, 0),
        CAP("capacitor", 0, 0, 0, 5, 0, 0),
        TRANSISTOR("transistor", 0, 0, 0, 3, 0, 0),
        EMITTER("emitter", 0, 0, 0, 6, 0, 0),
        BASE("base", 0, 0, 0, 7, 0, 0),
        COLLECTOR("collector", 0, 0, 0, 8, 0, 0),
        SUBSTRATE("substrate", 0, 0, 0, 1, 0, 0),
        WELL("well", 0, 0, 0, 0, 0, 0),
        WELLP("p-well", 0, 0, 0, 0, 64, 0),
        WELLN("n-well", 0, 0, 0, 0, 128, 0),
        GUARD("guard", 0, 0, 0, 9, 0, 0),
        ISOLATION("isolation", 0, 0, 0, 10, 0, 0),
        BUS("bus", 0, 0, 0, 42, 0, 0),
        ART("art", 0, 0, 0, 43, 0, 0),
        CONTROL("control", 0, 0, 0, 44, 0, 0),
        TILENOT("tileNot", 0, 0, 0, 45, 0, 0),
        DMYPOLY1("dmy-poly-1", 0, 0, 0, POLY1.getHeight(), 0, 0),
        DMYPOLY2("dmy-poly-2", 0, 0, 0, POLY2.getHeight(), 0, 0),
        DMYPOLY3("dmy-poly-3", 0, 0, 0, POLY3.getHeight(), 0, 0),
        DMYDIFF("dmy-diffusion", 0, 0, 0, DIFF.getHeight(), 0, 0),
        DMYMETAL1("dmy-metal-1", 0, 0, 0, METAL1.getHeight(), 0, 1),
        DMYMETAL2("dmy-metal-2", 0, 0, 0, METAL2.getHeight(), 0, 2),
        DMYMETAL3("dmy-metal-3", 0, 0, 0, METAL3.getHeight(), 0, 3),
        DMYMETAL4("dmy-metal-4", 0, 0, 0, METAL4.getHeight(), 0, 4),
        DMYMETAL5("dmy-metal-5", 0, 0, 0, METAL5.getHeight(), 0, 5),
        DMYMETAL6("dmy-metal-6", 0, 0, 0, METAL6.getHeight(), 0, 6),
        DMYMETAL7("dmy-metal-7", 0, 0, 0, METAL7.getHeight(), 0, 7),
        DMYMETAL8("dmy-metal-8", 0, 0, 0, METAL8.getHeight(), 0, 8),
        DMYMETAL9("dmy-metal-9", 0, 0, 0, METAL9.getHeight(), 0, 9),
        DMYMETAL10("dmy-metal-10", 0, 0, 0, METAL10.getHeight(), 0, 10),
        DMYMETAL11("dmy-metal-11", 0, 0, 0, METAL11.getHeight(), 0, 11),
        DMYMETAL12("dmy-metal-12", 0, 0, 0, METAL12.getHeight(), 0, 12),
        DEXCLPOLY1("dexcl-poly-1", 0, 0, 0, POLY1.getHeight(), 0, 0),
        DEXCLPOLY2("dexcl-poly-2", 0, 0, 0, POLY2.getHeight(), 0, 0),
        DEXCLPOLY3("dexcl-poly-3", 0, 0, 0, POLY3.getHeight(), 0, 0),
        DEXCLDIFF("dexcl-diffusion", 0, 0, 0, DIFF.getHeight(), 0, 0),
        DEXCLMETAL1("dexcl-metal-1", 0, 0, 0, METAL1.getHeight(), 0, 1),
        DEXCLMETAL2("dexcl-metal-2", 0, 0, 0, METAL2.getHeight(), 0, 2),
        DEXCLMETAL3("dexcl-metal-3", 0, 0, 0, METAL3.getHeight(), 0, 3),
        DEXCLMETAL4("dexcl-metal-4", 0, 0, 0, METAL4.getHeight(), 0, 4),
        DEXCLMETAL5("dexcl-metal-5", 0, 0, 0, METAL5.getHeight(), 0, 5),
        DEXCLMETAL6("dexcl-metal-6", 0, 0, 0, METAL6.getHeight(), 0, 6),
        DEXCLMETAL7("dexcl-metal-7", 0, 0, 0, METAL7.getHeight(), 0, 7),
        DEXCLMETAL8("dexcl-metal-8", 0, 0, 0, METAL8.getHeight(), 0, 8),
        DEXCLMETAL9("dexcl-metal-9", 0, 0, 0, METAL9.getHeight(), 0, 9),
        DEXCLMETAL10("dexcl-metal-10", 0, 0, 0, METAL10.getHeight(), 0, 10),
        DEXCLMETAL11("dexcl-metal-11", 0, 0, 0, METAL11.getHeight(), 0, 11),
        DEXCLMETAL12("dexcl-metal-12", 0, 0, 0, METAL12.getHeight(), 0, 12);

        public static final int DEPLETION = 256;
        public static final int ENHANCEMENT = 512;
        public static final int LIGHT = 1024;
        public static final int HEAVY = 2048;
        public static final int NONELEC = 8192;
        public static final int CONMETAL = 16384;
        public static final int CONPOLY = 32768;
        public static final int CONDIFF = 65536;
        public static final int HLVT = 0x200000;
        public static final int THICK = 0x800000;
        public static final int NATIVE = 131072;
        public static final int DEEP = 4096;
        private final String name;
        private final boolean isMetal;
        private final boolean isContact;
        private final boolean isPoly;
        private final int level;
        private final int height;
        private final int extraBits;
        private static final int[] extras;

        private Function(String name, int metalLevel, int contactLevel, int polyLevel, int height, int extraBits, int genericLevel) {
            this.name = name;
            this.height = height;
            this.extraBits = extraBits;
            this.isMetal = metalLevel != 0;
            this.isContact = contactLevel != 0;
            this.isPoly = polyLevel != 0;
            int level = 0;
            if (genericLevel != 0) {
                level = genericLevel;
            }
            if (this.isMetal) {
                level = metalLevel;
                metalLayers.addLayer(this, level);
            }
            if (this.isContact) {
                level = contactLevel;
                contactLayers.addLayer(this, level);
            }
            if (this.isPoly) {
                level = polyLevel;
                polyLayers.addLayer(this, level);
            }
            this.level = level;
        }

        public String toString() {
            String toStr = this.name;
            for (int i = 0; i < extras.length; ++i) {
                if ((this.extraBits & extras[i]) == 0) continue;
                toStr = toStr + "," + Function.getExtraName(extras[i]);
            }
            return toStr;
        }

        public String getName() {
            return this.name;
        }

        public String getConstantName() {
            return this.name();
        }

        public static List<Function> getFunctions() {
            return allFunctions;
        }

        public static int[] getFunctionExtras() {
            return extras;
        }

        public static String getExtraName(int extra) {
            if (extra == 64) {
                return "p-type";
            }
            if (extra == 128) {
                return "n-type";
            }
            if (extra == 256) {
                return "depletion";
            }
            if (extra == 512) {
                return "enhancement";
            }
            if (extra == 1024) {
                return "light";
            }
            if (extra == 2048) {
                return "heavy";
            }
            if (extra == 8192) {
                return "nonelectrical";
            }
            if (extra == 16384) {
                return "connects-metal";
            }
            if (extra == 32768) {
                return "connects-poly";
            }
            if (extra == 65536) {
                return "connects-diff";
            }
            if (extra == 0x200000) {
                return "vt";
            }
            if (extra == 0x400000) {
                return "inside-transistor";
            }
            if (extra == 0x800000) {
                return "thick";
            }
            if (extra == 131072) {
                return "native";
            }
            if (extra == 4096) {
                return "deep";
            }
            if (extra == 0x1000000) {
                return "carb-nano";
            }
            return "";
        }

        public static String getExtraConstantName(int extra) {
            if (extra == 64) {
                return "PTYPE";
            }
            if (extra == 128) {
                return "NTYPE";
            }
            if (extra == 256) {
                return "DEPLETION";
            }
            if (extra == 512) {
                return "ENHANCEMENT";
            }
            if (extra == 1024) {
                return "LIGHT";
            }
            if (extra == 2048) {
                return "HEAVY";
            }
            if (extra == 8192) {
                return "NONELEC";
            }
            if (extra == 16384) {
                return "CONMETAL";
            }
            if (extra == 32768) {
                return "CONPOLY";
            }
            if (extra == 65536) {
                return "CONDIFF";
            }
            if (extra == 0x200000) {
                return "HLVT";
            }
            if (extra == 0x400000) {
                return "INTRANS";
            }
            if (extra == 0x800000) {
                return "THICK";
            }
            if (extra == 131072) {
                return "NATIVE";
            }
            if (extra == 4096) {
                return "DEEP";
            }
            if (extra == 0x1000000) {
                return "CN";
            }
            return "";
        }

        public static int parseExtraName(String name) {
            if (name.equalsIgnoreCase("p-type")) {
                return 64;
            }
            if (name.equalsIgnoreCase("n-type")) {
                return 128;
            }
            if (name.equalsIgnoreCase("depletion")) {
                return 256;
            }
            if (name.equalsIgnoreCase("enhancement")) {
                return 512;
            }
            if (name.equalsIgnoreCase("light")) {
                return 1024;
            }
            if (name.equalsIgnoreCase("heavy")) {
                return 2048;
            }
            if (name.equalsIgnoreCase("nonelectrical")) {
                return 8192;
            }
            if (name.equalsIgnoreCase("connects-metal")) {
                return 16384;
            }
            if (name.equalsIgnoreCase("connects-poly")) {
                return 32768;
            }
            if (name.equalsIgnoreCase("connects-diff")) {
                return 65536;
            }
            if (name.equalsIgnoreCase("inside-transistor")) {
                return 0x400000;
            }
            if (name.equalsIgnoreCase("thick")) {
                return 0x800000;
            }
            if (name.equalsIgnoreCase("vt")) {
                return 0x200000;
            }
            if (name.equalsIgnoreCase("native")) {
                return 131072;
            }
            if (name.equalsIgnoreCase("deep")) {
                return 4096;
            }
            if (name.equalsIgnoreCase("carb-nano")) {
                return 0x1000000;
            }
            return 0;
        }

        public int getLevel() {
            return this.level;
        }

        public static Function getMetal(int level) {
            if (level > 12) {
                System.out.println("Invalid metal layer level:" + level);
                return null;
            }
            Function func = metalLayers.get(level);
            return func;
        }

        public static Function getDummyMetal(int level) {
            if (level > 12) {
                System.out.println("Invalid metal layer level:" + level);
                return null;
            }
            switch (level) {
                case 0: {
                    return DMYMETAL1;
                }
                case 1: {
                    return DMYMETAL2;
                }
                case 2: {
                    return DMYMETAL3;
                }
                case 3: {
                    return DMYMETAL4;
                }
                case 4: {
                    return DMYMETAL5;
                }
                case 5: {
                    return DMYMETAL6;
                }
                case 6: {
                    return DMYMETAL7;
                }
                case 7: {
                    return DMYMETAL8;
                }
                case 8: {
                    return DMYMETAL9;
                }
                case 9: {
                    return DMYMETAL10;
                }
                case 10: {
                    return DMYMETAL11;
                }
                case 11: {
                    return DMYMETAL12;
                }
            }
            return null;
        }

        public static Function getDummyExclMetal(int l) {
            if (l > 12) {
                System.out.println("Invalid metal layer level:" + l);
                return null;
            }
            switch (l) {
                case 0: {
                    return DEXCLMETAL1;
                }
                case 1: {
                    return DEXCLMETAL2;
                }
                case 2: {
                    return DEXCLMETAL3;
                }
                case 3: {
                    return DEXCLMETAL4;
                }
                case 4: {
                    return DEXCLMETAL5;
                }
                case 5: {
                    return DEXCLMETAL6;
                }
                case 6: {
                    return DEXCLMETAL7;
                }
                case 7: {
                    return DEXCLMETAL8;
                }
                case 8: {
                    return DEXCLMETAL9;
                }
                case 9: {
                    return DEXCLMETAL10;
                }
                case 10: {
                    return DEXCLMETAL11;
                }
                case 11: {
                    return DEXCLMETAL12;
                }
            }
            return null;
        }

        public static Function getContact(int l) {
            if (l > 12) {
                System.out.println("Invalid via layer level:" + l);
                return null;
            }
            Function func = contactLayers.get(l);
            return func;
        }

        public static Function getPoly(int l) {
            Function func = polyLayers.get(l);
            return func;
        }

        public boolean isMetal() {
            return this.isMetal;
        }

        public boolean isDiff() {
            return this == DIFF || this == DIFFP || this == DIFFN || this == DIFFNCN || this == DIFFPCN;
        }

        public boolean isPoly() {
            return this.isPoly || this == GATE;
        }

        public boolean isGatePoly() {
            return this.isPoly() && (this.extraBits & 0x400000) != 0;
        }

        public boolean isContact() {
            return this.isContact;
        }

        public boolean isWell() {
            return this == WELL || this == WELLP || this == WELLN;
        }

        public boolean isSubstrate() {
            return this == SUBSTRATE || this == WELL || this == WELLP || this == WELLN || this == IMPLANT || this == IMPLANTN || this == IMPLANTP;
        }

        public boolean isImplant() {
            return this == IMPLANT || this == IMPLANTN || this == IMPLANTP;
        }

        public boolean isDummy() {
            return this == DMYDIFF || this == DMYPOLY1 || this == DMYPOLY2 || this == DMYPOLY3 || this == DMYMETAL1 || this == DMYMETAL2 || this == DMYMETAL3 || this == DMYMETAL4 || this == DMYMETAL5 || this == DMYMETAL6 || this == DMYMETAL7 || this == DMYMETAL8 || this == DMYMETAL9 || this == DMYMETAL10 || this == DMYMETAL11 || this == DMYMETAL12;
        }

        public boolean isDummyExclusion() {
            return this == DEXCLDIFF || this == DEXCLPOLY1 || this == DEXCLPOLY2 || this == DEXCLPOLY3 || this == DEXCLMETAL1 || this == DEXCLMETAL2 || this == DEXCLMETAL3 || this == DEXCLMETAL4 || this == DEXCLMETAL5 || this == DEXCLMETAL6 || this == DEXCLMETAL7 || this == DEXCLMETAL8 || this == DEXCLMETAL9 || this == DEXCLMETAL10 || this == DEXCLMETAL11 || this == DEXCLMETAL12;
        }

        public boolean isUsed(int numMetals, int numPolys) {
            if (this.isMetal || this.isContact || this.isDummyExclusion()) {
                return this.level <= numMetals;
            }
            if (this.isPoly) {
                return this.level <= numPolys;
            }
            return true;
        }

        public int getHeight() {
            return this.height;
        }

        static {
            extras = new int[]{64, 128, 256, 512, 1024, 2048, 8192, 16384, 32768, 65536, 0x200000, 0x400000, 0x800000, 0x1000000};
            allFunctions = Arrays.asList(Function.class.getEnumConstants());
        }

        public static class Set {
            final BitSet bits = new BitSet();
            int extraBits;
            public static final Set ALL = new Set((Function[])Function.class.getEnumConstants());

            public Set(Layer l) {
                this.bits.set(l.getFunction().ordinal());
                this.extraBits = l.getFunctionExtras();
            }

            public Set(Function ... funs) {
                for (Function f2 : funs) {
                    this.bits.set(f2.ordinal());
                }
                this.extraBits = 0;
            }

            public Set(Collection<Function> funs) {
                for (Function f2 : funs) {
                    this.bits.set(f2.ordinal());
                }
                this.extraBits = 0;
            }

            public void add(Layer l) {
                this.bits.set(l.getFunction().ordinal());
                this.extraBits |= l.getFunctionExtras();
            }

            public boolean contains(Function f2, int extraFunction) {
                int extra = this.extraBits & extraFunction;
                boolean extraBitsM = extraFunction == 0 || extra != 0;
                return extraBitsM && this.bits.get(f2.ordinal());
            }
        }
    }

    private static class LayerNumbers {
        private final ArrayList<Function> list = new ArrayList();
        private int base = 0;

        LayerNumbers() {
        }

        public void addLayer(Function fun, int level) {
            while (level < this.base) {
                --this.base;
                this.list.add(0, null);
            }
            while (this.list.size() <= level - this.base) {
                this.list.add(null);
            }
            Function oldFunction = this.list.set(level - this.base, fun);
            assert (oldFunction == null);
        }

        public Function get(int level) {
            return this.list.get(level - this.base);
        }
    }
}

