/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Schematic {
    private Set<ElectricObject> nodesChecked = new HashSet<ElectricObject>();
    private ErrorLogger errorLogger;
    private Map<Geometric, List<Variable>> newVariables = new HashMap<Geometric, List<Variable>>();
    private int cellIndexCounter;

    public static void doCheck(ErrorLogger errorLog, Cell cell, Geometric[] geomsToCheck, DRC.DRCPreferences dp) {
        Schematic s = new Schematic();
        s.errorLogger = errorLog;
        s.checkSchematicCellRecursively(cell, geomsToCheck);
        DRC.addDRCUpdate(0, null, null, null, null, s.newVariables, dp);
    }

    private Cell isACellToCheck(Geometric geo) {
        if (geo instanceof NodeInst) {
            NodeInst ni = (NodeInst)geo;
            if (ni.isIconOfParent()) {
                return null;
            }
            if (!ni.isCellInstance()) {
                return null;
            }
            Cell subCell = (Cell)ni.getProto();
            Cell contentsCell = subCell.contentsView();
            if (contentsCell == null) {
                contentsCell = subCell;
            }
            if (this.nodesChecked.contains(contentsCell)) {
                return null;
            }
            return contentsCell;
        }
        return null;
    }

    private void checkSchematicCellRecursively(Cell cell, Geometric[] geomsToCheck) {
        this.nodesChecked.add(cell);
        if (!cell.isSchematic() && cell.getTechnology() != Schematics.tech()) {
            return;
        }
        if (geomsToCheck == null) {
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                Cell contentsCell = this.isACellToCheck(ni);
                if (contentsCell == null) continue;
                this.checkSchematicCellRecursively(contentsCell, geomsToCheck);
            }
        } else {
            for (Geometric geo : geomsToCheck) {
                Cell contentsCell = this.isACellToCheck(geo);
                if (contentsCell == null) continue;
                this.checkSchematicCellRecursively(contentsCell, geomsToCheck);
            }
        }
        System.out.println("Checking schematic " + cell);
        ErrorGrouper eg = new ErrorGrouper(cell);
        this.checkSchematicCell(cell, false, geomsToCheck, eg);
    }

    private void checkSchematicCell(Cell cell, boolean justThis, Geometric[] geomsToCheck, ErrorGrouper eg) {
        int initialErrorCount = this.errorLogger.getNumErrors();
        Netlist netlist = cell.getNetlist();
        if (geomsToCheck == null) {
            Iterator<Geometric> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance() && ni.getProto().getTechnology() == Generic.tech()) continue;
                this.schematicDoCheck(netlist, ni, eg);
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                this.schematicDoCheck(netlist, ai, eg);
            }
        } else {
            for (Geometric geo : geomsToCheck) {
                this.schematicDoCheck(netlist, geo, eg);
            }
        }
        this.checkCaseInsensitiveNetworks(netlist, eg);
        this.checkArrayedIconsConflicts(cell, eg);
        int errorCount = this.errorLogger.getNumErrors();
        int thisErrors = errorCount - initialErrorCount;
        String indent = "   ";
        if (justThis) {
            indent = "";
        }
        if (thisErrors == 0) {
            System.out.println(indent + "No errors found");
        } else {
            System.out.println(indent + thisErrors + " errors found");
        }
        if (justThis) {
            this.errorLogger.termLogging(true);
        }
    }

    private void addVariable(NodeInst ni, Variable var) {
        List<Variable> list2 = this.newVariables.get(ni);
        if (list2 == null) {
            list2 = new ArrayList<Variable>();
            this.newVariables.put(ni, list2);
        }
        list2.add(var);
    }

    private void schematicDoCheck(Netlist netlist, Geometric geom, ErrorGrouper eg) {
        if (this.nodesChecked.contains(geom)) {
            return;
        }
        this.nodesChecked.add(geom);
        Cell cell = geom.getParent();
        if (geom instanceof NodeInst) {
            Iterator<Object> it;
            Iterator<Object> it2;
            NodeInst ni = (NodeInst)geom;
            NodeProto np = ni.getProto();
            if (np == Schematics.tech().busPinNode) {
                if (!ni.hasExports()) {
                    boolean found = false;
                    Iterator<Connection> it3 = ni.getConnections();
                    while (it3.hasNext()) {
                        Connection con = it3.next();
                        if (con.getArc().getProto() != Schematics.tech().bus_arc) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.errorLogger.logError("Bus pin does not connect to any bus arcs", geom, cell, null, eg.getSortKey());
                        return;
                    }
                }
                HashSet<Network> onPin = new HashSet<Network>();
                boolean hadBusses = false;
                it2 = ni.getConnections();
                while (it2.hasNext()) {
                    Connection con = it2.next();
                    ArcInst ai = con.getArc();
                    if (ai.getProto() != Schematics.tech().bus_arc) continue;
                    hadBusses = true;
                    int wid = netlist.getBusWidth(ai);
                    for (int i = 0; i < wid; ++i) {
                        Network net = netlist.getNetwork(ai, i);
                        onPin.add(net);
                    }
                }
                ArrayList<ArcInst> geomList = null;
                it = ni.getConnections();
                while (it.hasNext()) {
                    Network net;
                    Connection con = it.next();
                    ArcInst ai = con.getArc();
                    if (ai.getProto() != Schematics.tech().wire_arc || onPin.contains(net = netlist.getNetwork(ai, 0))) continue;
                    if (geomList == null) {
                        geomList = new ArrayList<ArcInst>();
                    }
                    geomList.add(ai);
                }
                if (geomList != null) {
                    geomList.add((ArcInst)((Object)ni));
                    String msg = hadBusses ? "Wire arcs do not connect to bus through a bus pin" : "Wire arcs do not connect to each other through a bus pin";
                    this.errorLogger.logMessage(msg, geomList, cell, eg.getSortKey(), true);
                    return;
                }
            }
            if (np.getFunction().isPin()) {
                if (!ni.hasExports() && !ni.hasConnections()) {
                    boolean found = false;
                    Iterator<Variable> it4 = ni.getVariables();
                    while (it4.hasNext()) {
                        Variable var = it4.next();
                        if (!var.isDisplay()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.errorLogger.logError("Stranded pin (not connected or exported)", geom, cell, null, eg.getSortKey());
                        return;
                    }
                }
                if (ni.isInlinePin()) {
                    this.errorLogger.logError("Unnecessary pin (between 2 arcs)", geom, cell, null, eg.getSortKey());
                    return;
                }
                Point2D pinLoc = ni.invisiblePinWithOffsetText(false);
                if (pinLoc != null) {
                    ArrayList<Geometric> geomList = new ArrayList<Geometric>();
                    ArrayList<EPoint> ptList = new ArrayList<EPoint>();
                    geomList.add(geom);
                    ptList.add(new EPoint(ni.getAnchorCenterX(), ni.getAnchorCenterY()));
                    ptList.add(new EPoint(pinLoc.getX(), pinLoc.getY()));
                    this.errorLogger.logMessageWithLines("Invisible pin has text in different location", geomList, ptList, cell, eg.getSortKey(), true);
                    return;
                }
            }
            if (np instanceof Cell) {
                Cell instCell = (Cell)np;
                Cell contentsCell = instCell.contentsView();
                if (contentsCell == null) {
                    contentsCell = instCell;
                }
                it2 = ni.getDefinedParameters();
                while (it2.hasNext()) {
                    String trueVarName;
                    Variable var = (Variable)it2.next();
                    assert (ni.isParam(var.getKey()));
                    Variable foundVar = contentsCell.getParameter(var.getKey());
                    if (foundVar == null) {
                        trueVarName = var.getTrueName();
                        this.errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " is invalid", geom, cell, null, eg.getSortKey());
                        continue;
                    }
                    if (var.getUnit() != foundVar.getUnit()) {
                        trueVarName = var.getTrueName();
                        this.errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " had incorrect units (now fixed)", geom, cell, null, eg.getSortKey());
                        this.addVariable(ni, var.withUnit(foundVar.getUnit()));
                    }
                    if (foundVar.isInterior()) {
                        if (!var.isDisplay()) continue;
                        trueVarName = var.getTrueName();
                        this.errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " should not be visible (now fixed)", geom, cell, null, eg.getSortKey());
                        this.addVariable(ni, var.withDisplay(false));
                        continue;
                    }
                    if (var.isDisplay()) continue;
                    trueVarName = var.getTrueName();
                    this.errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " should be visible (now fixed)", geom, cell, null, eg.getSortKey());
                    this.addVariable(ni, var.withDisplay(true));
                }
                String nodeName = ni.getName();
                it = netlist.getNetworks();
                while (it.hasNext()) {
                    Network net = (Network)it.next();
                    if (!net.hasName(nodeName)) continue;
                    this.errorLogger.logError("Node " + ni + " is named '" + nodeName + "' which conflicts with a network name in this cell", geom, cell, null, eg.getSortKey());
                    break;
                }
            }
            Cell parentCell = ni.getParent();
            Iterator<Cell> cIt = parentCell.getCellGroup().getCells();
            while (cIt.hasNext()) {
                Cell iconCell = cIt.next();
                if (iconCell.getView() != View.ICON) continue;
                it = ni.getExports();
                while (it.hasNext()) {
                    Export e = (Export)it.next();
                    List<Export> allExports = e.findAllEquivalents(iconCell, false);
                    for (Export iconExport : allExports) {
                        if (e.getCharacteristic() == iconExport.getCharacteristic()) continue;
                        this.errorLogger.logError("Export '" + e.getName() + "' on " + ni + " is " + e.getCharacteristic().getFullName() + " but export in icon cell " + iconCell.describe(false) + " is " + iconExport.getCharacteristic().getFullName(), geom, cell, null, eg.getSortKey());
                    }
                }
            }
            this.checkPortOverlap(netlist, ni, eg);
        } else {
            ArrayList<Geometric> geomList;
            int signals;
            Name name;
            ArcInst ai = (ArcInst)geom;
            boolean checkDangle = false;
            if (Artwork.isArtworkArc(ai.getProto())) {
                return;
            }
            Name arcName = ai.getNameKey();
            if (arcName == null || arcName.isTempname()) {
                checkDangle = true;
            }
            if (checkDangle && ai.getProto() == Schematics.tech().bus_arc && (name = netlist.getBusName(ai)) != null && !name.isTempname()) {
                checkDangle = false;
            }
            if (checkDangle) {
                for (int i = 0; i < 2; ++i) {
                    NodeInst ni = ai.getPortInst(i).getNodeInst();
                    if (!ni.getProto().getFunction().isPin() || ni.hasExports() || ni.getNumConnections() != 1) continue;
                    this.errorLogger.logError("Arc dangles", geom, cell, null, eg.getSortKey());
                    return;
                }
            }
            if ((signals = netlist.getBusWidth(ai)) < 1) {
                signals = 1;
            }
            for (int i = 0; i < 2; ++i) {
                int nodeSize;
                PortInst pi = ai.getPortInst(i);
                NodeInst ni = pi.getNodeInst();
                if (!ni.isCellInstance()) continue;
                Cell subNp = (Cell)ni.getProto();
                PortProto pp = pi.getPortProto();
                Cell np = subNp.contentsView();
                if (np != null && ((pp = ((Export)pi.getPortProto()).findEquivalent(np)) == null || pp == pi.getPortProto())) {
                    ArrayList<Geometric> geomList2 = new ArrayList<Geometric>();
                    geomList2.add(geom);
                    geomList2.add(ni);
                    this.errorLogger.logMessage("Arc " + ai.describe(true) + " connects to " + pi.getPortProto() + " of " + ni + ", but there is no equivalent port in " + np, geomList2, cell, eg.getSortKey(), true);
                    continue;
                }
                int portWidth = netlist.getBusWidth((Export)pp);
                if (portWidth < 1) {
                    portWidth = 1;
                }
                if ((nodeSize = ni.getNameKey().busWidth()) <= 0) {
                    nodeSize = 1;
                }
                if (signals == portWidth || signals == portWidth * nodeSize) continue;
                geomList = new ArrayList<Geometric>();
                geomList.add(geom);
                geomList.add(ni);
                this.errorLogger.logMessage("Arc " + ai.describe(true) + " (" + signals + " wide) connects to " + pp + " of " + ni + " (" + portWidth + " wide)", geomList, cell, eg.getSortKey(), true);
            }
            Rectangle2D rect = ai.getBounds();
            Network net = netlist.getNetwork(ai, 0);
            RTNode.Search sea = new RTNode.Search(rect, cell.getTopology().getRTree(), true);
            while (sea.hasNext()) {
                Rectangle2D bound;
                Network oNet;
                NodeInst ni;
                Geometric oGeom = (Geometric)sea.next();
                if (!(oGeom instanceof NodeInst) || (ni = (NodeInst)oGeom).getFunction() != PrimitiveNode.Function.PIN || ni.getProto().getTechnology() == Generic.tech() || net == (oNet = netlist.getNetwork(ni.getOnlyPortInst())) || (bound = ni.getBounds()).getWidth() > 0.0 || bound.getHeight() > 0.0) continue;
                Point2D.Double ctr = new Point2D.Double(bound.getCenterX(), bound.getCenterY());
                if (!GenMath.isOnLine(ai.getHeadLocation(), ai.getTailLocation(), ctr)) continue;
                geomList = new ArrayList();
                geomList.add(ai);
                geomList.add(ni);
                this.errorLogger.logMessage("Pin " + ni.describe(false) + " touches arc " + ai.describe(true) + " but does not connect to it ", geomList, cell, eg.getSortKey(), true);
            }
        }
    }

    private void checkPortOverlap(Netlist netlist, NodeInst ni, ErrorGrouper eg) {
        if (ni.getProto().getTechnology() == Generic.tech() || ni.getProto().getTechnology() == Artwork.tech()) {
            return;
        }
        Cell cell = ni.getParent();
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = it.next();
            Network net = netlist.getNetwork(pi);
            Rectangle2D bounds = pi.getPoly().getBounds2D();
            Iterator<RTBounds> sIt = cell.searchIterator(bounds);
            while (sIt.hasNext()) {
                NodeInst oNi;
                Geometric oGeom = (Geometric)sIt.next();
                if (!(oGeom instanceof NodeInst) || ni == (oNi = (NodeInst)oGeom) || ni.getNodeIndex() > oNi.getNodeIndex() || oNi.getProto().getTechnology() == Generic.tech() || oNi.getProto().getTechnology() == Artwork.tech()) continue;
                Iterator<PortInst> pIt = oNi.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst oPi = pIt.next();
                    Rectangle2D oBounds = oPi.getPoly().getBounds2D();
                    if (bounds.getMaxX() < oBounds.getMinX() || bounds.getMinX() > oBounds.getMaxX() || bounds.getMaxY() < oBounds.getMinY() || bounds.getMinY() > oBounds.getMaxY() || net == netlist.getNetwork(oPi)) continue;
                    ArrayList<NodeInst> geomList = new ArrayList<NodeInst>();
                    geomList.add(ni);
                    geomList.add(oNi);
                    this.errorLogger.logMessage("Nodes '" + ni + "' '" + oNi + "' have touching ports that are not connected", geomList, cell, eg.getSortKey(), true);
                    return;
                }
            }
        }
    }

    private void checkCaseInsensitiveNetworks(Netlist netlist, ErrorGrouper eg) {
        Cell cell = netlist.getCell();
        HashMap<String, Network> canonicToNetwork = new HashMap<String, Network>();
        Iterator<Network> it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            Iterator<String> sit = net.getNames();
            while (sit.hasNext()) {
                String s = sit.next();
                String cs = TextUtils.canonicString(s);
                Network net1 = (Network)canonicToNetwork.get(cs);
                if (net1 == null) {
                    canonicToNetwork.put(cs, net);
                    continue;
                }
                if (net1 == net) continue;
                String message = "Network: Schematic " + cell.libDescribe() + " doesn't connect " + net + " and " + net1;
                boolean sameName = net1.hasName(s);
                if (sameName) {
                    message = message + " Like-named Global and Export may be connected in future releases";
                }
                System.out.println(message);
                ArrayList<Geometric> geomList = new ArrayList<Geometric>();
                this.push(geomList, net);
                this.push(geomList, net1);
                this.errorLogger.logMessage(message, geomList, cell, eg.getSortKey(), sameName);
            }
        }
    }

    private void checkArrayedIconsConflicts(Cell cell, ErrorGrouper eg) {
        IdentityHashMap name2node = new IdentityHashMap();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Name n = ni.getNameKey();
            if (n.isTempname()) continue;
            for (int arrayIndex = 0; arrayIndex < n.busWidth(); ++arrayIndex) {
                Name subName = n.subname(arrayIndex);
                NodeInst oni = (NodeInst)name2node.get(subName);
                if (oni == null) continue;
                String msg = "Network: " + cell + " has instances " + ni + " and " + oni + " with same name <" + subName + ">";
                System.out.println(msg);
                List<Geometric> geomList = Arrays.asList(ni, oni);
                this.errorLogger.logMessage(msg, geomList, cell, eg.getSortKey(), true);
            }
        }
    }

    private void push(List<Geometric> geomList, Network net) {
        Iterator<Export> eit = net.getExports();
        if (eit.hasNext()) {
            geomList.add(eit.next().getOriginalPort().getNodeInst());
            return;
        }
        Iterator<ArcInst> ait = net.getArcs();
        if (ait.hasNext()) {
            geomList.add(ait.next());
            return;
        }
        Iterator<PortInst> pit = net.getPorts();
        if (pit.hasNext()) {
            geomList.add(pit.next().getNodeInst());
            return;
        }
    }

    private class ErrorGrouper {
        private boolean inited = false;
        private int cellIndex;
        private Cell cell;

        ErrorGrouper(Cell cell) {
            this.cellIndex = Schematic.this.cellIndexCounter++;
            this.cell = cell;
        }

        public int getSortKey() {
            if (!this.inited) {
                this.inited = true;
                Schematic.this.errorLogger.setGroupName(this.cellIndex, this.cell.getName());
            }
            return this.cellIndex;
        }
    }
}

