/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.Main;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class TechFactory {
    final String techName;
    private final List<Param> techParams;

    public static TechFactory fromXml(URL url, Xml.Technology xmlTech) {
        String techName = null;
        if (xmlTech != null) {
            techName = xmlTech.techName;
        }
        if (techName == null) {
            techName = TextUtils.getFileNameWithoutExtension(url);
        }
        return new FromXml(techName, true, url, xmlTech);
    }

    public Technology newInstance(Generic generic) {
        return this.newInstance(generic, Collections.<Param, Object>emptyMap());
    }

    public Technology newInstance(Generic generic, Map<Param, Object> paramValues) {
        block5: {
            try {
                HashMap<Param, Object> fixedParamValues = new HashMap<Param, Object>();
                for (Param param2 : this.techParams) {
                    Object value2 = paramValues.get(param2);
                    if (value2 == null || value2.getClass() != param2.factoryValue.getClass()) {
                        value2 = param2.factoryValue;
                    }
                    fixedParamValues.put(param2, value2);
                }
                Technology tech = this.newInstanceImpl(generic, fixedParamValues);
                tech.setup();
                return tech;
            }
            catch (ClassNotFoundException e) {
                TextUtils.recordMissingTechnology("Extra");
            }
            catch (Exception e) {
                System.out.println("ERROR while loading technology " + this.techName + ": " + (e != null ? e.getMessage() : "Assertion"));
                if (!Job.getDebug()) break block5;
                ActivityLogger.logException(e);
            }
        }
        return null;
    }

    public List<Param> getTechParams() {
        return this.techParams;
    }

    abstract String getDescription();

    void write(IdWriter writer) throws IOException {
        writer.writeString(this.techName);
        writer.writeBoolean(false);
    }

    public String toString() {
        return this.techName;
    }

    public static TechFactory getGenericFactory() {
        return new FromClass("generic", "com.sun.electric.technology.technologies.Generic");
    }

    public static Map<String, TechFactory> getKnownTechs() {
        LinkedHashMap<String, TechFactory> m = new LinkedHashMap<String, TechFactory>();
        TechFactory.c(m, "artwork", "com.sun.electric.technology.technologies.Artwork");
        TechFactory.c(m, "fpga", "com.sun.electric.technology.technologies.FPGA");
        TechFactory.c(m, "schematic", "com.sun.electric.technology.technologies.Schematics");
        TechFactory.r(m, "bicmos", "technology/technologies/bicmos.xml");
        TechFactory.r(m, "bipolar", "technology/technologies/bipolar.xml");
        TechFactory.r(m, "cmos", "technology/technologies/cmos.xml");
        TechFactory.r(m, "efido", "technology/technologies/efido.xml");
        TechFactory.c(m, "gem", "com.sun.electric.technology.technologies.GEM");
        TechFactory.r(m, "pcb", "technology/technologies/pcb.xml");
        TechFactory.r(m, "rcmos", "technology/technologies/rcmos.xml");
        TechFactory.p(m, "mocmos", "com.sun.electric.technology.technologies.MoCMOS");
        TechFactory.r(m, "mocmosold", "technology/technologies/mocmosold.xml");
        TechFactory.r(m, "mocmossub", "technology/technologies/mocmossub.xml");
        TechFactory.r(m, "nmos", "technology/technologies/nmos.xml");
        TechFactory.r(m, "tft", "technology/technologies/tft.xml");
        TechFactory.p(m, "tsmc180", "com.sun.electric.plugins.tsmc.TSMC180");
        TechFactory.p(m, "cmos90", "com.sun.electric.plugins.tsmc.CMOS90");
        TechFactory.r(m, "CLN40G", "plugins/tsmc/CLN40G.xml");
        TechFactory.r(m, "tsmcSun40GP", "plugins/tsmc/tsmcSun40GP.xml");
        return Collections.unmodifiableMap(m);
    }

    public static TechFactory getTechFactory(String techName) {
        return TechFactory.getKnownTechs().get(techName);
    }

    TechFactory(String techName) {
        this(techName, Collections.emptyList());
    }

    TechFactory(String techName, List<Param> techParams) {
        this.techName = techName;
        this.techParams = Collections.unmodifiableList(new ArrayList<Param>(techParams));
    }

    private static void p(Map<String, TechFactory> m, String techName, String techClassName) {
        FromParamClass techFactory;
        try {
            Class<?> techClass = Class.forName(techClassName);
            Method getTechParamsMethod = techClass.getMethod("getTechParams", new Class[0]);
            List params = (List)getTechParamsMethod.invoke(null, new Object[0]);
            techFactory = new FromParamClass(techName, techClass, params);
        }
        catch (Exception e) {
            TextUtils.recordMissingTechnology(techName);
            return;
        }
        m.put(techName, techFactory);
    }

    private static void c(Map<String, TechFactory> m, String techName, String techClassName) {
        m.put(techName, new FromClass(techName, techClassName));
    }

    private static void r(Map<String, TechFactory> m, String techName, String resourceName) {
        assert (techName != null);
        URL url = Main.class.getResource(resourceName);
        if (url == null) {
            return;
        }
        m.put(techName, new FromXml(techName, false, url, null));
    }

    abstract Technology newInstanceImpl(Generic var1, Map<Param, Object> var2) throws Exception;

    public Xml.Technology getXml(Map<Param, Object> params) throws Exception {
        return this.getXml(params, null);
    }

    public abstract Xml.Technology getXml(Map<Param, Object> var1, Map<Object, Map<String, Object>> var2) throws Exception;

    static TechFactory read(IdReader reader) throws IOException {
        String techName = reader.readString();
        boolean userDefined = reader.readBoolean();
        if (!userDefined) {
            return TechFactory.getKnownTechs().get(techName);
        }
        boolean hasUrl = reader.readBoolean();
        URL xmlUrl = hasUrl ? new URL(reader.readString()) : null;
        byte[] serializedXml = reader.readBytes();
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(serializedXml));
            Xml.Technology xmlTech = (Xml.Technology)in.readObject();
            in.close();
            return TechFactory.fromXml(xmlUrl, xmlTech);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class FromXml
    extends TechFactory {
        private final boolean userDefined;
        private final URL urlXml;
        private Xml.Technology xmlTech;
        private boolean xmlParsed;

        private FromXml(String techName, boolean userDefined, URL urlXml, Xml.Technology xmlTech) {
            super(techName);
            this.userDefined = userDefined;
            this.urlXml = urlXml;
            this.xmlTech = xmlTech;
        }

        @Override
        Technology newInstanceImpl(Generic generic, Map<Param, Object> paramValues) throws Exception {
            assert (paramValues.isEmpty());
            Xml.Technology xml = this.getXml(paramValues);
            if (xml == null) {
                return null;
            }
            Class techClass = Technology.class;
            if (xml.className != null) {
                techClass = Class.forName(xml.className);
            }
            return (Technology)techClass.getConstructor(Generic.class, TechFactory.class, Map.class, Xml.Technology.class).newInstance(generic, this, Collections.emptyMap(), xml);
        }

        @Override
        String getDescription() {
            return this.urlXml == null ? "technology description" : "from " + this.urlXml.getFile();
        }

        @Override
        public Xml.Technology getXml(Map<Param, Object> paramValues, Map<Object, Map<String, Object>> additionalAttributes) throws Exception {
            assert (paramValues.isEmpty());
            if (this.xmlTech == null && !this.xmlParsed) {
                this.xmlTech = Xml.parseTechnology(this.urlXml);
                this.xmlParsed = true;
                if (this.xmlTech == null) {
                    throw new Exception("Can't load extra technology: " + this.urlXml);
                }
                if (!this.xmlTech.techName.equals(this.techName)) {
                    String techName = this.xmlTech.techName;
                    this.xmlTech = null;
                    throw new Exception("Tech name " + techName + " doesn't match file name:" + this.urlXml);
                }
            }
            return this.xmlTech;
        }

        @Override
        void write(IdWriter writer) throws IOException {
            byte[] serializedXml;
            writer.writeString(this.techName);
            writer.writeBoolean(this.userDefined);
            if (!this.userDefined) {
                return;
            }
            boolean hasUrl = this.urlXml != null;
            writer.writeBoolean(hasUrl);
            if (hasUrl) {
                writer.writeString(this.urlXml.toString());
            }
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(byteStream);
                out.writeObject(this.xmlTech);
                out.flush();
                serializedXml = byteStream.toByteArray();
            }
            catch (Throwable e) {
                e.printStackTrace();
                serializedXml = new byte[]{};
            }
            writer.writeBytes(serializedXml);
        }
    }

    private static class FromParamClass
    extends TechFactory {
        private final Method getPatchedXmlMethod;
        Constructor<?> techConstructor;

        private FromParamClass(String techName, Class<?> techClass, List<Param> techParams) throws Exception {
            super(techName, techParams);
            this.getPatchedXmlMethod = techClass.getMethod("getPatchedXml", Map.class);
            this.techConstructor = techClass.getConstructor(Generic.class, TechFactory.class, Map.class, Xml.Technology.class);
        }

        @Override
        Technology newInstanceImpl(Generic generic, Map<Param, Object> paramValues) throws Exception {
            return (Technology)this.techConstructor.newInstance(generic, this, paramValues, this.getXml(paramValues));
        }

        @Override
        public Xml.Technology getXml(Map<Param, Object> params, Map<Object, Map<String, Object>> additionalAttributes) throws Exception {
            return (Xml.Technology)this.getPatchedXmlMethod.invoke(null, params);
        }

        @Override
        String getDescription() {
            return "from " + this.getPatchedXmlMethod.getName();
        }
    }

    private static class FromClass
    extends TechFactory {
        private final String techClassName;

        private FromClass(String techName, String techClassName) {
            super(techName, Collections.<Param>emptyList());
            this.techClassName = techClassName;
        }

        @Override
        Technology newInstanceImpl(Generic generic, Map<Param, Object> paramValues) throws Exception {
            assert (paramValues.isEmpty());
            Class<?> techClass = Class.forName(this.techClassName);
            return (Technology)techClass.getConstructor(Generic.class, TechFactory.class).newInstance(generic, this);
        }

        @Override
        public Xml.Technology getXml(Map<Param, Object> params, Map<Object, Map<String, Object>> additionalAttributes) throws Exception {
            IdManager idManager = new IdManager();
            Generic generic = Generic.newInstance(idManager);
            Technology tech = this.newInstance(generic, params);
            return tech.makeXml(additionalAttributes);
        }

        @Override
        String getDescription() {
            return "from " + this.techClassName;
        }
    }

    public static class Param {
        public final String xmlPath;
        public final String prefPath;
        public final Object factoryValue;

        public Param(String xmlPath, String prefPath, Object factoryValue) {
            this.xmlPath = xmlPath;
            this.prefPath = prefPath;
            this.factoryValue = factoryValue;
        }

        public boolean equals(Object o) {
            return o instanceof Param && this.xmlPath.equals(((Param)o).xmlPath);
        }

        public int hashCode() {
            return this.xmlPath.hashCode();
        }

        public String toString() {
            return this.xmlPath;
        }
    }
}

