/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.logicaleffort.CachedCell;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LENetwork;
import com.sun.electric.tool.logicaleffort.LENodable;
import com.sun.electric.tool.logicaleffort.LEPin;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.logicaleffort.LESizer2;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LENetlister2
extends LENetlister {
    protected LENetlister.NetlisterConstants constants;
    private Map<Cell, CachedCell> cellMap;
    private Map<Integer, LENetwork> globalNetworks;
    private List<LENodable> sizableLENodables;
    private List<LENodable> allLENodables;
    private Map<Nodable, LENodable> nodablesDefinitions;
    private LESizer2 sizer;
    private Job job;
    private PrintStream out;
    private boolean aborted;
    private ErrorLogger errorLogger;
    private HashMap<Export, Export> lePortError;
    private Cell topLevelCell;
    private boolean disableCaching = true;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_FIRSTPASS = false;
    private static final boolean DEBUG_PRINTCACHEDCELLS = false;

    public LENetlister2(Job job, Technology layoutTech) {
        super(layoutTech);
        Tool leTool = Tool.findTool("logical effort");
        this.constants = null;
        this.topLevelCell = null;
        this.job = job;
        this.cellMap = new HashMap<Cell, CachedCell>();
        this.globalNetworks = new HashMap<Integer, LENetwork>();
        this.sizableLENodables = new ArrayList<LENodable>();
        this.allLENodables = new ArrayList<LENodable>();
        this.nodablesDefinitions = new HashMap<Nodable, LENodable>();
        this.lePortError = new HashMap();
        this.out = new PrintStream(System.out);
        this.errorLogger = null;
        this.aborted = false;
    }

    @Override
    public boolean netlist(Cell cell, VarContext context, boolean useCaching) {
        boolean bl = this.disableCaching = !useCaching;
        assert (this.errorLogger == null);
        this.errorLogger = ErrorLogger.newInstance("LE Netlister");
        this.constants = this.getSettings(cell);
        if (this.constants == null) {
            this.constants = new LENetlister.NetlisterConstants(this.layoutTech);
            if (!this.saveSettings(this.constants, cell)) {
                return false;
            }
        }
        this.topLevelCell = cell;
        FirstPassEnum firstPass = new FirstPassEnum(this);
        HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)firstPass, SHORT_RESISTORS);
        firstPass.cleanup(this.disableCaching);
        System.out.println("Cached " + this.cellMap.size() + " cells");
        HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)this, SHORT_RESISTORS);
        return !this.aborted;
    }

    @Override
    public boolean size(LESizer.Alg algorithm) {
        boolean verbose = false;
        this.sizer = new LESizer2(algorithm, this, this.job, this.errorLogger);
        boolean success2 = this.sizer.optimizeLoops(this.constants.epsilon, this.constants.maxIterations, verbose, this.constants.alpha, this.constants.keeperRatio);
        this.sizer = null;
        return success2;
    }

    @Override
    public void getSizes(List<Float> sizes, List<String> varNames, List<NodeInst> nodes, List<VarContext> contexts) {
        Iterator<LENodable> cit = this.getSizeableNodables();
        while (cit.hasNext()) {
            LENodable leno = cit.next();
            Nodable no = leno.getNodable();
            NodeInst ni = no.getNodeInst();
            if (ni != null) {
                no = ni;
            }
            if (!leno.isLeGate()) continue;
            String varName = "LEDRIVE_" + leno.getName();
            sizes.add(new Float(leno.leX));
            varNames.add(varName);
            nodes.add(ni);
            contexts.add(leno.context);
        }
    }

    public void updateSizes(EditingPreferences ep) {
        Iterator<LENodable> cit = this.getSizeableNodables();
        while (cit.hasNext()) {
            LENodable leno = cit.next();
            Nodable no = leno.getNodable();
            NodeInst ni = no.getNodeInst();
            if (ni != null) {
                no = ni;
            }
            if (!leno.isLeGate()) continue;
            String varName = "LEDRIVE_" + leno.getName();
            this.topLevelCell.newVar(varName, (Object)new Float(leno.leX), ep);
            if (!(leno.leX < 1.0f)) continue;
            String msg = "WARNING: Instance " + ni + " has size " + TextUtils.formatDistance(leno.leX) + " less than 1 (" + leno.getName() + ")";
            System.out.println(msg);
            if (ni == null) continue;
            this.errorLogger.logWarning(msg, ni, ni.getParent(), leno.context, 2);
        }
    }

    @Override
    public void done() {
        this.errorLogger.termLogging(true);
    }

    @Override
    public ErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    @Override
    public void nullErrorLogger() {
        this.errorLogger = null;
    }

    @Override
    public LENetlister.NetlisterConstants getConstants() {
        return this.constants;
    }

    protected Iterator<LENodable> getSizeableNodables() {
        return this.sizableLENodables.iterator();
    }

    protected float getGlobalSU() {
        return this.constants.su;
    }

    protected LESizer2 getSizer() {
        return this.sizer;
    }

    protected float getKeeperRatio() {
        return this.constants.keeperRatio;
    }

    private LENetwork getNetwork(int globalID, HierarchyEnumerator.CellInfo info) {
        LENetwork net = this.globalNetworks.get(new Integer(globalID));
        if (net == null) {
            String name = info == null ? null : info.getUniqueNetName(globalID, ".");
            net = new LENetwork(name);
            this.globalNetworks.put(new Integer(globalID), net);
        }
        return net;
    }

    @Override
    public HierarchyEnumerator.CellInfo newCellInfo() {
        return new LECellInfo();
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        if (this.aborted) {
            return false;
        }
        if (((LETool.AnalyzeCell)this.job).checkAbort(null)) {
            this.aborted = true;
            return false;
        }
        LECellInfo leinfo = (LECellInfo)info;
        leinfo.leInit(this.constants);
        if (this.topLevelCell != info.getCell() && this.isSettingsConflict(leinfo.getSettings(), this.topLevelCell, info.getContext(), info.getCell())) {
            this.aborted = true;
            return false;
        }
        boolean enter = true;
        CachedCell cachedCell = this.cellMap.get(info.getCell());
        if (cachedCell != null && leinfo.getMFactor() == 1.0f) {
            for (Map.Entry<Network, LENetwork> entry : cachedCell.getLocalNetworks().entrySet()) {
                Network jnet = entry.getKey();
                LENetwork subnet = entry.getValue();
                int globalID = info.getNetID(jnet);
                LENetwork net = this.getNetwork(globalID, info);
                if (net == null) continue;
                net.add(subnet);
            }
            enter = false;
        }
        return enter;
    }

    @Override
    public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
        LENodable uniqueLeno;
        LECellInfo leinfo = (LECellInfo)info;
        LENodable def = this.nodablesDefinitions.get(ni);
        if (def == null) {
            return true;
        }
        LENetwork outputNet = null;
        if (def.isLeGate()) {
            Network outNet = def.getOutputNet();
            int globalID = info.getNetID(outNet);
            outputNet = this.getNetwork(globalID, info);
        }
        float localsu = this.constants.su;
        if (leinfo.getSU() != -1.0f) {
            localsu = leinfo.getSU();
        }
        if ((uniqueLeno = def.createUniqueInstance(info.getContext(), outputNet, leinfo.getMFactor(), localsu, this.constants)).isLeGate()) {
            this.sizableLENodables.add(uniqueLeno);
        }
        this.allLENodables.add(uniqueLeno);
        for (LEPin pin : uniqueLeno.getPins()) {
            int globalID = info.getNetID(pin.getNetwork());
            LENetwork net = this.getNetwork(globalID, info);
            net.add(pin);
        }
        return false;
    }

    public void doneVisitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    private LENodable.Type getType(Nodable ni, HierarchyEnumerator.CellInfo info) {
        Variable var = null;
        var = ni.getParameter(ATTR_LEGATE);
        if (var != null) {
            int gate = VarContext.objectToInt(info.getContext().evalVar(var), 1);
            if (gate == 1) {
                return LENodable.Type.LEGATE;
            }
        } else {
            var = ni.getParameter(ATTR_LEKEEPER);
            if (var != null) {
                int gate = VarContext.objectToInt(info.getContext().evalVar(var), 1);
                if (gate == 1) {
                    return LENodable.Type.LEKEEPER;
                }
            } else {
                int ignore;
                if (ni.getParameter(ATTR_LEWIRE) != null) {
                    return LENodable.Type.WIRE;
                }
                if (ni.getProto() != null && ni.getProto().getFunction().isTransistor()) {
                    return LENodable.Type.TRANSISTOR;
                }
                if (ni.getProto() != null && ni.getProto().getFunction().isCapacitor()) {
                    return LENodable.Type.CAPACITOR;
                }
                var = ni.getParameterOrVariable(ATTR_LEIGNORE);
                if (var != null ? (ignore = VarContext.objectToInt(info.getContext().evalVar(var), 1)) == 1 : (var = ni.getParameter(ATTR_LEIGNORE)) != null && (ignore = VarContext.objectToInt(info.getContext().evalVar(var), 1)) == 1) {
                    return LENodable.Type.IGNORE;
                }
            }
        }
        return null;
    }

    private LENodable createLENodable(LENodable.Type type, Nodable ni, HierarchyEnumerator.CellInfo info) {
        if (type == null) {
            return null;
        }
        Variable var = null;
        LENodable lenodable = new LENodable(ni, type, LETool.getMFactor(ni), ni.getParameter(ATTR_su), ni.getParameter(ATTR_LEPARALLGRP));
        Network outputNet = null;
        Netlist netlist = info.getNetlist();
        Iterator<PortProto> ppIt = ni.getProto().getPorts();
        while (ppIt.hasNext()) {
            PortProto pp = ppIt.next();
            float le = this.getLE(ni, type, pp, info);
            Network jnet = netlist.getNetwork(ni, pp, 0);
            LEPin.Dir dir = LEPin.Dir.INPUT;
            if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                dir = LEPin.Dir.OUTPUT;
                if ((type == LENodable.Type.LEGATE || type == LENodable.Type.LEKEEPER) && outputNet != null) {
                    System.out.println("Error: Sizable gate " + ni.getNodeInst() + " has more than one output port!! Ignoring Gate");
                    return null;
                }
                outputNet = jnet;
                lenodable.setOutputNet(jnet);
            }
            if (type == LENodable.Type.TRANSISTOR) {
                if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                    dir = LEPin.Dir.OUTPUT;
                }
                if (dir == LEPin.Dir.INPUT) {
                    float length;
                    var = ni.getParameterOrVariable(Schematics.ATTR_LENGTH);
                    if (var == null) {
                        System.out.println("Error: transistor " + ni.getName() + " has no length in Cell " + ni.getParent());
                    }
                    if ((length = VarContext.objectToFloat(info.getContext().evalVar(var), 2.0f)) != this.constants.x1inverter_length) {
                        le = le * length / this.constants.x1inverter_length;
                    }
                }
            }
            lenodable.addPort(pp.getName(), dir, le, jnet);
            if (type != LENodable.Type.WIRE) continue;
            break;
        }
        return lenodable;
    }

    private float getLE(Nodable ni, LENodable.Type type, PortProto pp, HierarchyEnumerator.CellInfo info) {
        Cell cell;
        Export exp;
        boolean leFound = false;
        float le = 1.0f;
        if (!(pp instanceof Export)) {
            return le;
        }
        Variable var = ((Export)pp).getParameterOrVariable(ATTR_le);
        if (var != null) {
            leFound = true;
            le = VarContext.objectToFloat(info.getContext().evalVar(var), 1.0f);
        } else if (pp.getCharacteristic() == PortCharacteristic.OUT && (type == LENodable.Type.LEGATE || type == LENodable.Type.LEKEEPER)) {
            float diff2 = 0.0f;
            var = ((Export)pp).getParameterOrVariable(ATTR_diffn);
            if (var != null) {
                diff2 += VarContext.objectToFloat(info.getContext().evalVar(var), 0.0f);
                leFound = true;
            }
            if ((var = ((Export)pp).getParameterOrVariable(ATTR_diffp)) != null) {
                diff2 += VarContext.objectToFloat(info.getContext().evalVar(var), 0.0f);
                leFound = true;
            }
            le = diff2 / 3.0f;
        }
        if (!(leFound || type != LENodable.Type.LEGATE && type != LENodable.Type.LEKEEPER || (exp = (cell = (Cell)ni.getProto()).findExport(pp.getName())) == null || this.lePortError.get(exp) != null)) {
            String msg = "Warning: Sizeable gate has no logical effort specified for port " + pp.getName() + " in " + cell;
            System.out.println(msg);
            this.errorLogger.logWarning(msg, exp, cell, info.getContext().push(ni), 0);
            this.lePortError.put(exp, exp);
        }
        return le;
    }

    @Override
    public void printStatistics() {
        float totalsize = 0.0f;
        float instsize = 0.0f;
        int numLEGates = 0;
        int numLEWires = 0;
        for (LENodable leno : this.allLENodables) {
            if (leno.isLeGate()) {
                ++numLEGates;
                instsize += leno.leX;
            }
            if (leno.getType() == LENodable.Type.WIRE) {
                ++numLEWires;
            }
            totalsize += leno.leX;
        }
        System.out.println("Number of LEGATEs: " + numLEGates);
        System.out.println("Total size of all LEGATEs: " + instsize);
    }

    @Override
    public float getTotalLESize() {
        float instsize = 0.0f;
        for (LENodable leno : this.allLENodables) {
            if (!leno.isLeGate()) continue;
            instsize += leno.leX;
        }
        return instsize;
    }

    @Override
    public boolean printResults(Nodable no, VarContext context) {
        if (no instanceof NodeInst) {
            no = Netlist.getNodableFor((NodeInst)no, 0);
        }
        LENodable leno = null;
        for (LENodable aleno : this.allLENodables) {
            if (aleno.getNodable().getNodeInst() != no.getNodeInst() || !aleno.context.getInstPath(".").equals(context.getInstPath("."))) continue;
            leno = aleno;
            break;
        }
        if (leno == null) {
            return false;
        }
        System.out.println("Netlister: Gate Cap=" + this.constants.gateCap + ", Alpha=" + this.constants.alpha);
        leno.print();
        LENetwork outputNet = leno.outputNetwork;
        ArrayList<LEPin> gatesDrivenPins = new ArrayList<LEPin>();
        ArrayList<LEPin> loadsDrivenPins = new ArrayList<LEPin>();
        ArrayList<LEPin> wiresDrivenPins = new ArrayList<LEPin>();
        ArrayList<LEPin> gatesFightingPins = new ArrayList<LEPin>();
        if (outputNet == null) {
            return false;
        }
        for (LEPin pin : outputNet.getAllPins()) {
            LENodable loopLeno = pin.getInstance();
            if (pin.getDir() == LEPin.Dir.INPUT) {
                if (loopLeno.isGate()) {
                    gatesDrivenPins.add(pin);
                }
                if (loopLeno.getType() == LENodable.Type.LOAD) {
                    loadsDrivenPins.add(pin);
                }
                if (loopLeno.getType() == LENodable.Type.TRANSISTOR) {
                    loadsDrivenPins.add(pin);
                }
                if (loopLeno.getType() == LENodable.Type.CAPACITOR) {
                    loadsDrivenPins.add(pin);
                }
                if (loopLeno.getType() == LENodable.Type.WIRE) {
                    wiresDrivenPins.add(pin);
                }
            }
            if (pin.getDir() != LEPin.Dir.OUTPUT) continue;
            if (loopLeno.isGate()) {
                gatesFightingPins.add(pin);
            }
            if (loopLeno.getType() != LENodable.Type.TRANSISTOR) continue;
            loadsDrivenPins.add(pin);
        }
        System.out.println("Note: Load = Size * LE * M");
        System.out.println("Note: Load = Size * LE * M * Alpha, for Gates Fighting");
        float totalLoad = 0.0f;
        System.out.println("  -------------------- Gates Driven (" + gatesDrivenPins.size() + ") --------------------");
        for (LEPin pin : gatesDrivenPins) {
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("  -------------------- Loads Driven (" + loadsDrivenPins.size() + ") --------------------");
        for (LEPin pin : loadsDrivenPins) {
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("  -------------------- Wires Driven (" + wiresDrivenPins.size() + ") --------------------");
        for (LEPin pin : wiresDrivenPins) {
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("  -------------------- Gates Fighting (" + gatesFightingPins.size() + ") --------------------");
        for (LEPin pin : gatesFightingPins) {
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("*** Total Load: " + TextUtils.formatDouble(totalLoad, 2));
        return true;
    }

    public static void test1() {
        LESizer.test1();
    }

    public static class LECellInfo
    extends LENetlister.LECellInfo {
        private CachedCell cachedCell;

        protected void setCachedCell(CachedCell c) {
            this.cachedCell = c;
        }

        protected CachedCell getCachedCell() {
            return this.cachedCell;
        }
    }

    private static class FirstPassEnum
    extends HierarchyEnumerator.Visitor {
        private LENetlister2 netlister;

        private FirstPassEnum(LENetlister2 netlister) {
            this.netlister = netlister;
        }

        @Override
        public HierarchyEnumerator.CellInfo newCellInfo() {
            return new LECellInfo();
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (this.netlister.aborted) {
                return false;
            }
            if (((LETool.AnalyzeCell)this.netlister.job).checkAbort(null)) {
                this.netlister.aborted = true;
                return false;
            }
            CachedCell cachedCell = (CachedCell)this.netlister.cellMap.get(info.getCell());
            if (cachedCell == null) {
                cachedCell = new CachedCell(info.getCell(), info.getNetlist());
                if (this.netlister.cellMap.containsKey(info.getCell())) {
                    System.out.println("Possible hash map conflict in netlister.cellMap!");
                }
                this.netlister.cellMap.put(info.getCell(), cachedCell);
                return true;
            }
            HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
            if (parentInfo != null) {
                Cell parent = info.getParentInfo().getCell();
                CachedCell parentCached = (CachedCell)this.netlister.cellMap.get(parent);
                Nodable no = info.getParentInst();
                parentCached.add(no, (LECellInfo)info.getParentInfo(), cachedCell, (LECellInfo)info, this.netlister.constants);
            }
            return false;
        }

        @Override
        public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
            LENodable.Type type;
            CachedCell cachedCell = (CachedCell)this.netlister.cellMap.get(info.getCell());
            if (ni.getNodeInst().isCellInstance()) {
                // empty if block
            }
            if ((type = this.netlister.getType(ni, info)) == null) {
                return true;
            }
            if (type == LENodable.Type.IGNORE) {
                return false;
            }
            LENodable leno = this.netlister.createLENodable(type, ni, info);
            if (leno == null) {
                return true;
            }
            cachedCell.add(ni, leno);
            if (this.netlister.nodablesDefinitions.containsKey(ni)) {
                System.out.println("Possible hash map conflict in netlister.nodablesDefinitions!");
            }
            this.netlister.nodablesDefinitions.put(ni, leno);
            return false;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            CachedCell cachedCell = (CachedCell)this.netlister.cellMap.get(info.getCell());
            HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
            if (parentInfo != null) {
                Cell parent = info.getParentInfo().getCell();
                CachedCell parentCached = (CachedCell)this.netlister.cellMap.get(parent);
                Nodable no = info.getParentInst();
                parentCached.add(no, (LECellInfo)info.getParentInfo(), cachedCell, (LECellInfo)info, this.netlister.constants);
            }
        }

        protected void cleanup(boolean disableCaching) {
            HashMap<Cell, CachedCell> cachedMap = new HashMap<Cell, CachedCell>();
            for (Map.Entry entry : this.netlister.cellMap.entrySet()) {
                Cell cell = (Cell)entry.getKey();
                CachedCell cachedCell = (CachedCell)entry.getValue();
                if (!cachedCell.isContextFree(this.netlister.constants)) continue;
                cachedMap.put(cell, cachedCell);
            }
            this.netlister.cellMap = cachedMap;
            if (disableCaching) {
                this.netlister.cellMap = new HashMap();
            }
        }
    }
}

