/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.algorithm;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarNodeBase;

public class AStarNode
extends AStarNodeBase<AStarNode> {
    private int horizontalCapacityPathNumber = 0;
    private int verticalCapacityPathNumber = 0;
    private int terminalCount = 0;
    private int temporaryBlockingState = 0;
    private int[] quadrants = new int[4];

    public AStarNode(int x2, int y, int z) {
        this.x = x2;
        this.y = y;
        this.z = z;
    }

    public AStarNode() {
    }

    @Override
    public int compareTo(AStarNode o) {
        return this.getTotalCost() - o.getTotalCost();
    }

    @Override
    public boolean equals(Object o) {
        return this.x == ((AStarNode)o).getX() && this.y == ((AStarNode)o).getY() && this.z == ((AStarNode)o).getZ();
    }

    public void setHorizontalCapacityPathNumber(int horizontalCapacityPathNumber) {
        this.horizontalCapacityPathNumber = horizontalCapacityPathNumber;
    }

    public int getHorizontalCapacityPathNumber() {
        return this.horizontalCapacityPathNumber;
    }

    public void setVerticalCapacityPathNumber(int verticalCapacityPathNumber) {
        this.verticalCapacityPathNumber = verticalCapacityPathNumber;
    }

    public int getVerticalCapacityPathNumber() {
        return this.verticalCapacityPathNumber;
    }

    public int getTerminalCount() {
        return this.terminalCount;
    }

    public void addTerminal(int quadrant) {
        int[] nArray = this.getQuadrants();
        int n = quadrant;
        nArray[n] = nArray[n] + 1;
        ++this.terminalCount;
    }

    public void setTemporaryBlockingState(int newTemporaryBlockingState) {
        this.temporaryBlockingState = newTemporaryBlockingState;
    }

    public int getTemporaryBlockingState() {
        return this.temporaryBlockingState;
    }

    public int[] getQuadrants() {
        return this.quadrants;
    }

    public int getMaxTerminalCountPerQuadrant() {
        return Math.max(Math.max(this.quadrants[0], this.quadrants[1]), Math.max(this.quadrants[2], this.quadrants[3]));
    }
}

