/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore1;

import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore.Tupel;
import com.sun.electric.tool.routing.experimentalLeeMoore1.RoutingPart;
import com.sun.electric.tool.routing.experimentalLeeMoore1.WiringPart;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Wiring {
    private static boolean DEBUG = false;
    protected static final boolean REPORTING = true;
    private static HashMap<String, Integer> metalLayerMap;
    private static List<RoutingFrame.RoutingLayer> allLayers;
    private static List<RoutingFrame.RoutingContact> allContacts;

    public static void init(List<RoutingFrame.RoutingLayer> layers, HashMap<String, Integer> map2, List<RoutingFrame.RoutingContact> allContacts, boolean output2) {
        DEBUG = output2;
        metalLayerMap = map2;
        allLayers = layers;
        Wiring.allContacts = allContacts;
    }

    public static RoutingFrame.RoutePoint[] connect(RoutingFrame.RoutingSegment rs, Tupel tA, Tupel tB) {
        RoutingFrame.RoutingLayer layer = Wiring.getRoutingLayerByTupelLayer(tA.getLayer());
        RoutingFrame.RoutePoint r1 = Wiring.placePin(tA.getLayer(), tA);
        RoutingFrame.RoutePoint r2 = Wiring.placePin(tB.getLayer(), tB);
        Wiring.connectRoutePoints(rs, r1, r2, layer);
        RoutingFrame.RoutePoint[] result2 = new RoutingFrame.RoutePoint[]{r1, r2};
        return result2;
    }

    public static void connect(RoutingFrame.RoutingSegment rs, RoutingFrame.RoutePoint rp1, RoutingFrame.RoutePoint rp2) {
        Wiring.connectRoutePoints(rs, rp1, rp2, rp1.getContact().getFirstLayer());
    }

    public static RoutingFrame.RoutePoint[] getRoutePoints(Tupel tA, Tupel tB) {
        RoutingFrame.RoutePoint r1 = Wiring.placePin(tA.getLayer(), tA);
        RoutingFrame.RoutePoint r2 = Wiring.placePin(tB.getLayer(), tB);
        RoutingFrame.RoutePoint[] result2 = new RoutingFrame.RoutePoint[]{r1, r2};
        return result2;
    }

    private static synchronized void connectRoutePoints(RoutingFrame.RoutingSegment rs, RoutingFrame.RoutePoint r1, RoutingFrame.RoutePoint r2, RoutingFrame.RoutingLayer layer) {
        if (DEBUG) {
            System.out.println("WIRING: Verbinde " + r1.getLocation() + "->" + r2.getLocation());
        }
        rs.addWireEnd(r1);
        rs.addWireEnd(r2);
        RoutingFrame.RouteWire rw = new RoutingFrame.RouteWire(layer, r1, r2, layer.getMinWidth());
        rs.addWire(rw);
    }

    private static void createWire(RoutingFrame.RoutingSegment rs, RoutingFrame.RoutePoint r1, RoutingFrame.RoutePoint r2, RoutingFrame.RoutingLayer layer) {
        if (DEBUG) {
            System.out.println("createWire@WIRING: Verbinde " + r1.getLocation() + "->" + r2.getLocation() + " auf Layer " + layer.getName());
        }
        RoutingFrame.RouteWire rw = new RoutingFrame.RouteWire(layer, r1, r2, layer.getMinWidth());
        rs.addWire(rw);
    }

    public static void connect(RoutingPart rp, List<Tupel> edgePoints) {
        RoutingFrame.RoutePoint rp2;
        boolean penultimateWireDirection;
        boolean makeAngularWiresRectangular = true;
        if (DEBUG && rp.rs.getFinishEnd().getLocation().equals(new Point2D.Double(1929.2, 331.6))) {
            System.out.println("Have it...");
        }
        LinkedList<WiringPart> contacts = new LinkedList<WiringPart>();
        boolean lastContactWasVia = false;
        RoutingFrame.RoutePoint rp1 = rp.getStartRoutePoint();
        boolean firstPoint = true;
        if (Wiring.containsStart(rp.rs, edgePoints)) {
            firstPoint = false;
        }
        int i = 0;
        Tupel t1 = edgePoints.get(i);
        Tupel t2 = edgePoints.get(i + 1);
        if (makeAngularWiresRectangular && Wiring.containsStart(rp.rs, edgePoints)) {
            penultimateWireDirection = Wiring.getWireDirection(t1, t2);
            rp2 = null;
            if (penultimateWireDirection) {
                rp2 = Wiring.placeContact(rp.rs.getStartLayers().get(0), rp1.getLocation().getX(), t1.getY_InsideElectric());
            }
            if (!penultimateWireDirection) {
                rp2 = Wiring.placeContact(rp.rs.getStartLayers().get(0), t1.getX_InsideElectric(), rp1.getLocation().getY());
            }
            if (rp2 == null && DEBUG) {
                System.out.println("RP2 ist null");
            }
            contacts.add(new WiringPart(rp.rs.getStartLayers().get(0), rp1, rp2, firstPoint, false));
            firstPoint = true;
            rp1 = rp2;
        }
        for (i = 1; i < edgePoints.size() - 1; ++i) {
            t1 = edgePoints.get(i);
            t2 = edgePoints.get(i + 1);
            if (t1.isEqualPosition(t1) && t1.getLayer() != t2.getLayer()) {
                RoutingFrame.RoutePoint rp22 = Wiring.placeVia(t1.getLayer(), t2.getLayer(), t1.getX_InsideElectric(), t1.getY_InsideElectric());
                contacts.add(new WiringPart(Wiring.getRoutingLayerByTupelLayer(t1.getLayer()), rp1, rp22, firstPoint, false));
                lastContactWasVia = true;
                rp1 = rp22;
            } else if (!lastContactWasVia) {
                RoutingFrame.RoutePoint rp23 = Wiring.placePin(t1.getLayer(), t1);
                contacts.add(new WiringPart(Wiring.getRoutingLayerByTupelLayer(t1.getLayer()), rp1, rp23, firstPoint, false));
                lastContactWasVia = false;
                rp1 = rp23;
            }
            firstPoint = true;
        }
        i = edgePoints.size() - 1;
        t1 = edgePoints.get(i);
        t2 = edgePoints.get(i - 1);
        if (makeAngularWiresRectangular && Wiring.containsEnd(rp.rs, edgePoints)) {
            penultimateWireDirection = Wiring.getWireDirection(t1, t2);
            rp2 = null;
            if (penultimateWireDirection) {
                rp2 = Wiring.placeContact(rp.rs.getFinishLayers().get(0), rp.getEndRoutePoint().getLocation().getX(), t1.getY_InsideElectric());
            }
            if (!penultimateWireDirection) {
                rp2 = Wiring.placeContact(rp.rs.getFinishLayers().get(0), t1.getX_InsideElectric(), rp.getEndRoutePoint().getLocation().getY());
            }
            if (rp2 == null && DEBUG) {
                System.out.println("RP2 ist null");
            }
            contacts.add(new WiringPart(rp.rs.getFinishLayers().get(0), rp1, rp2, firstPoint, false));
            rp1 = rp2;
        }
        t2 = edgePoints.get(edgePoints.size() - 1);
        RoutingFrame.RoutePoint rp24 = rp.getEndRoutePoint();
        boolean lastPoint = true;
        if (Wiring.containsEnd(rp.rs, edgePoints)) {
            lastPoint = false;
        }
        contacts.add(new WiringPart(Wiring.getRoutingLayerByTupelLayer(t2.getLayer()), rp1, rp24, firstPoint, lastPoint));
        Wiring.wireRoutePoints(contacts, rp.rs);
    }

    private static void wireRoutePoints(List<WiringPart> routes, RoutingFrame.RoutingSegment rs) {
        for (WiringPart wiringPart : routes) {
            RoutingFrame.RoutePoint rp1 = wiringPart.getStart();
            RoutingFrame.RoutePoint rp2 = wiringPart.getEnd();
            if (!wiringPart.isAlreadyWired_start) {
                rs.addWireEnd(rp1);
            }
            if (!wiringPart.isAlreadyWired_end) {
                rs.addWireEnd(rp2);
            }
            Wiring.createWire(rs, rp1, rp2, wiringPart.getLayer());
        }
    }

    private static boolean containsStart(RoutingFrame.RoutingSegment rs, List<Tupel> edgePoints) {
        Tupel t2;
        Tupel t1 = edgePoints.get(0);
        return t1.isEqualPosition(t2 = new Tupel(rs.getStartEnd().getLocation(), 0));
    }

    private static boolean containsEnd(RoutingFrame.RoutingSegment rs, List<Tupel> edgePoints) {
        Tupel t2;
        Tupel t1 = edgePoints.get(edgePoints.size() - 1);
        return t1.isEqualPosition(t2 = new Tupel(rs.getFinishEnd().getLocation(), 0));
    }

    private static boolean containsEndReversed(RoutingFrame.RoutingSegment rs, List<Tupel> edgePoints) {
        Tupel t2;
        Tupel t1 = edgePoints.get(0);
        return t1.isEqualPosition(t2 = new Tupel(rs.getFinishEnd().getLocation(), 0));
    }

    private static RoutingFrame.RoutePoint placePin(int layerID, Tupel t) {
        RoutingFrame.RoutingLayer layer = Wiring.getRoutingLayerByTupelLayer(layerID);
        if (DEBUG) {
            System.out.println("WIRING: Erstelle Pin auf [" + t.getX_InsideElectric() + ", " + t.getY_InsideElectric() + "]");
        }
        return new RoutingFrame.RoutePoint(layer.getPin(), new Point2D.Double(t.getX_InsideElectric(), t.getY_InsideElectric()), 0);
    }

    private static RoutingFrame.RoutePoint placeContact(RoutingFrame.RoutingLayer layer, double x2, double y) {
        if (DEBUG) {
            System.out.println("WIRING: Erstelle Pin auf [" + x2 + ", " + y + "]");
        }
        return new RoutingFrame.RoutePoint(layer.getPin(), new Point2D.Double(x2, y), 0);
    }

    private static RoutingFrame.RoutePoint placeVia(int layer1, int layer2, int x2, int y) {
        RoutingFrame.RoutingContact viaContact;
        RoutingFrame.RoutingLayer startLayer = Wiring.getRoutingLayerByTupelLayer(layer1);
        RoutingFrame.RoutingLayer finishLayer = Wiring.getRoutingLayerByTupelLayer(layer2);
        if (DEBUG) {
            System.out.println("WIRING: Erstelle Via auf [" + x2 + ", " + y + "];" + startLayer.getName() + "<->" + finishLayer.getName());
        }
        if ((viaContact = Wiring.getVia(startLayer, finishLayer)) == null && DEBUG) {
            System.out.println("ERROR: via contact is null. Startlayer: " + startLayer.getMetalNumber() + ", Finishlayer: " + finishLayer.getMetalNumber());
        }
        return new RoutingFrame.RoutePoint(viaContact, new Point2D.Double(x2, y), 0);
    }

    private static RoutingFrame.RoutingContact getVia(RoutingFrame.RoutingLayer l1, RoutingFrame.RoutingLayer l2) {
        for (RoutingFrame.RoutingContact rc : allContacts) {
            if ((!rc.getFirstLayer().equals(l1) || !rc.getSecondLayer().equals(l2)) && (!rc.getFirstLayer().equals(l2) || !rc.getSecondLayer().equals(l1))) continue;
            return rc;
        }
        return null;
    }

    private static RoutingFrame.RoutingLayer getRoutingLayerByTupelLayer(int layer) {
        return allLayers.get(metalLayerMap.get("Metal-" + (layer + 1)));
    }

    private static boolean getWireDirection(Tupel t1, Tupel t2) {
        return t1.getX_InsideRoutingArray() != t2.getX_InsideRoutingArray();
    }

    public static void connect(RoutingPart rp, List<Tupel> edgePoints, boolean reversed2) {
        if (reversed2) {
            Wiring.connectMultiterminal(rp, edgePoints);
        } else {
            Wiring.connect(rp, edgePoints);
        }
    }

    private static void connectMultiterminal(RoutingPart rp, List<Tupel> edgePoints) {
        boolean makeAngularWiresRectengular = true;
        LinkedList<WiringPart> contacts = new LinkedList<WiringPart>();
        boolean lastContactWasVia = false;
        RoutingFrame.RoutePoint rp1 = rp.getEndRoutePoint();
        boolean firstPoint = true;
        if (Wiring.containsEndReversed(rp.rs, edgePoints)) {
            firstPoint = false;
        }
        int i = 0;
        Tupel t1 = edgePoints.get(i);
        Tupel t2 = edgePoints.get(i + 1);
        if (makeAngularWiresRectengular && Wiring.containsEndReversed(rp.rs, edgePoints)) {
            boolean penultimateWireDirection = Wiring.getWireDirection(t1, t2);
            RoutingFrame.RoutePoint rp2 = null;
            if (penultimateWireDirection) {
                rp2 = Wiring.placeContact(rp.rs.getFinishLayers().get(0), rp1.getLocation().getX(), t1.getY_InsideElectric());
            }
            if (!penultimateWireDirection) {
                rp2 = Wiring.placeContact(rp.rs.getFinishLayers().get(0), t1.getX_InsideElectric(), rp1.getLocation().getY());
            }
            if (DEBUG && rp2 == null) {
                System.out.println("RP2 ist null");
            }
            contacts.add(new WiringPart(rp.rs.getFinishLayers().get(0), rp1, rp2, firstPoint, false));
            firstPoint = true;
            rp1 = rp2;
        }
        for (i = 1; i < edgePoints.size() - 1; ++i) {
            t1 = edgePoints.get(i);
            t2 = edgePoints.get(i + 1);
            if (t1.isEqualPosition(t1) && t1.getLayer() != t2.getLayer()) {
                RoutingFrame.RoutePoint rp2 = Wiring.placeVia(t1.getLayer(), t2.getLayer(), t1.getX_InsideElectric(), t1.getY_InsideElectric());
                contacts.add(new WiringPart(Wiring.getRoutingLayerByTupelLayer(t1.getLayer()), rp1, rp2, firstPoint, false));
                lastContactWasVia = true;
                rp1 = rp2;
            } else if (!lastContactWasVia) {
                RoutingFrame.RoutePoint rp2 = Wiring.placePin(t1.getLayer(), t1);
                contacts.add(new WiringPart(Wiring.getRoutingLayerByTupelLayer(t1.getLayer()), rp1, rp2, firstPoint, false));
                lastContactWasVia = false;
                rp1 = rp2;
            }
            firstPoint = true;
        }
        t2 = edgePoints.get(edgePoints.size() - 1);
        RoutingFrame.RoutePoint rp2 = Wiring.placePin(t2.getLayer(), t2);
        boolean lastPoint = false;
        contacts.add(new WiringPart(Wiring.getRoutingLayerByTupelLayer(t2.getLayer()), rp1, rp2, firstPoint, lastPoint));
        Wiring.wireRoutePoints(contacts, rp.rs);
    }
}

