/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.ui.ErrorLoggerTree;
import com.sun.electric.tool.user.ui.JobTree;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.collections.WeakReferences;
import com.sun.electric.util.math.MutableInteger;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ExplorerTreeModel
extends DefaultTreeModel {
    public static final String rootNode = "Explorer";
    private static final WeakReferences<TreeModelListener> allListeners = new WeakReferences();
    private final ArrayList<MutableTreeNode> contentExplorerNodes = new ArrayList();
    final DefaultMutableTreeNode jobExplorerNode = JobTree.getExplorerTree();
    final DefaultMutableTreeNode errorExplorerNode = ErrorLoggerTree.getExplorerTree();
    private final Object[] rootPath = new Object[]{"Explorer"};
    final Object[] jobPath = new Object[]{"Explorer", this.jobExplorerNode};
    final Object[] errorPath = new Object[]{"Explorer", this.errorExplorerNode};
    private static final int SHOWALPHABETICALLY = 1;
    private static final int SHOWBYCELLGROUP = 2;
    private static final int SHOWBYHIERARCHY = 3;
    private static int howToShow = 2;
    private static String libraryNode = "LIBRARIES";

    ExplorerTreeModel() {
        super(null);
    }

    @Override
    public Object getRoot() {
        return rootNode;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == rootNode) {
            if (index == this.contentExplorerNodes.size()) {
                return this.errorExplorerNode;
            }
            if (index == this.contentExplorerNodes.size() + 1) {
                return this.jobExplorerNode;
            }
            return this.contentExplorerNodes.get(index);
        }
        return super.getChild(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == rootNode) {
            return this.contentExplorerNodes.size() + 2;
        }
        return super.getChildCount(parent);
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == rootNode) {
            return false;
        }
        return super.isLeaf(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        super.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (parent == rootNode) {
            if (child == this.errorExplorerNode) {
                return this.contentExplorerNodes.size();
            }
            if (child == this.jobExplorerNode) {
                return this.contentExplorerNodes.size() + 1;
            }
            return this.contentExplorerNodes.indexOf(child);
        }
        return super.getIndexOfChild(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        allListeners.add(l);
        super.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        allListeners.remove(l);
        super.removeTreeModelListener(l);
    }

    static void fireTreeNodesChanged(Object source, TreePath treePath, int[] childIndices, Object[] children2) {
        TreeModelEvent e = new TreeModelEvent(source, treePath, childIndices, children2);
        Iterator<TreeModelListener> it = allListeners.reverseIterator();
        while (it.hasNext()) {
            TreeModelListener l = it.next();
            l.treeNodesChanged(e);
        }
    }

    static void fireTreeNodesInserted(Object source, TreePath treePath, int[] childIndices, Object[] children2) {
        TreeModelEvent e = new TreeModelEvent(source, treePath, childIndices, children2);
        Iterator<TreeModelListener> it = allListeners.reverseIterator();
        while (it.hasNext()) {
            TreeModelListener l = it.next();
            l.treeNodesInserted(e);
        }
    }

    static void fireTreeNodesRemoved(Object source, TreePath treePath, int[] childIndices, Object[] children2) {
        TreeModelEvent e = new TreeModelEvent(source, treePath, childIndices, children2);
        Iterator<TreeModelListener> it = allListeners.reverseIterator();
        while (it.hasNext()) {
            TreeModelListener l = it.next();
            l.treeNodesRemoved(e);
        }
    }

    static void fireTreeStructureChanged(Object source, TreePath treePath) {
        TreeModelEvent e = new TreeModelEvent(source, treePath, null, null);
        Iterator<TreeModelListener> it = allListeners.reverseIterator();
        while (it.hasNext()) {
            TreeModelListener l = it.next();
            l.treeStructureChanged(e);
        }
    }

    public void reload(Object[] path) {
        if (path != null) {
            this.fireTreeStructureChanged(this, path, null, null);
        }
    }

    public void nodesWereInserted(Object[] path, int[] childIndices) {
        if (this.listenerList != null && path != null && path.length > 0 && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            Object parent = path[path.length - 1];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = this.getChild(parent, childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, path, childIndices, newChildren);
        }
    }

    public void nodesWereRemoved(Object[] path, int[] childIndices, Object[] removedChildren) {
        if (path != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, path, childIndices, removedChildren);
        }
    }

    public void nodesChanged(Object[] path, int[] childIndices) {
        if (path == null || path.length == 0) {
            return;
        }
        Object node = path[path.length - 1];
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = this.getChild(node, childIndices[counter]);
                    }
                    this.fireTreeNodesChanged(this, path, childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, path, null, null);
            }
        }
    }

    @Override
    public TreeNode[] getPathToRoot(TreeNode aNode) {
        TreeNode[] path = super.getPathToRoot(aNode);
        return path;
    }

    @Override
    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            ++depth;
            if (aNode == this.root) {
                retNodes = new TreeNode[depth];
            } else {
                TreeNode parent = aNode.getParent();
                if (parent == null && this.root.getIndex(aNode) >= 0) {
                    retNodes = new TreeNode[depth + 1];
                    retNodes[0] = this.root;
                } else {
                    retNodes = this.getPathToRoot(parent, depth);
                }
            }
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    void updateContentExplorerNodes(List<MutableTreeNode> newContentExplorerNodes) {
        int i;
        Object[] children2 = this.contentExplorerNodes.toArray();
        int[] childIndices = new int[children2.length];
        for (i = 0; i < children2.length; ++i) {
            childIndices[i] = i;
        }
        this.contentExplorerNodes.clear();
        this.nodesWereRemoved(this.rootPath, childIndices, children2);
        this.contentExplorerNodes.addAll(newContentExplorerNodes);
        childIndices = new int[this.contentExplorerNodes.size()];
        for (i = 0; i < childIndices.length; ++i) {
            childIndices[i] = i;
        }
        this.nodesWereInserted(this.rootPath, childIndices);
    }

    static boolean isShownAlphabetically() {
        return howToShow == 1;
    }

    static void showAlphabeticallyAction() {
        howToShow = 1;
        WindowFrame.wantToRedoLibraryTree();
    }

    static boolean isShownByGroup() {
        return howToShow == 2;
    }

    static void showByGroupAction() {
        howToShow = 2;
        WindowFrame.wantToRedoLibraryTree();
    }

    static boolean isShownByHierarchy() {
        return howToShow == 3;
    }

    static void showByHierarchyAction() {
        howToShow = 3;
        WindowFrame.wantToRedoLibraryTree();
    }

    static boolean getSortLexically() {
        return User.prefSortLexically.getBoolean();
    }

    static void setSortLexically(ActionEvent e) {
        JCheckBoxMenuItem sl = (JCheckBoxMenuItem)e.getSource();
        User.prefSortLexically.setBoolean(!sl.isSelected());
        WindowFrame.wantToRedoLibraryTree();
    }

    public static DefaultMutableTreeNode makeLibraryTree() {
        DefaultMutableTreeNode libraryExplorerTree = new DefaultMutableTreeNode(libraryNode);
        switch (howToShow) {
            case 1: {
                ExplorerTreeModel.rebuildExplorerTreeByName(libraryExplorerTree);
                break;
            }
            case 2: {
                ExplorerTreeModel.rebuildExplorerTreeByGroups(libraryExplorerTree);
                break;
            }
            case 3: {
                ExplorerTreeModel.rebuildExplorerTreeByHierarchy(libraryExplorerTree);
            }
        }
        return libraryExplorerTree;
    }

    private static synchronized void rebuildExplorerTreeByName(DefaultMutableTreeNode libraryExplorerTree) {
        for (Library lib : Library.getVisibleLibraries()) {
            DefaultMutableTreeNode libTree;
            if (!ExplorerTreeModel.addTechnologyLibraryToTree(lib, libTree = new DefaultMutableTreeNode(lib))) {
                ArrayList<Cell> cellList = new ArrayList<Cell>();
                Iterator<Cell> eit = lib.getCells();
                while (eit.hasNext()) {
                    cellList.add(eit.next());
                }
                if (User.prefSortLexically.getBoolean()) {
                    Collections.sort(cellList, new TextUtils.CellsByName());
                }
                for (Cell cell : cellList) {
                    DefaultMutableTreeNode cellTree = new DefaultMutableTreeNode(cell);
                    libTree.add(cellTree);
                }
            }
            libraryExplorerTree.add(libTree);
        }
    }

    private static boolean addTechnologyLibraryToTree(Library lib, DefaultMutableTreeNode libTree) {
        boolean techLib = false;
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            if (!cell.isInTechnologyLibrary()) continue;
            techLib = true;
            break;
        }
        if (!techLib) {
            return false;
        }
        DefaultMutableTreeNode layerTree = new DefaultMutableTreeNode("TECHNOLOGY LAYERS");
        DefaultMutableTreeNode arcTree = new DefaultMutableTreeNode("TECHNOLOGY ARCS");
        DefaultMutableTreeNode nodeTree = new DefaultMutableTreeNode("TECHNOLOGY NODES");
        DefaultMutableTreeNode miscTree = new DefaultMutableTreeNode("TECHNOLOGY SUPPORT");
        libTree.add(layerTree);
        libTree.add(arcTree);
        libTree.add(nodeTree);
        libTree.add(miscTree);
        HashSet<Cell> allCells = new HashSet<Cell>();
        Cell[] layerCells = LayerInfo.getLayerCells(lib);
        for (int i = 0; i < layerCells.length; ++i) {
            allCells.add(layerCells[i]);
            layerTree.add(new DefaultMutableTreeNode(layerCells[i]));
        }
        Cell[] arcCells = ArcInfo.getArcCells(lib);
        for (int i = 0; i < arcCells.length; ++i) {
            allCells.add(arcCells[i]);
            arcTree.add(new DefaultMutableTreeNode(arcCells[i]));
        }
        Cell[] nodeCells = NodeInfo.getNodeCells(lib);
        for (int i = 0; i < nodeCells.length; ++i) {
            allCells.add(nodeCells[i]);
            nodeTree.add(new DefaultMutableTreeNode(nodeCells[i]));
        }
        Iterator<Cell> it2 = lib.getCells();
        while (it2.hasNext()) {
            Cell cell = it2.next();
            if (allCells.contains(cell)) continue;
            miscTree.add(new DefaultMutableTreeNode(cell));
        }
        return true;
    }

    private static synchronized void rebuildExplorerTreeByHierarchy(DefaultMutableTreeNode libraryExplorerTree) {
        for (Library lib : Library.getVisibleLibraries()) {
            DefaultMutableTreeNode libTree;
            if (!ExplorerTreeModel.addTechnologyLibraryToTree(lib, libTree = new DefaultMutableTreeNode(lib))) {
                ArrayList<Cell> cellList = new ArrayList<Cell>();
                Iterator<Cell> eit = lib.getCells();
                while (eit.hasNext()) {
                    cellList.add(eit.next());
                }
                if (User.prefSortLexically.getBoolean()) {
                    Collections.sort(cellList, new TextUtils.CellsByName());
                }
                for (Cell cell : cellList) {
                    if (cell.isIcon() || cell.getView().isTextView()) continue;
                    HashSet<Cell> addedCells = new HashSet<Cell>();
                    Iterator<Cell> vIt = cell.getVersions();
                    while (vIt.hasNext()) {
                        Cell cellVersion = vIt.next();
                        Iterator<NodeInst> insts = cellVersion.getInstancesOf();
                        if (insts.hasNext() || addedCells.contains(cellVersion)) continue;
                        DefaultMutableTreeNode cellTree = new DefaultMutableTreeNode(cellVersion);
                        libTree.add(cellTree);
                        addedCells.add(cellVersion);
                        ExplorerTreeModel.createHierarchicalExplorerTree(cellVersion, cellTree);
                    }
                }
            }
            libraryExplorerTree.add(libTree);
        }
    }

    private static void createHierarchicalExplorerTree(Cell cell, DefaultMutableTreeNode cellTree) {
        MutableInteger mi;
        HashMap<Cell, MutableInteger> cellCount = new HashMap<Cell, MutableInteger>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            Cell subCell;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || (subCell = (Cell)ni.getProto()).isIcon() && (ni.isIconOfParent() || (subCell = subCell.contentsView()) == null)) continue;
            mi = (MutableInteger)cellCount.get(subCell);
            if (mi == null) {
                mi = new MutableInteger(0);
                cellCount.put(subCell, mi);
            }
            mi.setValue(mi.intValue() + 1);
        }
        ArrayList<Cell> sortedSubCells = new ArrayList<Cell>();
        for (Cell subCell : cellCount.keySet()) {
            sortedSubCells.add(subCell);
        }
        Collections.sort(sortedSubCells, new TextUtils.CellsByName());
        for (Cell subCell : sortedSubCells) {
            mi = (MutableInteger)cellCount.get(subCell);
            if (mi == null) continue;
            CellAndCount cc = new CellAndCount(subCell, mi.intValue());
            DefaultMutableTreeNode subCellTree = new DefaultMutableTreeNode(cc);
            cellTree.add(subCellTree);
            ExplorerTreeModel.createHierarchicalExplorerTree(subCell, subCellTree);
        }
    }

    private static synchronized void rebuildExplorerTreeByGroups(DefaultMutableTreeNode libraryExplorerTree) {
        HashSet<Cell> cellsSeen = new HashSet<Cell>();
        for (Library lib : Library.getVisibleLibraries()) {
            DefaultMutableTreeNode libTree;
            if (!ExplorerTreeModel.addTechnologyLibraryToTree(lib, libTree = new DefaultMutableTreeNode(lib))) {
                Iterator<Cell> eit = lib.getCells();
                while (eit.hasNext()) {
                    Cell cell = eit.next();
                    cellsSeen.remove(cell);
                }
                ArrayList<Cell> cellList = new ArrayList<Cell>();
                Iterator<Cell> eit2 = lib.getCells();
                while (eit2.hasNext()) {
                    cellList.add(eit2.next());
                }
                if (User.prefSortLexically.getBoolean()) {
                    Collections.sort(cellList, new TextUtils.CellsByName());
                }
                for (Cell cell : cellList) {
                    if (cell.getNewestVersion() != cell) continue;
                    int numNewCells = 0;
                    Cell.CellGroup group = cell.getCellGroup();
                    if (group == null) continue;
                    Iterator<Cell> gIt = group.getCells();
                    while (gIt.hasNext()) {
                        Cell cellInGroup = gIt.next();
                        if (cellInGroup.getNewestVersion() != cellInGroup) continue;
                        ++numNewCells;
                    }
                    if (numNewCells == 1) {
                        ExplorerTreeModel.addCellAndAllVersions(cell, libTree);
                        continue;
                    }
                    List<Cell> cellsInGroup = group.getCellsSortedByView();
                    DefaultMutableTreeNode groupTree = null;
                    for (Cell cellInGroup : cellsInGroup) {
                        if (cellInGroup.getNumVersions() > 1 && cellInGroup.getNewestVersion() != cellInGroup || cellsSeen.contains(cellInGroup)) continue;
                        if (groupTree == null) {
                            groupTree = new DefaultMutableTreeNode(group);
                        }
                        cellsSeen.add(cellInGroup);
                        ExplorerTreeModel.addCellAndAllVersions(cellInGroup, groupTree);
                    }
                    if (groupTree == null) continue;
                    libTree.add(groupTree);
                }
            }
            libraryExplorerTree.add(libTree);
        }
    }

    private static void addCellAndAllVersions(Cell cell, DefaultMutableTreeNode libTree) {
        DefaultMutableTreeNode cellTree = new DefaultMutableTreeNode(cell);
        libTree.add(cellTree);
        if (cell.isMultiPage()) {
            int pageCount = cell.getNumMultiPages();
            for (int i = 0; i < pageCount; ++i) {
                MultiPageCell mpc = new MultiPageCell();
                mpc.cell = cell;
                mpc.pageNo = i;
                DefaultMutableTreeNode pageTree = new DefaultMutableTreeNode(mpc);
                cellTree.add(pageTree);
            }
        }
        if (cell.getNumVersions() > 1) {
            Iterator<Cell> vIt = cell.getVersions();
            while (vIt.hasNext()) {
                Cell oldVersion = vIt.next();
                if (oldVersion == cell) continue;
                DefaultMutableTreeNode oldCellTree = new DefaultMutableTreeNode(oldVersion);
                cellTree.add(oldCellTree);
                if (!oldVersion.isMultiPage()) continue;
                int pageCount = oldVersion.getNumMultiPages();
                for (int i = 0; i < pageCount; ++i) {
                    MultiPageCell mpc = new MultiPageCell();
                    mpc.cell = oldVersion;
                    mpc.pageNo = i;
                    DefaultMutableTreeNode pageTree = new DefaultMutableTreeNode(mpc);
                    oldCellTree.add(pageTree);
                }
            }
        }
    }

    static class MultiPageCell {
        private Cell cell;
        private int pageNo;

        MultiPageCell() {
        }

        Cell getCell() {
            return this.cell;
        }

        int getPageNo() {
            return this.pageNo;
        }

        public String toString() {
            return this.cell.noLibDescribe() + " Page " + (this.pageNo + 1);
        }
    }

    static class CellAndCount {
        private Cell cell;
        private int count;

        CellAndCount(Cell cell, int count2) {
            this.cell = cell;
            this.count = count2;
        }

        Cell getCell() {
            return this.cell;
        }

        int getCount() {
            return this.count;
        }

        public String toString() {
            return this.cell.noLibDescribe() + " (" + this.count + ")";
        }
    }
}

