/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.IconNodeInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Network
implements Comparable {
    private final Netlist netlist;
    private final int netIndex;

    Network(Netlist netlist, int netIndex) {
        this.netlist = netlist;
        this.netIndex = netIndex;
    }

    public Netlist getNetlist() {
        return this.netlist;
    }

    public int compareTo(Object other) {
        String s = this.toString();
        String sOther = other.toString();
        return s.compareToIgnoreCase(sOther);
    }

    public Cell getParent() {
        return this.netlist.netCell.cell;
    }

    public int getNetIndex() {
        return this.netIndex;
    }

    public Iterator<String> getNames() {
        return this.netlist.getNames(this.netIndex);
    }

    public Iterator<String> getExportedNames() {
        return this.netlist.getExportedNames(this.netIndex);
    }

    public String getName() {
        return this.netlist.getName(this.netIndex);
    }

    public boolean hasName(String nm) {
        return this.netlist.hasName(this.netIndex, nm);
    }

    public Iterator<PortInst> getPorts() {
        List<PortInst> ports = this.getPortsList();
        return ports.iterator();
    }

    public List<PortInst> getPortsList() {
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        Iterator<NodeInst> it = this.getParent().getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Iterator<PortInst> pit = ni.getPortInsts();
            block1: while (pit.hasNext()) {
                PortInst pi = pit.next();
                if (ni instanceof IconNodeInst) {
                    int numNodables = ni.getNumNodables();
                    for (int arrayIndex = 0; arrayIndex < numNodables; ++arrayIndex) {
                        Nodable no = ni.getNodable(arrayIndex);
                        Name nameKey = pi.getPortProto().getNameKey();
                        for (int i = 0; i < nameKey.busWidth(); ++i) {
                            if (this.netlist.getNetIndex(no, nameKey.subname(i)) != this.netIndex) continue;
                            ports.add(pi);
                            continue block1;
                        }
                    }
                    continue;
                }
                PortProto pp = pi.getPortProto();
                int busWidth = this.netlist.netCell.getBusWidth(ni, pp);
                for (int i = 0; i < busWidth; ++i) {
                    if (this.netlist.getNetIndex(ni, pp, i) != this.netIndex) continue;
                    ports.add(pi);
                    continue block1;
                }
            }
        }
        return ports;
    }

    public Iterator<NodeInst> getNodes() {
        ArrayList<NodeInst> nodes = new ArrayList<NodeInst>();
        Iterator<NodeInst> it = this.getParent().getNodes();
        block0: while (it.hasNext()) {
            NodeInst ni = it.next();
            Iterator<PortInst> pit = ni.getPortInsts();
            while (pit.hasNext()) {
                PortInst pi = pit.next();
                if (this.netlist.getNetIndex(ni, pi.getPortProto(), 0) != this.netIndex) continue;
                nodes.add(ni);
                continue block0;
            }
        }
        return nodes.iterator();
    }

    public Iterator<Global> getGlobals() {
        Global.Set globals = this.getNetlist().getGlobals();
        ArrayList<Global> globalsOnNet = new ArrayList<Global>();
        for (int i = 0; i < globals.size(); ++i) {
            Global g = globals.get(i);
            if (this.getNetlist().getNetIndex(g) != this.netIndex) continue;
            globalsOnNet.add(g);
        }
        return globalsOnNet.iterator();
    }

    public Iterator<Export> getExports() {
        ArrayList<Export> exports = new ArrayList<Export>();
        Iterator<Export> it = this.getParent().getExports();
        block0: while (it.hasNext()) {
            Export e = it.next();
            int busWidth = this.netlist.getBusWidth(e);
            for (int i = 0; i < busWidth; ++i) {
                if (this.netlist.getNetIndex(e, i) != this.netIndex) continue;
                exports.add(e);
                continue block0;
            }
        }
        return exports.iterator();
    }

    public Iterator<ArcInst> getArcs() {
        ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
        Iterator<ArcInst> it = this.getParent().getArcs();
        block0: while (it.hasNext()) {
            ArcInst ai = it.next();
            int busWidth = this.netlist.getBusWidth(ai);
            for (int i = 0; i < busWidth; ++i) {
                if (this.netlist.getNetIndex(ai, i) != this.netIndex) continue;
                arcs.add(ai);
                continue block0;
            }
        }
        return arcs.iterator();
    }

    public boolean isExported() {
        return this.netlist.isExported(this.netIndex);
    }

    public boolean isUsernamed() {
        return this.netlist.isUsernamed(this.netIndex);
    }

    public String describe(boolean withQuotes) {
        Iterator<String> it = this.getNames();
        String name = it.next();
        while (it.hasNext()) {
            name = name + "/" + it.next();
        }
        if (withQuotes) {
            name = "'" + name + "'";
        }
        return name;
    }

    public Export findExportWithSameCharacteristic(PortProto p) {
        Iterator<Export> itP = this.getExports();
        while (itP.hasNext()) {
            Export exp = itP.next();
            if (exp.getCharacteristic() != p.getCharacteristic()) continue;
            return exp;
        }
        return null;
    }

    public String toString() {
        return "network " + this.describe(true);
    }
}

