/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import java.util.Map;

public class Dummy
extends Technology {
    private static final double BASESIZE = 10.0;
    private static final long BASELINE_FIXP = 0xFA000000L;
    private final Layer lMetal1 = this.findLayer("Metal-1");
    private final ArcProto m1 = this.findArcProto("Metal-1");
    private final ArcProto[] portArcs = new ArcProto[]{this.m1};

    public Dummy(Generic generic, TechFactory techFactory, Map<TechFactory.Param, Object> techParams, Xml.Technology t) {
        super(generic, techFactory, techParams, t);
        this.makeBigBlueBox();
    }

    private void makeBigBlueBox() {
        ERectangle baseRectangle;
        ERectangle fullRectangle = baseRectangle = ERectangle.fromLambda(-5.0, -5.0, 10.0, 10.0);
        Technology.NodeLayer[] nodeLayers = new Technology.NodeLayer[]{new Technology.NodeLayer(this.lMetal1, 0, Poly.Type.FILLED, 1, new Technology.TechPoint[0])};
        BigBlueNode pnp = new BigBlueNode(fullRectangle, baseRectangle, nodeLayers);
    }

    private class BluePort
    extends PrimitivePort {
        private double xm;
        private double ym;

        BluePort(BigBlueNode parent, String portName, int portAngle, double xm, double ym) {
            super(parent, Dummy.this.portArcs, portName, false, portAngle, 45, 0, PortCharacteristic.UNKNOWN, false, false, new EdgeH(xm, 5.0 * Math.min(xm, 0.5 * xm)), new EdgeV(ym, 5.0 * Math.min(ym, 0.5 * ym)), new EdgeH(xm, 5.0 * Math.max(xm, 0.5 * xm)), new EdgeV(ym, 5.0 * Math.max(ym, 0.5 * ym)));
            this.xm = xm;
            this.ym = ym;
        }

        @Override
        public void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
            assert (n.protoId == this.getParent().getId());
            long width = n.size.getFixpX() + 0xFA000000L;
            long height = n.size.getFixpY() + 0xFA000000L;
            long x2 = (long)Math.rint(this.xm * 0.5 * (double)width);
            long y = (long)Math.rint(this.ym * 0.5 * (double)height);
            b.setCurNode(n);
            b.pushPoint(x2, y);
            b.pushPoint(x2 >> 1, y);
            b.pushPoint(x2, y >> 1);
            b.pushPoly(Poly.Type.FILLED, null, null, null);
        }
    }

    private class BigBlueNode
    extends PrimitiveNode {
        BigBlueNode(ERectangle fullRectangle, ERectangle baseRectangle, Technology.NodeLayer[] layers) {
            super("BigBlueNode", Dummy.this, EPoint.ORIGIN, EPoint.ORIGIN, null, 10.0, 10.0, fullRectangle, baseRectangle, layers);
            this.addPrimitivePorts(new BluePort(this, "p-1", 0, 1.0, 1.0), new BluePort(this, "p-2", 180, -1.0, 1.0), new BluePort(this, "p-3", 0, 1.0, -1.0), new BluePort(this, "p-4", 180, -1.0, -1.0));
            this.check();
        }

        @Override
        public void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
            assert (n.protoId == this.getId());
            long width = n.size.getFixpX() + 0xFA000000L;
            long height = n.size.getFixpY() + 0xFA000000L;
            b.setCurNode(n);
            b.pushPoint(-width / 2L, -height / 2L);
            b.pushPoint(-width / 2L, height / 2L);
            b.pushPoint(width / 2L, height / 2L);
            b.pushPoint(width / 2L, -height / 2L);
            b.pushPoly(Poly.Type.FILLED, Dummy.this.lMetal1, null, null);
        }
    }
}

