/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LibData {
    public Group library;
    private static final int MAX_LINE_LENGTH = 80;

    public void write(String filename) {
        try {
            this.write(new PrintStream(new FileOutputStream(filename)));
        }
        catch (FileNotFoundException e) {
            System.out.println("LibData: Error writing to file " + filename + ": " + e.getMessage());
        }
    }

    public void write(PrintStream out) {
        if (this.library == null) {
            System.out.println("LibData: No Data to write");
            return;
        }
        this.library.write(out, 0);
    }

    public Group getLibrary() {
        return this.library;
    }

    public void setLibrary(Group group) {
        this.library = group;
    }

    public static String getMessage(Error error) {
        switch (error) {
            case NO_ERROR: {
                return "";
            }
            case INTERNAL_SYSTEM_ERROR: {
                return "Internal System Error";
            }
            case INVALID_VALUE: {
                return "Invalid Value";
            }
            case INVALID_NAME: {
                return "Invalid Name";
            }
            case INVALID_OBJECTTYPE: {
                return "Invalid Object Type";
            }
            case INVALID_ATTRTYPE: {
                return "Invalid Attribute Type";
            }
            case UNUSABLE_OID: {
                return "Unusable Object Identifier?";
            }
            case OBJECT_ALREADY_EXISTS: {
                return "Object Already Exists";
            }
            case OBJECT_NOT_FOUND: {
                return "Object Not Found";
            }
            case SYNTAX_ERROR: {
                return "Syntax Error";
            }
            case TRACE_FILES_CANNOT_BE_OPENED: {
                return "Trace Files Cannot be Opened";
            }
            case PIINIT_NOT_CALLED: {
                return "PI init() not called";
            }
            case SEMANTIC_ERROR: {
                return "Semantic Error";
            }
            case REFERENCE_ERROR: {
                return "Reference Error";
            }
            case MAX_ERROR: {
                return "Maximum Error";
            }
        }
        return "Unknown Error Number: " + (Object)((Object)error);
    }

    private static void prtabs(PrintStream out, int tabs) {
        for (int i = 0; i < tabs; ++i) {
            out.print("  ");
        }
    }

    public static enum Error {
        NO_ERROR,
        INTERNAL_SYSTEM_ERROR,
        INVALID_VALUE,
        INVALID_NAME,
        INVALID_OBJECTTYPE,
        INVALID_ATTRTYPE,
        UNUSABLE_OID,
        OBJECT_ALREADY_EXISTS,
        OBJECT_NOT_FOUND,
        SYNTAX_ERROR,
        TRACE_FILES_CANNOT_BE_OPENED,
        PIINIT_NOT_CALLED,
        SEMANTIC_ERROR,
        REFERENCE_ERROR,
        MAX_ERROR;

    }

    public static class Define {
        String name;
        String groupType;
        ValueType valueType;
        String comment;
        Group owner;

        Define(String name, Group owner, ValueType valueType) {
            this.name = name;
            this.owner = owner;
            this.valueType = valueType;
            if (owner != null) {
                owner.putDefine(this);
            }
        }

        private void write(PrintStream out, int tabs) {
        }
    }

    public static class Value {
        ValueType type;
        Object value;

        public Value(ValueType type, Object value2) {
            String s;
            this.type = type;
            this.value = value2;
            if (value2 instanceof String && (s = (String)value2).startsWith("\"") && s.endsWith("\"")) {
                s = s.substring(1, s.length() - 1);
                this.value = s;
            }
        }

        public ValueType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public static ValueType getType(String s) {
            if (s == null) {
                return ValueType.UNDEFINED;
            }
            try {
                return ValueType.valueOf(s.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return ValueType.UNDEFINED;
            }
        }

        public Integer getInt() {
            if (this.value == null || this.type != ValueType.DOUBLE) {
                return null;
            }
            return new Integer(((Double)this.value).intValue());
        }

        public Double getDouble() {
            if (this.value == null || this.type != ValueType.DOUBLE) {
                return null;
            }
            return (Double)this.value;
        }

        public String getString() {
            if (this.value == null || this.type != ValueType.STRING) {
                return null;
            }
            return (String)this.value;
        }

        public Boolean getBoolean() {
            if (this.value == null || this.type != ValueType.BOOLEAN) {
                return null;
            }
            return (Boolean)this.value;
        }

        private String getValueAsString() {
            String s = this.value.toString().trim();
            if (!(s.indexOf(32) == -1 && s.indexOf(47) == -1 && s.indexOf(92) == -1 && s.indexOf("(") == -1 || s.startsWith("\"") || s.endsWith("\""))) {
                return "\"" + s + "\"";
            }
            return s;
        }
    }

    public static enum ValueType {
        STRING,
        DOUBLE,
        BOOLEAN,
        INT,
        EXPR,
        UNDEFINED;

    }

    public static class Attribute {
        AttrType type;
        String name;
        List<Value> values;

        public Attribute(String name, Value value2) {
            this.name = name;
            this.type = AttrType.SIMPLE;
            this.values = new ArrayList<Value>();
            this.values.add(value2);
        }

        public Attribute(String name, Head complexAttributeValues) {
            this.name = name;
            this.type = AttrType.COMPLEX;
            this.values = complexAttributeValues.getValues();
        }

        public AttrType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public List<Value> getValues() {
            return this.values;
        }

        public Integer getInt() {
            if (this.values.size() == 0) {
                return null;
            }
            return this.values.get(0).getInt();
        }

        public Double getDouble() {
            if (this.values.size() == 0) {
                return null;
            }
            return this.values.get(0).getDouble();
        }

        public String getString() {
            if (this.values.size() == 0) {
                return null;
            }
            return this.values.get(0).getString();
        }

        public Boolean getBoolean() {
            if (this.values.size() == 0) {
                return null;
            }
            return this.values.get(0).getBoolean();
        }

        private void write(PrintStream out, int tabs) {
            LibData.prtabs(out, tabs);
            out.print(this.name);
            int i = tabs * 2 + this.name.length();
            switch (this.type) {
                case SIMPLE: {
                    out.print(" : ");
                    i += 3;
                    break;
                }
                case COMPLEX: {
                    out.print(" (");
                    i += 2;
                }
            }
            int start = i;
            Iterator<Value> it = this.values.iterator();
            while (it.hasNext()) {
                Value v = it.next();
                String s = v.getValueAsString();
                if (i + s.length() > 80) {
                    out.println(" \\");
                    i = start;
                    LibData.prtabs(out, start / 2);
                }
                out.print(s);
                i += s.length();
                if (!it.hasNext()) continue;
                out.print(", ");
                i += 2;
            }
            if (this.type == AttrType.COMPLEX) {
                out.print(")");
            }
            out.println(" ;");
        }
    }

    public static enum AttrType {
        SIMPLE,
        COMPLEX;

    }

    public static class Group {
        private String type;
        private List<String> names;
        private Group owner;
        Map<String, Attribute> attrList;
        Map<String, Define> defineList;
        List<Group> groupList;

        public Group(String type, String name, Group owner) {
            this.type = type;
            this.names = new ArrayList<String>();
            if (name != null) {
                this.names.add(name);
            }
            this.owner = owner;
            this.attrList = new LinkedHashMap<String, Attribute>();
            this.defineList = new LinkedHashMap<String, Define>();
            this.groupList = new ArrayList<Group>();
            if (owner != null) {
                owner.putGroup(this);
            }
        }

        public Group(Head h, Group owner) {
            this.type = h.name;
            this.names = new ArrayList<String>();
            this.owner = owner;
            this.attrList = new LinkedHashMap<String, Attribute>();
            this.defineList = new LinkedHashMap<String, Define>();
            this.groupList = new ArrayList<Group>();
            for (Value a : h.getValues()) {
                this.names.add(a.value.toString());
            }
            if (owner != null) {
                owner.putGroup(this);
            }
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            if (this.names.size() > 0) {
                return this.names.get(0);
            }
            return null;
        }

        public List<String> getNames() {
            return this.names;
        }

        public Group getOwner() {
            return this.owner;
        }

        public String getHName() {
            String parentName = this.owner == null ? "" : this.owner.getHName() + ".";
            String thisname = this.type + (this.names.size() == 0 ? "" : "-" + this.names.get(0));
            return parentName + thisname;
        }

        public void putAttribute(Attribute a) {
            if (this.attrList.containsKey(a.name)) {
                System.out.println("Duplicate Attribute name " + a.name + " in group " + this.getHName());
            }
            this.attrList.put(a.name, a);
        }

        public void putGroup(Group g) {
            this.groupList.add(g);
        }

        public void putDefine(Define d) {
            if (this.defineList.containsKey(d.name)) {
                System.out.println("Duplicate Define name " + d.name + " in group " + this.getHName());
            }
            this.defineList.put(d.name, d);
        }

        public Attribute getAttribute(String name) {
            return this.attrList.get(name);
        }

        public void putAttribute(String name, double value2) {
            Value val = new Value(ValueType.DOUBLE, new Double(value2));
            this.putAttribute(new Attribute(name, val));
        }

        public void putAttribute(String name, String value2) {
            Value val = new Value(ValueType.STRING, value2);
            this.putAttribute(new Attribute(name, val));
        }

        public void putAttribute(String name, int value2) {
            Value val = new Value(ValueType.INT, new Integer(value2));
            this.putAttribute(new Attribute(name, val));
        }

        public void putAttribute(String name, List<String> values2) {
            ArrayList<Value> vals = new ArrayList<Value>();
            for (String s : values2) {
                vals.add(new Value(ValueType.STRING, s));
            }
            Head h = new Head(name, vals);
            this.putAttribute(new Attribute(name, h));
        }

        public void putAttributeComplex(String name, String value2) {
            ArrayList<String> vals = new ArrayList<String>();
            vals.add(value2);
            this.putAttribute(name, vals);
        }

        public List<Group> getGroups() {
            return this.groupList;
        }

        public List<Group> getGroups(String type, String name) {
            ArrayList<Group> groups = new ArrayList<Group>();
            if (type == null) {
                return groups;
            }
            for (Group g : this.groupList) {
                if (!type.equals(g.type)) continue;
                if (name == null && g.names.size() == 0) {
                    groups.add(g);
                    continue;
                }
                if (name == null || !g.names.contains(name)) continue;
                groups.add(g);
            }
            return groups;
        }

        public Define getDefine(String name) {
            return this.defineList.get(name);
        }

        public void removeGroup(Group group) {
            for (Group g : this.groupList) {
                if (g != group) continue;
                this.groupList.remove(g);
                return;
            }
        }

        private void write(PrintStream out, int tabs) {
            LibData.prtabs(out, tabs);
            out.print(this.type + " (");
            Iterator<String> it = this.names.iterator();
            while (it.hasNext()) {
                out.print(it.next());
                if (!it.hasNext()) continue;
                out.print(", ");
            }
            out.println(") {");
            ++tabs;
            for (Attribute attr : this.attrList.values()) {
                attr.write(out, tabs);
            }
            for (Define define : this.defineList.values()) {
                define.write(out, tabs);
            }
            for (Group group : this.groupList) {
                group.write(out, tabs);
            }
            LibData.prtabs(out, --tabs);
            out.println("}");
        }
    }

    public static class Head {
        public String name;
        int lineno;
        String filename;
        List<Value> valuesList;

        public Head(String name, List attrList) {
            this.name = name;
            this.valuesList = new ArrayList<Value>();
            for (Object obj : attrList) {
                if (!(obj instanceof Value)) continue;
                this.valuesList.add((Value)obj);
            }
        }

        public List<Value> getValues() {
            return this.valuesList;
        }
    }
}

