/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.LogicSettableArray;
import com.sun.electric.tool.simulation.test.Netscan4JNI;
import com.sun.electric.tool.simulation.test.NetscanGeneric;
import com.sun.electric.tool.simulation.test.NetscanJNI;

public class Netscan
extends NetscanGeneric {
    public static final short DEFAULT_STOP_STATE = 1;
    public static final int NUM_OUTPUT_PINS = 2;

    public Netscan(String addressIP) {
        Netscan.incrementNumTesters();
        Netscan.logInit("Connecting to Netscan at " + addressIP);
        int status = NetscanJNI.net_connect(addressIP);
        if (status <= 0) {
            Infrastructure.fatal("NetscanJNI.net_connect(" + addressIP + ") returned error code " + status);
        }
        this.logicOutput = new LogicSettableArray(2);
        this.setParallelIO(this.logicOutput.getLogicStates());
    }

    @Override
    void configure(float tapVolt, long kiloHerz) {
        int milliVolt = Math.round(tapVolt * 1000.0f);
        this.logSet("Netscan configuring " + kiloHerz + " kHz and " + milliVolt + " mV");
        int status = NetscanJNI.net_configure(kiloHerz, (short)1, milliVolt);
        if (status != 0) {
            Infrastructure.fatal("NetscanJNI.net_configure returned error code " + status);
        }
        this.reset();
    }

    @Override
    public void reset() {
        int status = NetscanJNI.net_set_trst(0);
        if (status != 0) {
            Infrastructure.fatal("NetscanJNI.net_set_trst(0) returned error code " + status);
        }
        if ((status = NetscanJNI.net_set_trst(1)) != 0) {
            Infrastructure.fatal("NetscanJNI.net_set_trst(1) returned error code " + status);
        }
    }

    @Override
    public void tms_reset() {
        int status = Netscan4JNI.netUSB_tms_reset(1);
        if (status != 0) {
            Infrastructure.fatal("Netscan4JNI.net_tms_reset(1) returned error code " + status);
        }
    }

    @Override
    void disconnect() {
        int status = NetscanJNI.net_disconnect();
        if (status != 0) {
            Infrastructure.fatal("NetscanJNI.net_disconnect() returned error code " + status);
        }
    }

    private void setParallelIO(boolean[] newLevel) {
        int returnValue;
        if (newLevel.length != 2) {
            Infrastructure.fatal("newLevel.length=" + newLevel.length + ", expected " + 2);
        }
        short port_data = 0;
        if (newLevel[0]) {
            port_data = (short)(port_data + 1);
        }
        if (newLevel[1]) {
            port_data = (short)(port_data + 2);
        }
        if ((returnValue = NetscanJNI.net_set_parallel_io(port_data)) != 0) {
            Infrastructure.fatal("net_set_parallel_io returned error code " + returnValue);
        }
    }

    @Override
    void setLogicOutput(int index, boolean newLevel) {
        this.logicOutput.setLogicState(index, newLevel);
        this.setParallelIO(this.logicOutput.getLogicStates());
    }

    @Override
    protected int hw_net_scan_ir(int numBits, short[] scanIn, short[] scanOut, int drBits) {
        this.logOther("IR in:  # shorts=" + scanIn.length + ", " + Netscan.shortsToString(scanIn));
        int result2 = NetscanJNI.net_scan_ir(scanIn, numBits, scanOut);
        this.logOther("IR out: # shorts=" + scanOut.length + ", " + Netscan.shortsToString(scanOut));
        return result2;
    }

    @Override
    protected int hw_net_scan_dr(int numBits, short[] scanIn, short[] scanOut) {
        this.logOther("DR in:  # shorts=" + scanIn.length + ", " + Netscan.shortsToString(scanIn));
        this.logOther("   chain length=" + numBits);
        int result2 = NetscanJNI.net_scan_dr(scanIn, numBits, scanOut);
        this.logOther("DR out: # shorts=" + scanOut.length + ", " + Netscan.shortsToString(scanOut));
        return result2;
    }
}

