/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.geometry;

import com.sun.electric.api.minarea.ManhattanOrientation;
import java.io.Serializable;

public class Point
implements Serializable {
    protected final int xCoord;
    protected final int yCoord;

    public Point(int x, int y) {
        if (x < -1073741823 || x > 0x3FFFFFFF) {
            throw new IllegalArgumentException("x has to be in range [-LayoutCell.MAX_COORD, LayoutCell.MAX_COORD]");
        }
        if (y < -1073741823 || y > 0x3FFFFFFF) {
            throw new IllegalArgumentException("y has to be in range [-LayoutCell.MAX_COORD, LayoutCell.MAX_COORD]");
        }
        this.xCoord = x;
        this.yCoord = y;
    }

    public int getX() {
        return this.xCoord;
    }

    public Point withX(int xCoord) {
        return new Point(xCoord, this.yCoord);
    }

    public int getY() {
        return this.yCoord;
    }

    public Point withY(int yCoord) {
        return new Point(this.xCoord, yCoord);
    }

    public int[] toArray() {
        return new int[]{this.xCoord, this.yCoord};
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Point = (");
        builder.append(this.xCoord);
        builder.append(", ");
        builder.append(this.yCoord);
        builder.append(")");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.xCoord;
        result = 31 * result + this.yCoord;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (this.xCoord != other.xCoord) {
            return false;
        }
        return this.yCoord == other.yCoord;
    }

    public Point add(Point other) {
        return new Point(this.xCoord + other.xCoord, this.yCoord + other.yCoord);
    }

    public Point scale(int scaleFactor) {
        return this.scale(scaleFactor, scaleFactor);
    }

    public Point scale(int scaleFactorX, int scaleFactorY) {
        return new Point(this.xCoord * scaleFactorX, this.yCoord * scaleFactorY);
    }

    public Point mirror() {
        return new Point(this.yCoord, this.xCoord);
    }

    public Point transform(ManhattanOrientation orientation) {
        switch (orientation) {
            case R0: {
                return this;
            }
            case R90: {
                return new Point(-this.getY(), this.getX());
            }
            case R180: {
                return new Point(-this.getX(), -this.getY());
            }
            case R270: {
                return new Point(this.getY(), -this.getX());
            }
            case MY: {
                return new Point(-this.getX(), this.getY());
            }
            case MYR90: {
                return new Point(-this.getY(), -this.getX());
            }
            case MX: {
                return new Point(this.getX(), -this.getY());
            }
            case MXR90: {
                return new Point(this.getY(), this.getX());
            }
        }
        throw new AssertionError();
    }

    public static final class Vector
    extends Point {
        public Vector(int x, int y) {
            super(x, y);
        }

        public Vector(Point head, Point tail) {
            super(head.xCoord - tail.xCoord, head.yCoord - tail.yCoord);
        }

        public long determinant(Vector other) {
            return (long)this.xCoord * (long)other.yCoord - (long)this.yCoord * (long)other.xCoord;
        }
    }

    public static final class NullPoint
    extends Point {
        public NullPoint() {
            super(0, 0);
        }
    }
}

