/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.IconNodeInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DualEval
extends Output {
    private final List<Cell> downTop = new ArrayList<Cell>();
    private final Map<String, PrimitiveTemplate> primNames = new HashMap<String, PrimitiveTemplate>();

    DualEval(DualEvalPreferences dp) {
        this.initPrims();
    }

    private void writeDualEval(Cell cell) {
        this.enumDownTop(cell, new HashSet<Cell>());
        this.printWriter.println("(in-package \"ADE\")");
        this.printWriter.println("(include-book \"network-prelude\")");
        String prevName = "network-prelude";
        this.printWriter.println("#|");
        for (Cell c : this.downTop) {
            String name = c.getName();
            ArrayList<IconNodeInst> nodes = new ArrayList<IconNodeInst>();
            Iterator<NodeInst> it = c.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!(ni instanceof IconNodeInst) || ni.isIconOfParent()) continue;
                nodes.add((IconNodeInst)ni);
            }
            int numGo = this.calcNumGo(nodes);
            Map<IconNodeInst, Set<IconNodeInst>> graph = this.makeDepGraph(nodes);
            Collection<IconNodeInst> sortedNodes = this.toposort(nodes, graph);
            this.printWriter.println();
            this.writeDefconst(c, sortedNodes, numGo, prevName);
            prevName = name;
        }
        this.printWriter.println("|#");
        for (Cell c : this.downTop) {
            c.getName();
            ArrayList<IconNodeInst> nodes = new ArrayList<IconNodeInst>();
            Iterator<NodeInst> it = c.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!(ni instanceof IconNodeInst) || ni.isIconOfParent()) continue;
                nodes.add((IconNodeInst)ni);
            }
            int numGo = this.calcNumGo(nodes);
            Map<IconNodeInst, Set<IconNodeInst>> graph = this.makeDepGraph(nodes);
            Collection<IconNodeInst> sortedNodes = this.toposort(nodes, graph);
            this.printWriter.println();
            this.writeModuleGenerator(c, sortedNodes, numGo);
        }
        this.printWriter.println();
        this.printWriter.println("(defn " + cell.getName() + "$netlist ()");
        this.printWriter.println("  (list*");
        for (int i = this.downTop.size() - 1; i >= 0; --i) {
            this.printWriter.println("    (" + this.downTop.get(i).getName() + "*)");
        }
        this.printWriter.println("    *network-prelude*))");
    }

    private void writeDefconst(Cell c, Collection<IconNodeInst> sortedNodes, int numGo, String prevName) {
        String name = c.getName();
        this.printWriter.println("(defconst *" + name + "*");
        this.printWriter.println("  (cons");
        this.printWriter.println("     `(" + name);
        this.writeExports(c, PortCharacteristic.IN, numGo);
        this.writeExports(c, PortCharacteristic.OUT, 0);
        this.writeStates("       (", sortedNodes);
        this.printWriter.println("       ()");
        this.writeNodes(sortedNodes);
        this.printWriter.println("       )");
        this.printWriter.println("     " + (String)(prevName != null ? "*" + prevName + "*" : "nil") + "))");
    }

    private void writeModuleGenerator(Cell c, Collection<IconNodeInst> sortedNodes, int numGo) {
        String name = c.getName();
        this.printWriter.println("(module-generator");
        this.printWriter.println("  " + name + "* ()");
        this.printWriter.println("  '" + name);
        this.writeExportsGenerator(c, PortCharacteristic.IN, numGo);
        this.writeExportsGenerator(c, PortCharacteristic.OUT, 0);
        this.writeStates("  '(", sortedNodes);
        this.writeNodesGenerator(sortedNodes);
        this.printWriter.println("  :guard t)");
    }

    private int calcNumGo(Collection<IconNodeInst> nodes) {
        int numGo = 0;
        for (IconNodeInst ni : nodes) {
            PrimitiveTemplate pt = this.primNames.get(ni.getProto().getName());
            if (pt == null) continue;
            numGo += pt.numGo;
        }
        return numGo;
    }

    private void writeExports(Cell cell, PortCharacteristic pc, int numGo) {
        boolean first = true;
        Iterator<Export> it = cell.getExports();
        while (it.hasNext()) {
            Export export = it.next();
            if (export.getCharacteristic() != pc) continue;
            if (first) {
                this.printWriter.print("       `(");
                first = false;
            } else {
                this.printWriter.print(" ");
            }
            this.printWriter.print(export.getName());
        }
        if (numGo == 0) {
            if (first) {
                this.printWriter.println("       ()");
            } else {
                this.printWriter.println(")");
            }
        } else if (first) {
            this.printWriter.println("       ,(sis 'go 0 " + numGo + ")");
        } else {
            this.printWriter.println(" . ,(sis 'go 0 " + numGo + "))");
        }
    }

    private void writeExportsGenerator(Cell cell, PortCharacteristic pc, int numGo) {
        if (numGo == 0) {
            this.printWriter.print("  (list");
        } else {
            this.printWriter.print("  (list*");
        }
        Iterator<Export> it = cell.getExports();
        while (it.hasNext()) {
            Export export = it.next();
            if (export.getCharacteristic() != pc) continue;
            this.printWriter.print(" '" + export.getName());
        }
        if (numGo == 0) {
            this.printWriter.println(")");
        } else {
            this.printWriter.println(" (sis 'go 0 " + numGo + "))");
        }
    }

    private void writeStates(String prefix, Collection<IconNodeInst> nodes) {
        this.printWriter.print(prefix);
        boolean first = true;
        for (IconNodeInst ni : nodes) {
            PrimitiveTemplate pt = this.primNames.get(ni.getProto().getName());
            if (pt == null || !pt.hasState) continue;
            if (first) {
                first = false;
            } else {
                this.printWriter.print(" ");
            }
            this.printWriter.print(ni.getName());
        }
        this.printWriter.println(")");
    }

    private Map<IconNodeInst, Set<IconNodeInst>> makeDepGraph(List<IconNodeInst> nodes) {
        LinkedHashMap<IconNodeInst, Set<IconNodeInst>> graph = new LinkedHashMap<IconNodeInst, Set<IconNodeInst>>();
        for (IconNodeInst ni : nodes) {
            Netlist netlist = ni.getParent().getNetlist();
            Cell proto = ni.getProto();
            Iterator<Export> it = proto.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                if (e.getCharacteristic() != PortCharacteristic.OUT) continue;
                PortInst pi = ni.findPortInstFromProto(e);
                Network net = netlist.getNetwork(pi);
                for (PortInst pi2 : net.getPortsList()) {
                    LinkedHashSet<IconNodeInst> dep;
                    PrimitiveTemplate pt;
                    IconNodeInst ni2;
                    if (pi.equals(pi2) || !(pi2.getNodeInst() instanceof IconNodeInst) || (ni2 = (IconNodeInst)pi2.getNodeInst()).equals(ni) || (pt = this.primNames.get(ni2.getProto().getName())) != null && !pt.propagates) continue;
                    Export e2 = (Export)pi2.getPortProto();
                    if (e2.getCharacteristic() != PortCharacteristic.IN) {
                        System.out.println("Multiple drivers of " + net);
                    }
                    if ((dep = (LinkedHashSet<IconNodeInst>)graph.get(ni2)) == null) {
                        dep = new LinkedHashSet<IconNodeInst>();
                        graph.put(ni2, dep);
                    }
                    dep.add(ni);
                }
            }
        }
        return graph;
    }

    private Collection<IconNodeInst> toposort(List<IconNodeInst> nodes, Map<IconNodeInst, Set<IconNodeInst>> graph) {
        HashSet<IconNodeInst> visited = new HashSet<IconNodeInst>();
        LinkedHashSet<IconNodeInst> sort = new LinkedHashSet<IconNodeInst>();
        for (IconNodeInst ni : nodes) {
            this.toposort(ni, graph, visited, sort);
        }
        return sort;
    }

    private void toposort(IconNodeInst top, Map<IconNodeInst, Set<IconNodeInst>> graph, Set<IconNodeInst> visited, Set<IconNodeInst> sort) {
        if (sort.contains(top)) {
            return;
        }
        if (visited.contains(top)) {
            System.out.println("Combinational loop at " + top);
            return;
        }
        visited.add(top);
        Set<IconNodeInst> deps = graph.get(top);
        if (deps != null) {
            for (IconNodeInst dep : deps) {
                this.toposort(dep, graph, visited, sort);
            }
        }
        sort.add(top);
    }

    private void writeNodes(Collection<IconNodeInst> nodes) {
        int startGo = 0;
        this.printWriter.println("       (");
        for (IconNodeInst node : nodes) {
            this.printWriter.print("        (" + node.getName());
            String protoName = node.getProto().getName();
            PrimitiveTemplate pt = this.primNames.get(protoName);
            if (pt != null) {
                this.printWriter.println(" " + this.portListStr(node, pt.outputs, 0, startGo) + " " + pt.primName + " " + this.portListStr(node, pt.inputs, pt.numGo, startGo) + ")");
                startGo += pt.numGo;
                continue;
            }
            this.printWriter.println(" " + this.portListStr(node, PortCharacteristic.OUT) + " " + protoName + " " + this.portListStr(node, PortCharacteristic.IN) + ")");
        }
        this.printWriter.println("       )");
    }

    private void writeNodesGenerator(Collection<IconNodeInst> nodes) {
        int startGo = 0;
        this.printWriter.println("  (list");
        for (IconNodeInst node : nodes) {
            String protoName = node.getProto().getName();
            PrimitiveTemplate pt = this.primNames.get(protoName);
            if (pt == null) {
                this.printWriter.println("   '(" + node.getName() + " " + this.portListStr(node, PortCharacteristic.OUT) + " " + protoName + " " + this.portListStr(node, PortCharacteristic.IN) + ")");
                continue;
            }
            if (pt.numGo == 0) {
                this.printWriter.println("   '(" + node.getName() + " " + this.portListStr(node, pt.outputs, 0, startGo) + " " + pt.primName + " " + this.portListStr(node, pt.inputs, pt.numGo, startGo) + ")");
                startGo += pt.numGo;
                continue;
            }
            this.printWriter.println("   (list '" + node.getName());
            this.printWriter.println("         '" + this.portListStr(node, pt.outputs, 0, startGo));
            this.printWriter.println("         '" + pt.primName);
            this.printWriter.println("         " + this.portListStrGen(node, pt.inputs, pt.numGo, startGo) + ")");
            startGo += pt.numGo;
        }
        this.printWriter.println("   )");
    }

    private String portListStr(IconNodeInst ni, String[] portNames, int numGo, int startGo) {
        StringBuilder sb = new StringBuilder();
        Netlist netlist = ni.getParent().getNetlist();
        sb.append("(");
        boolean first = true;
        for (String portName : portNames) {
            Network net = netlist.getNetwork(ni.getNodable(0), Name.findName(portName));
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(net.getName());
        }
        if (numGo != 0) {
            if (!first) {
                sb.append(" ");
            }
            if (numGo != 1) {
                throw new UnsupportedOperationException("numGo=" + numGo);
            }
            sb.append(",(si 'go " + startGo + ")");
        }
        sb.append(")");
        return sb.toString();
    }

    private String portListStrGen(IconNodeInst ni, String[] portNames, int numGo, int startGo) {
        StringBuilder sb = new StringBuilder();
        Netlist netlist = ni.getParent().getNetlist();
        sb.append("(list");
        for (String portName : portNames) {
            Network net = netlist.getNetwork(ni.getNodable(0), Name.findName(portName));
            sb.append(" '").append(net.getName());
        }
        if (numGo != 1) {
            throw new UnsupportedOperationException("numGo=" + numGo);
        }
        sb.append(" (si 'go ").append(startGo).append("))");
        return sb.toString();
    }

    private String portListStr(IconNodeInst ni, PortCharacteristic pc) {
        StringBuilder sb = new StringBuilder();
        Netlist netlist = ni.getParent().getNetlist();
        sb.append("(");
        boolean first = true;
        Iterator<Export> it = ni.getProto().getExports();
        while (it.hasNext()) {
            Export e = it.next();
            if (e.getCharacteristic() != pc) continue;
            PortInst pi = ni.findPortInstFromProto(e);
            Network net = netlist.getNetwork(pi);
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(net.getName());
        }
        sb.append(")");
        return sb.toString();
    }

    private void enumDownTop(Cell topIcon, Set<Cell> visitedIcons) {
        if (visitedIcons.contains(topIcon)) {
            return;
        }
        visitedIcons.add(topIcon);
        PrimitiveTemplate pt = this.primNames.get(topIcon.getName());
        if (pt != null) {
            return;
        }
        Cell schem = topIcon.getCellGroup().getMainSchematics();
        if (schem != null) {
            Iterator<NodeInst> it = schem.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!(ni instanceof IconNodeInst) || ni.isIconOfParent()) continue;
                this.enumDownTop((Cell)ni.getProto(), visitedIcons);
            }
        }
        this.downTop.add(schem != null ? schem : topIcon);
    }

    private void def(String cellName, String primName, String[] outputs, String[] inputs, boolean propagates, int numGo) {
        PrimitiveTemplate pt = new PrimitiveTemplate(cellName, primName, outputs, inputs, propagates, numGo);
        this.primNames.put(cellName, pt);
    }

    private void defComb(String cellName, String primName, String output, String ... inputs) {
        String[] outputs = new String[]{output};
        this.def(cellName, primName, outputs, inputs, true, 0);
    }

    private void initPrims() {
        this.defComb("inv", "b-not", "out", "in");
        this.defComb("invn", "b-not", "out", "in");
        this.defComb("nand2", "b-nand", "out", "ina", "inb");
        this.defComb("nor2", "b-nor", "out", "ina", "inb");
        this.defComb("xor2", "b-xor", "out", "ina", "inb");
        this.def("joint", "joint-cntl", new String[]{"fire"}, new String[]{"predFull", "succFull"}, true, 1);
        this.def("linkE", "link-st-e", new String[]{"full"}, new String[]{"fill", "drain"}, false, 0);
        this.def("linkF", "link-st-f", new String[]{"full"}, new String[]{"fill", "drain"}, false, 0);
    }

    private static class PrimitiveTemplate {
        private final String primName;
        private final String[] outputs;
        private final String[] inputs;
        private final boolean propagates;
        private final boolean hasState;
        private final int numGo;

        PrimitiveTemplate(String cellName, String primName, String[] outputs, String[] inputs, boolean propagates, int numGo) {
            this.primName = primName;
            this.outputs = outputs;
            this.inputs = inputs;
            this.propagates = propagates;
            this.hasState = !propagates;
            this.numGo = numGo;
        }
    }

    public static class DualEvalPreferences
    extends Output.OutputPreferences {
        int dxfScale = IOTool.getDXFScale();
        public Technology tech = Technology.getCurrent();

        public DualEvalPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            DualEval out = new DualEval(this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            out.writeDualEval(cell);
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

