/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex;

import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec3Fix;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4BitExtract;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Bitand;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Bitnot;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Bitor;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Bitxor;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4CaseEquality;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Clog2;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Concat;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Countones;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Equality;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Fix;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Ite;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4IteBit;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4IteStmt;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Lsh;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Lt;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Minus;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Offset;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Onehot;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Onehot0;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Onset;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Override;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Parity;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4PartInstall;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4PartSelect;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Plus;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Pow;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Quotient;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4ReductionAnd;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4ReductionOr;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Remainder;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Res;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Resand;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Resor;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4RevBlocks;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Rsh;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4SignExt;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Symwildeq;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Times;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Uminus;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Wildeq;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4WildeqSafe;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Xdet;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4ZeroExt;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class SvexFunction {
    public final ACL2Object fn;
    public final int arity;
    public final String applyFn;
    private static final Map<ACL2Object, SvexFunction> FUNCTIONS = new HashMap<ACL2Object, SvexFunction>();

    private static void b(SvexFunction builder) {
        SvexFunction old = FUNCTIONS.put(builder.fn, builder);
        assert (old == null);
    }

    static SvexFunction valueOf(ACL2Object fn, int arity) {
        SvexFunction fun = FUNCTIONS.get(fn);
        if (fun != null && fun.arity == arity) {
            assert (fun.fn.equals(fn));
        } else {
            fun = new Undefined(fn, arity);
        }
        return fun;
    }

    public SvexFunction(ACL2Object fn, int arity, String applyFn) {
        if (!SvexFunction.isFnSym(fn)) {
            throw new IllegalArgumentException();
        }
        this.fn = fn;
        this.arity = arity;
        this.applyFn = applyFn;
    }

    public abstract <N extends SvarName> SvexCall<N> build(Svex<N>[] var1);

    public <N extends SvarName> Svex<N> callStar(SvexManager<N> sm, Svex<N>[] args) {
        return sm.newCall(this, args);
    }

    public abstract Vec4 apply(Vec4 ... var1);

    protected Vec4 shiftCore(int amt, Vec4 src) {
        if (amt >= 0x1000000 && (src.getUpper().signum() != 0 || src.getLower().signum() != 0)) {
            throw new IllegalArgumentException("very large integer");
        }
        if (src.isVec2()) {
            BigInteger srcv = ((Vec2)src).getVal();
            return Vec2.valueOf(srcv.shiftLeft(amt));
        }
        return Vec4.valueOf(src.getUpper().shiftLeft(amt), src.getLower().shiftLeft(amt));
    }

    protected Vec4 eq(Vec4 x, Vec4 y, BigInteger zMask) {
        if (x.isVec2() && y.isVec2() && zMask.signum() == 0) {
            BigInteger xv = ((Vec2)x).getVal();
            BigInteger yv = ((Vec2)y).getVal();
            return Vec2.valueOf(xv.equals(yv));
        }
        BigInteger xMask = x.getUpper().xor(x.getLower()).or(y.getUpper().xor(y.getLower()));
        BigInteger u = x.getLower().xor(y.getLower()).andNot(xMask).not();
        BigInteger l = x.getUpper().xor(y.getUpper()).or(xMask).not();
        u = u.or(zMask);
        if ((l = l.or(zMask)).equals(u)) {
            return Vec2.valueOf(u.equals(BigIntegerUtil.MINUS_ONE));
        }
        return u.equals(BigIntegerUtil.MINUS_ONE) ? Vec4.X : Vec2.ZERO;
    }

    public <N extends SvarName> BigInteger[] argmasks(BigInteger mask, Svex<N>[] args) {
        if (args.length != this.arity) {
            throw new IllegalArgumentException();
        }
        BigInteger[] result = this.svmaskFor(mask, args, new HashMap<Svex<N>, Vec4>());
        assert (result.length == this.arity);
        return result;
    }

    protected abstract <N extends SvarName> BigInteger[] svmaskFor(BigInteger var1, Svex<N>[] var2, Map<Svex<N>, Vec4> var3);

    protected BigInteger v4maskAllOrNone(BigInteger outerMask) {
        return outerMask.signum() == 0 ? BigInteger.ZERO : BigIntegerUtil.MINUS_ONE;
    }

    protected BigInteger maskForGenericSignx(BigInteger mask) {
        if (mask.signum() < 0) {
            return BigIntegerUtil.MINUS_ONE;
        }
        int maskUpperBounds = Math.incrementExact(mask.bitLength());
        return BigInteger.ONE.shiftLeft(maskUpperBounds).subtract(BigInteger.ONE);
    }

    protected <N extends SvarName> boolean branchesSameUnderMask(BigInteger mask, Svex<N> th, Svex<N> el, Map<Svex<N>, Vec4> xevalMemoize) {
        Vec4 thVal = th.xeval(xevalMemoize);
        Vec4 elVal = el.xeval(xevalMemoize);
        BigInteger thBool = thVal.getUpper().xor(thVal.getLower()).not();
        BigInteger elBool = elVal.getUpper().xor(elVal.getLower()).not();
        return BigIntegerUtil.MINUS_ONE.equals(thBool.andNot(mask)) && BigIntegerUtil.MINUS_ONE.equals(elBool.andNot(mask)) && mask.and(thVal.getUpper()).equals(mask.and(elVal.getUpper()));
    }

    public static boolean isFnSym(ACL2Object o) {
        return ACL2.symbolp(o).bool() && !ACL2.QUOTE.equals(o) && !ACL2.keywordp(o).bool();
    }

    static {
        SvexFunction.b(Vec4Fix.FUNCTION);
        SvexFunction.b(Vec4BitExtract.FUNCTION);
        SvexFunction.b(Vec3Fix.FUNCTION);
        SvexFunction.b(Vec4Bitnot.FUNCTION);
        SvexFunction.b(Vec4Bitand.FUNCTION);
        SvexFunction.b(Vec4Bitor.FUNCTION);
        SvexFunction.b(Vec4Bitxor.FUNCTION);
        SvexFunction.b(Vec4Res.FUNCTION);
        SvexFunction.b(Vec4Resand.FUNCTION);
        SvexFunction.b(Vec4Resor.FUNCTION);
        SvexFunction.b(Vec4Override.FUNCTION);
        SvexFunction.b(Vec4Onset.FUNCTION);
        SvexFunction.b(Vec4Offset.FUNCTION);
        SvexFunction.b(Vec4ReductionAnd.FUNCTION);
        SvexFunction.b(Vec4ReductionOr.FUNCTION);
        SvexFunction.b(Vec4Parity.FUNCTION);
        SvexFunction.b(Vec4ZeroExt.FUNCTION);
        SvexFunction.b(Vec4SignExt.FUNCTION);
        SvexFunction.b(Vec4Concat.FUNCTION);
        SvexFunction.b(Vec4RevBlocks.FUNCTION);
        SvexFunction.b(Vec4Rsh.FUNCTION);
        SvexFunction.b(Vec4Lsh.FUNCTION);
        SvexFunction.b(Vec4Plus.FUNCTION);
        SvexFunction.b(Vec4Minus.FUNCTION);
        SvexFunction.b(Vec4Uminus.FUNCTION);
        SvexFunction.b(Vec4Times.FUNCTION);
        SvexFunction.b(Vec4Quotient.FUNCTION);
        SvexFunction.b(Vec4Remainder.FUNCTION);
        SvexFunction.b(Vec4Xdet.FUNCTION);
        SvexFunction.b(Vec4Countones.FUNCTION);
        SvexFunction.b(Vec4Onehot.FUNCTION);
        SvexFunction.b(Vec4Onehot0.FUNCTION);
        SvexFunction.b(Vec4Lt.FUNCTION);
        SvexFunction.b(Vec4Equality.FUNCTION);
        SvexFunction.b(Vec4CaseEquality.FUNCTION);
        SvexFunction.b(Vec4Wildeq.FUNCTION);
        SvexFunction.b(Vec4WildeqSafe.FUNCTION);
        SvexFunction.b(Vec4Symwildeq.FUNCTION);
        SvexFunction.b(Vec4Clog2.FUNCTION);
        SvexFunction.b(Vec4Pow.FUNCTION);
        SvexFunction.b(Vec4Ite.FUNCTION);
        SvexFunction.b(Vec4IteStmt.FUNCTION);
        SvexFunction.b(Vec4IteBit.FUNCTION);
        SvexFunction.b(Vec4PartSelect.FUNCTION);
        SvexFunction.b(Vec4PartInstall.FUNCTION);
    }

    private static class Undefined
    extends SvexFunction {
        public Undefined(ACL2Object fn, int arity) {
            super(fn, arity, "UNDEFINED-" + arity);
        }

        @Override
        public <N extends SvarName> SvexCall<N> build(Svex<N>[] args) {
            assert (args.length == this.arity);
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            assert (args.length == this.arity);
            Object[] result = new BigInteger[args.length];
            Arrays.fill(result, this.v4maskAllOrNone(mask));
            return result;
        }
    }
}

