/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Properties;

public class PacksPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private static boolean askSelected(boolean bl) {
        boolean bl2 = bl;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            boolean bl3 = true;
            while (bl3) {
                PacksPanelConsoleHelper.out("input 1 to select, 0 to deselect:");
                String string = bufferedReader.readLine();
                if (string.trim().equals("")) {
                    bl3 = false;
                }
                int n = -1;
                try {
                    n = Integer.valueOf(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n != 0 && n != 1) continue;
                bl2 = n == 1;
                bl3 = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl2;
    }

    private static void out(String string) {
        System.out.println(string);
    }

    private String getI18n(LocaleDatabase localeDatabase, String string, String string2) {
        String string3 = localeDatabase.getString(string);
        return string3 != null && !string3.equals(string) ? string3 : string2;
    }

    public boolean runConsole(AutomatedInstallData automatedInstallData) {
        Object object;
        LocaleDatabase localeDatabase = automatedInstallData.langpack;
        try {
            object = ResourceManager.getInstance().getInputStream("packsLang.xml");
            localeDatabase.add((InputStream)object);
        }
        catch (Exception exception) {
            Debug.trace(exception);
        }
        object = new LinkedList();
        PacksPanelConsoleHelper.out("");
        PacksPanelConsoleHelper.out(localeDatabase.getString("PacksPanel.info"));
        PacksPanelConsoleHelper.out("");
        for (Pack pack : automatedInstallData.availablePacks) {
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append("[").append(pack.required ? "<required>" : (pack.preselected ? "x" : " ")).append("] ").append(this.getI18n(localeDatabase, pack.id, pack.name));
            String string = this.getI18n(localeDatabase, pack.id + ".description", pack.description);
            if (string != null && string.length() > 0) {
                stringBuilder.append(" (" + string + ")");
            }
            PacksPanelConsoleHelper.out(stringBuilder.toString());
            if (!pack.required && !PacksPanelConsoleHelper.askSelected(pack.preselected)) continue;
            object.add(pack);
        }
        PacksPanelConsoleHelper.out("");
        PacksPanelConsoleHelper.out("...pack selection done.");
        automatedInstallData.selectedPacks = object;
        int n = this.askEndOfConsolePanel();
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        return this.runConsole(automatedInstallData);
    }

    public boolean runConsoleFromPropertiesFile(AutomatedInstallData automatedInstallData, Properties properties) {
        return false;
    }

    public boolean runGeneratePropertiesFile(AutomatedInstallData automatedInstallData, PrintWriter printWriter) {
        return false;
    }
}

