/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.interpreter;

import gnu.prolog.database.Pair;
import gnu.prolog.io.TermWriter;
import gnu.prolog.term.AtomicTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologCode;
import gnu.prolog.vm.PrologCodeListener;
import gnu.prolog.vm.PrologCodeUpdatedEvent;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.interpreter.CallBacktrackInfo;
import gnu.prolog.vm.interpreter.EnterBacktrackInfo;
import gnu.prolog.vm.interpreter.ExceptionHandlerInfo;
import gnu.prolog.vm.interpreter.LeaveByteCodeBacktrackInfo;
import gnu.prolog.vm.interpreter.Tracer;
import gnu.prolog.vm.interpreter.instruction.IAllocate;
import gnu.prolog.vm.interpreter.instruction.ICall;
import gnu.prolog.vm.interpreter.instruction.ICreateCompoundTerm;
import gnu.prolog.vm.interpreter.instruction.ICreateVariable;
import gnu.prolog.vm.interpreter.instruction.ICut;
import gnu.prolog.vm.interpreter.instruction.IDup;
import gnu.prolog.vm.interpreter.instruction.IFail;
import gnu.prolog.vm.interpreter.instruction.IJump;
import gnu.prolog.vm.interpreter.instruction.IPop;
import gnu.prolog.vm.interpreter.instruction.IPushArgument;
import gnu.prolog.vm.interpreter.instruction.IPushConstant;
import gnu.prolog.vm.interpreter.instruction.IPushEnvironment;
import gnu.prolog.vm.interpreter.instruction.IRetryMeElse;
import gnu.prolog.vm.interpreter.instruction.IReturn;
import gnu.prolog.vm.interpreter.instruction.ISaveCut;
import gnu.prolog.vm.interpreter.instruction.IStoreEnvironment;
import gnu.prolog.vm.interpreter.instruction.IThrow;
import gnu.prolog.vm.interpreter.instruction.ITrue;
import gnu.prolog.vm.interpreter.instruction.ITrustMe;
import gnu.prolog.vm.interpreter.instruction.ITryMeElse;
import gnu.prolog.vm.interpreter.instruction.IUnify;
import gnu.prolog.vm.interpreter.instruction.Instruction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretedByteCode
implements PrologCode,
PrologCodeListener {
    protected CompoundTermTag codeTag;
    protected CompoundTermTag[] tags;
    protected AtomicTerm[] constants;
    protected PrologCode[] predicateCodes;
    protected byte[] instructions;
    protected ExceptionHandlerInfo[] exceptionHandlers;
    public static final int IALLOCATE = 0;
    public static final int ICALL = 1;
    public static final int ICREATE_COMPOUND = 2;
    public static final int ICREATE_VARIABLE = 3;
    public static final int ICUT = 4;
    public static final int IDUP = 5;
    public static final int IFAIL = 6;
    public static final int IJUMP = 7;
    public static final int IPOP = 8;
    public static final int IPUSH_ARGUMENT = 9;
    public static final int IPUSH_CONSTANT = 10;
    public static final int IPUSH_ENVIRONMENT = 11;
    public static final int IRETRY_ME_ELSE = 12;
    public static final int IRETURN = 13;
    public static final int ISAVE_CUT = 14;
    public static final int ISTORE_ENVIRONMENT = 15;
    public static final int ITHROW = 16;
    public static final int ITRUE = 17;
    public static final int ITRUST_ME = 18;
    public static final int ITRY_ME_ELSE = 19;
    public static final int IUNIFY = 20;

    protected InterpretedByteCode(CompoundTermTag codeTag, Instruction[] isrc, ExceptionHandlerInfo[] ehs) {
        this.codeTag = codeTag;
        int[] ipos = new int[isrc.length];
        HashMap<CompoundTermTag, Integer> tag2idx = new HashMap<CompoundTermTag, Integer>();
        HashMap<AtomicTerm, Integer> constant2idx = new HashMap<AtomicTerm, Integer>();
        this.pass1(isrc, ipos, tag2idx, constant2idx);
        this.exceptionHandlers = new ExceptionHandlerInfo[ehs.length];
        int n = ehs.length;
        int i = 0;
        while (i < n) {
            this.exceptionHandlers[i] = new ExceptionHandlerInfo();
            this.exceptionHandlers[i].startPosition = ipos[ehs[i].startPosition];
            this.exceptionHandlers[i].endPosition = ipos[ehs[i].endPosition];
            this.exceptionHandlers[i].handlerPosition = ipos[ehs[i].handlerPosition];
            ++i;
        }
        this.pass2(isrc, ipos, tag2idx, constant2idx);
    }

    protected void pass1(Instruction[] isrc, int[] ipos, Map<CompoundTermTag, Integer> tag2idx, Map<AtomicTerm, Integer> constant2idx) {
        CompoundTermTag tag;
        HashSet<CompoundTermTag> callTags = new HashSet<CompoundTermTag>();
        HashSet<CompoundTermTag> createCompoundTermTags = new HashSet<CompoundTermTag>();
        HashSet<AtomicTerm> constantSet = new HashSet<AtomicTerm>();
        int bytes = 0;
        int n = isrc.length;
        int i = 0;
        while (i < n) {
            Instruction ii;
            if (isrc[i] instanceof IAllocate) {
                ipos[i] = bytes;
                bytes += 5;
            } else if (isrc[i] instanceof ICall) {
                ii = (ICall)isrc[i];
                callTags.add(ii.tag);
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof ICreateCompoundTerm) {
                ii = (ICreateCompoundTerm)isrc[i];
                createCompoundTermTags.add(((ICreateCompoundTerm)ii).tag);
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof ICreateVariable) {
                ipos[i] = bytes++;
            } else if (isrc[i] instanceof ICut) {
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof IDup) {
                ipos[i] = bytes++;
            } else if (isrc[i] instanceof IFail) {
                ipos[i] = bytes++;
            } else if (isrc[i] instanceof IJump) {
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof IPop) {
                ipos[i] = bytes++;
            } else if (isrc[i] instanceof IPushArgument) {
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof IPushConstant) {
                ii = (IPushConstant)isrc[i];
                constantSet.add(((IPushConstant)ii).term);
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof IPushEnvironment) {
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof IRetryMeElse) {
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof IReturn) {
                ipos[i] = bytes++;
            } else if (isrc[i] instanceof ISaveCut) {
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof IStoreEnvironment) {
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof IThrow) {
                ipos[i] = bytes++;
            } else if (isrc[i] instanceof ITrue) {
                ipos[i] = bytes++;
            } else if (isrc[i] instanceof ITrustMe) {
                ipos[i] = bytes++;
            } else if (isrc[i] instanceof ITryMeElse) {
                ipos[i] = bytes;
                bytes += 3;
            } else if (isrc[i] instanceof IUnify) {
                ipos[i] = bytes++;
            }
            ++i;
        }
        createCompoundTermTags.removeAll(callTags);
        this.tags = new CompoundTermTag[createCompoundTermTags.size() + callTags.size()];
        this.predicateCodes = new PrologCode[callTags.size()];
        Iterator j = callTags.iterator();
        int k = 0;
        while (j.hasNext()) {
            this.tags[k] = tag = (CompoundTermTag)j.next();
            tag2idx.put(tag, k);
            ++k;
        }
        j = createCompoundTermTags.iterator();
        while (j.hasNext()) {
            this.tags[k] = tag = (CompoundTermTag)j.next();
            tag2idx.put(tag, k);
            ++k;
        }
        this.constants = new AtomicTerm[constantSet.size()];
        Iterator j2 = constantSet.iterator();
        int i2 = 0;
        while (j2.hasNext()) {
            AtomicTerm term;
            this.constants[i2] = term = (AtomicTerm)j2.next();
            constant2idx.put(term, i2);
            ++i2;
        }
        this.instructions = new byte[bytes];
    }

    protected void pass2(Instruction[] isrc, int[] ipos, Map<CompoundTermTag, Integer> tag2idx, Map<AtomicTerm, Integer> constant2idx) {
        int bytes = 0;
        int n = isrc.length;
        int i = 0;
        while (i < n) {
            int idx;
            Instruction ii;
            if (isrc[i] instanceof IAllocate) {
                ii = (IAllocate)isrc[i];
                this.instructions[bytes++] = 0;
                this.instructions[bytes++] = (byte)(ii.environmentSize >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(ii.environmentSize & 0xFF);
                this.instructions[bytes++] = (byte)(ii.reserved >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(ii.reserved & 0xFF);
            } else if (isrc[i] instanceof ICall) {
                ii = (ICall)isrc[i];
                idx = tag2idx.get(((ICall)ii).tag);
                this.instructions[bytes++] = 1;
                this.instructions[bytes++] = (byte)(idx >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(idx & 0xFF);
            } else if (isrc[i] instanceof ICreateCompoundTerm) {
                ii = (ICreateCompoundTerm)isrc[i];
                idx = tag2idx.get(((ICreateCompoundTerm)ii).tag);
                this.instructions[bytes++] = 2;
                this.instructions[bytes++] = (byte)(idx >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(idx & 0xFF);
            } else if (isrc[i] instanceof ICreateVariable) {
                this.instructions[bytes++] = 3;
            } else if (isrc[i] instanceof ICut) {
                ii = (ICut)isrc[i];
                this.instructions[bytes++] = 4;
                this.instructions[bytes++] = (byte)(((ICut)ii).environmentIndex >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(((ICut)ii).environmentIndex & 0xFF);
            } else if (isrc[i] instanceof IDup) {
                this.instructions[bytes++] = 5;
            } else if (isrc[i] instanceof IFail) {
                this.instructions[bytes++] = 6;
            } else if (isrc[i] instanceof IJump) {
                ii = (IJump)isrc[i];
                this.instructions[bytes++] = 7;
                this.instructions[bytes++] = (byte)(ipos[((IJump)ii).jumpPosition] >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(ipos[((IJump)ii).jumpPosition] & 0xFF);
            } else if (isrc[i] instanceof IPop) {
                this.instructions[bytes++] = 8;
            } else if (isrc[i] instanceof IPushArgument) {
                ii = (IPushArgument)isrc[i];
                this.instructions[bytes++] = 9;
                this.instructions[bytes++] = (byte)(((IPushArgument)ii).argumentPosition >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(((IPushArgument)ii).argumentPosition & 0xFF);
            } else if (isrc[i] instanceof IPushConstant) {
                ii = (IPushConstant)isrc[i];
                idx = constant2idx.get(((IPushConstant)ii).term);
                this.instructions[bytes++] = 10;
                this.instructions[bytes++] = (byte)(idx >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(idx & 0xFF);
            } else if (isrc[i] instanceof IPushEnvironment) {
                ii = (IPushEnvironment)isrc[i];
                this.instructions[bytes++] = 11;
                this.instructions[bytes++] = (byte)(((IPushEnvironment)ii).environmentPosition >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(((IPushEnvironment)ii).environmentPosition & 0xFF);
            } else if (isrc[i] instanceof IRetryMeElse) {
                ii = (IRetryMeElse)isrc[i];
                this.instructions[bytes++] = 12;
                this.instructions[bytes++] = (byte)(ipos[((IRetryMeElse)ii).retryPosition] >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(ipos[((IRetryMeElse)ii).retryPosition] & 0xFF);
            } else if (isrc[i] instanceof IReturn) {
                this.instructions[bytes++] = 13;
            } else if (isrc[i] instanceof ISaveCut) {
                ii = (ISaveCut)isrc[i];
                this.instructions[bytes++] = 14;
                this.instructions[bytes++] = (byte)(((ISaveCut)ii).environmentIndex >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(((ISaveCut)ii).environmentIndex & 0xFF);
            } else if (isrc[i] instanceof IStoreEnvironment) {
                ii = (IStoreEnvironment)isrc[i];
                this.instructions[bytes++] = 15;
                this.instructions[bytes++] = (byte)(((IStoreEnvironment)ii).environmentIndex >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(((IStoreEnvironment)ii).environmentIndex & 0xFF);
            } else if (isrc[i] instanceof IThrow) {
                this.instructions[bytes++] = 16;
            } else if (isrc[i] instanceof ITrue) {
                this.instructions[bytes++] = 17;
            } else if (isrc[i] instanceof ITrustMe) {
                this.instructions[bytes++] = 18;
            } else if (isrc[i] instanceof ITryMeElse) {
                ii = (ITryMeElse)isrc[i];
                this.instructions[bytes++] = 19;
                this.instructions[bytes++] = (byte)(ipos[((ITryMeElse)ii).retryPosition] >> 8 & 0xFF);
                this.instructions[bytes++] = (byte)(ipos[((ITryMeElse)ii).retryPosition] & 0xFF);
            } else if (isrc[i] instanceof IUnify) {
                this.instructions[bytes++] = 20;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        environment = null;
        currentBacktrackInfo = null;
        startBacktrackInfo /* !! */  = null;
        bi = backtrackMode != false ? interpreter.popBacktrackInfo() : null;
        cur_bi = null;
        pds = new Term[16];
        pdsSize = 0;
        pdsMaxSize = pds.length;
        pdsInc = 16;
        if (bi != null) {
            if (!(bi instanceof LeaveByteCodeBacktrackInfo)) {
                PrologException.systemError();
            }
            lbi = (LeaveByteCodeBacktrackInfo)bi;
            environment = lbi.environment;
            startBacktrackInfo /* !! */  = lbi.startBacktrackInfo;
            currentPosition = 0;
        } else {
            startBacktrackInfo /* !! */  = new EnterBacktrackInfo(interpreter.getUndoPosition());
            interpreter.pushBacktrackInfo(startBacktrackInfo /* !! */ );
            currentPosition = 0;
        }
lbl21:
        // 3 sources

        while (true) {
            try {
                while (true) {
                    try {}
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                        PrologException.systemError(ex);
                        continue;
                    }
                    break;
                }
            }
            catch (PrologException ex) {
                en = this.exceptionHandlers.length;
                backtrackMode = false;
                ei = 0;
                if (true) ** GOTO lbl257
            }
            block37: while (true) {
                if (backtrackMode) {
                    cur_bi = interpreter.popBacktrackInfo();
                    cur_bi.undo(interpreter);
                    if (cur_bi instanceof EnterBacktrackInfo) {
                        return -1;
                    }
                    currentPosition = cur_bi.codePosition;
                }
                instr = this.instructions[currentPosition] & 255;
                switch (instr) {
                    case 0: {
                        sz = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        rs = ((this.instructions[currentPosition + 3] & 255) << 8) + (this.instructions[currentPosition + 4] & 255);
                        environment = new Term[sz];
                        i = rs;
                        while (true) {
                            if (i >= sz) {
                                currentPosition += 5;
                                continue block37;
                            }
                            environment[i] = new VariableTerm();
                            ++i;
                        }
                    }
                    case 1: {
                        if (backtrackMode) {
                            cbi = (CallBacktrackInfo)cur_bi;
                            code = cbi.code;
                            cargs = cbi.args;
                            tag = cbi.tag;
                        } else {
                            cd = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                            tag = this.tags[cd];
                            arity = tag.arity;
                            cargs = new Term[arity];
                            i = arity - 1;
                            while (true) {
                                if (i < 0) {
                                    code = this.predicateCodes[cd];
                                    if (code != null) break;
                                    this.predicateCodes[cd] = code = interpreter.getEnvironment().getPrologCode(tag);
                                    break;
                                }
                                cargs[i] = pds[--pdsSize].dereference();
                                pds[pdsSize] = null;
                                --i;
                            }
                        }
                        interpreter.getTracer().traceEvent(backtrackMode != false ? Tracer.TraceLevel.REDO : Tracer.TraceLevel.CALL, interpreter, tag, cargs);
                        try {
                            rc = code.execute(interpreter, backtrackMode, cargs);
                        }
                        finally {
                            interpreter.getTracer().decreaseDepth();
                        }
                        switch (rc) {
                            case 1: {
                                interpreter.getTracer().traceEvent(Tracer.TraceLevel.EXIT, interpreter, tag, cargs);
                                backtrackMode = false;
                                break;
                            }
                            case 0: {
                                interpreter.getTracer().traceEvent(Tracer.TraceLevel.EXIT, interpreter, tag, cargs);
                                if (backtrackMode) {
                                    cur_bi.undoPosition = interpreter.getUndoPosition();
                                    interpreter.pushBacktrackInfo(cur_bi);
                                } else {
                                    interpreter.pushBacktrackInfo(new CallBacktrackInfo(interpreter.getUndoPosition(), currentPosition, cargs, code, tag));
                                }
                                backtrackMode = false;
                                break;
                            }
                            case -1: {
                                interpreter.getTracer().traceEvent(Tracer.TraceLevel.FAIL, interpreter, tag, cargs);
                                backtrackMode = true;
                                break;
                            }
                        }
                        currentPosition += 3;
                        continue block37;
                    }
                    case 2: {
                        tg = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        tag = this.tags[tg];
                        arity = tag.arity;
                        targs = new Term[arity];
                        i = arity - 1;
                        while (true) {
                            if (i < 0) {
                                pds[pdsSize++] = new CompoundTerm(tag, targs);
                                currentPosition += 3;
                                continue block37;
                            }
                            targs[i] = pds[--pdsSize].dereference();
                            pds[pdsSize] = null;
                            --i;
                        }
                    }
                    case 3: {
                        if (pdsSize == pdsMaxSize) {
                            tmp = new Term[pdsSize + 16];
                            System.arraycopy(pds, 0, tmp, 0, pdsMaxSize);
                            pdsMaxSize += 16;
                            pds = tmp;
                        }
                        pds[pdsSize++] = new VariableTerm();
                        ++currentPosition;
                        continue block37;
                    }
                    case 4: {
                        ep = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        t = (JavaObjectTerm)environment[ep];
                        cutPoint = (BacktrackInfo)t.value;
                        interpreter.popBacktrackInfoUntil(cutPoint);
                        currentPosition += 3;
                        continue block37;
                    }
                    case 5: {
                        if (pdsSize == pdsMaxSize) {
                            tmp = new Term[pdsSize + 16];
                            System.arraycopy(pds, 0, tmp, 0, pdsMaxSize);
                            pdsMaxSize += 16;
                        }
                        tmp1 = pds[pdsSize - 1];
                        pds[pdsSize++] = tmp1;
                        ++currentPosition;
                        continue block37;
                    }
                    case 6: {
                        backtrackMode = true;
                        continue block37;
                    }
                    case 7: {
                        currentPosition = jp = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        continue block37;
                    }
                    case 8: {
                        pds[--pdsSize] = null;
                        ++currentPosition;
                        continue block37;
                    }
                    case 9: {
                        if (pdsSize == pdsMaxSize) {
                            tmp = new Term[pdsSize + 16];
                            System.arraycopy(pds, 0, tmp, 0, pdsMaxSize);
                            pdsMaxSize += 16;
                            pds = tmp;
                        }
                        ar = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        pds[pdsSize++] = args[ar];
                        currentPosition += 3;
                        continue block37;
                    }
                    case 10: {
                        if (pdsSize == pdsMaxSize) {
                            tmp = new Term[pdsMaxSize + 16];
                            System.arraycopy(pds, 0, tmp, 0, pdsMaxSize);
                            pdsMaxSize += 16;
                            pds = tmp;
                        }
                        cp = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        pds[pdsSize++] = this.constants[cp];
                        currentPosition += 3;
                        continue block37;
                    }
                    case 11: {
                        if (pdsSize == pdsMaxSize) {
                            tmp = new Term[pdsSize + 16];
                            System.arraycopy(pds, 0, tmp, 0, pdsMaxSize);
                            pdsMaxSize += 16;
                            pds = tmp;
                        }
                        ep = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        pds[pdsSize++] = environment[ep];
                        currentPosition += 3;
                        continue block37;
                    }
                    case 12: {
                        cur_bi.codePosition = rp = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        interpreter.pushBacktrackInfo(cur_bi);
                        currentPosition += 3;
                        backtrackMode = false;
                        continue block37;
                    }
                    case 13: {
                        if (startBacktrackInfo /* !! */  == interpreter.peekBacktrackInfo()) {
                            interpreter.popBacktrackInfo();
                            return 1;
                        }
                        lbi = bi != null ? (LeaveByteCodeBacktrackInfo)bi : new LeaveByteCodeBacktrackInfo(environment, startBacktrackInfo /* !! */ );
                        interpreter.pushBacktrackInfo(lbi);
                        return 0;
                    }
                    case 14: {
                        ep = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        t = new JavaObjectTerm(interpreter.peekBacktrackInfo());
                        environment[ep] = t;
                        currentPosition += 3;
                        continue block37;
                    }
                    case 15: {
                        ep = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        t = pds[--pdsSize];
                        pds[pdsSize] = null;
                        environment[ep] = t;
                        currentPosition += 3;
                        continue block37;
                    }
                    case 16: {
                        t = pds[--pdsSize].dereference();
                        pds[pdsSize] = null;
                        if (t instanceof VariableTerm) {
                            PrologException.instantiationError();
                        }
                        throw new PrologException(t, null);
                    }
                    case 17: {
                        ++currentPosition;
                        continue block37;
                    }
                    case 18: {
                        ++currentPosition;
                        backtrackMode = false;
                        continue block37;
                    }
                    case 19: {
                        rp = ((this.instructions[currentPosition + 1] & 255) << 8) + (this.instructions[currentPosition + 2] & 255);
                        cur_bi = new BacktrackInfo(interpreter.getUndoPosition(), rp);
                        interpreter.pushBacktrackInfo(cur_bi);
                        currentPosition += 3;
                        cur_bi = null;
                        continue block37;
                    }
                    case 20: {
                        t1 = pds[--pdsSize].dereference();
                        pds[pdsSize] = null;
                        t0 = pds[--pdsSize].dereference();
                        pds[pdsSize] = null;
                        rc = interpreter.simpleUnify(t0, t1);
                        if (rc == -1) {
                            backtrackMode = true;
                            continue block37;
                        }
                        ++currentPosition;
                        continue block37;
                    }
                }
                PrologException.systemError();
            }
            break;
        }
        do {
            cur = this.exceptionHandlers[ei];
            if (cur.startPosition < currentPosition && currentPosition < cur.endPosition) {
                if (pdsSize == pdsMaxSize) {
                    tmp = new Term[pdsSize + 16];
                    System.arraycopy(pds, 0, tmp, 0, pdsMaxSize);
                    pdsMaxSize += 16;
                }
                pds[pdsSize++] = ex.getTerm();
                currentPosition = cur.handlerPosition;
                ** continue;
            }
            ++ei;
lbl257:
            // 2 sources

        } while (ei < en);
        interpreter.popBacktrackInfoUntil(startBacktrackInfo /* !! */ );
        cur_bi = interpreter.popBacktrackInfo();
        cur_bi.undo(interpreter);
        throw ex;
    }

    @Override
    public void prologCodeUpdated(PrologCodeUpdatedEvent evt) {
        CompoundTermTag tag = evt.getPredicateTag();
        int i = this.predicateCodes.length - 1;
        while (i >= 0) {
            if (this.tags[i] == tag) {
                this.predicateCodes[i] = null;
                return;
            }
            --i;
        }
    }

    @Override
    public void install(Environment env) {
        int i = this.predicateCodes.length - 1;
        while (i >= 0) {
            env.addPrologCodeListener(this.tags[i], this);
            --i;
        }
    }

    @Override
    public void uninstall(Environment env) {
        int i = this.predicateCodes.length - 1;
        while (i >= 0) {
            env.removePrologCodeListener(this.tags[i], this);
            --i;
        }
    }

    public String toString() {
        int currentPosition = 0;
        String rc = "interpreted code\n";
        while (currentPosition < this.instructions.length) {
            int instr = this.instructions[currentPosition] & 0xFF;
            Pair<String, Integer> answer = this.instructionToString(instr, currentPosition);
            rc = String.valueOf(rc) + (String)answer.left + "\n";
            currentPosition = (Integer)answer.right;
        }
        rc = String.valueOf(rc) + "exceptions\n";
        int n = this.exceptionHandlers.length;
        int i = 0;
        while (i < n) {
            rc = String.valueOf(rc) + this.exceptionHandlers[i] + "\n";
            ++i;
        }
        rc = String.valueOf(rc) + "end interpreted code\n";
        return rc;
    }

    private Pair<String, Integer> instructionToString(int instr, int currentPosition) {
        String rc = "";
        switch (instr) {
            case 0: {
                int sz = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                int rs = ((this.instructions[currentPosition + 3] & 0xFF) << 8) + (this.instructions[currentPosition + 4] & 0xFF);
                rc = String.valueOf(rc) + currentPosition + ": allocate " + sz + ", " + rs;
                currentPosition += 5;
                break;
            }
            case 1: {
                int cd = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                CompoundTermTag tag = this.tags[cd];
                rc = String.valueOf(rc) + currentPosition + ": call " + tag;
                currentPosition += 3;
                break;
            }
            case 2: {
                int tg = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                CompoundTermTag tag = this.tags[tg];
                rc = String.valueOf(rc) + currentPosition + ": create_compound " + tag;
                currentPosition += 3;
                break;
            }
            case 3: {
                rc = String.valueOf(rc) + currentPosition + ": create_variable";
                ++currentPosition;
                break;
            }
            case 4: {
                int ep = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                rc = String.valueOf(rc) + currentPosition + ": cut " + ep;
                currentPosition += 3;
                break;
            }
            case 5: {
                rc = String.valueOf(rc) + currentPosition + ": dup";
                ++currentPosition;
                break;
            }
            case 6: {
                rc = String.valueOf(rc) + currentPosition + ": fail";
                ++currentPosition;
                break;
            }
            case 7: {
                int jp = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                rc = String.valueOf(rc) + currentPosition + ": jump " + jp;
                currentPosition += 3;
                break;
            }
            case 8: {
                rc = String.valueOf(rc) + currentPosition + ": pop";
                ++currentPosition;
                break;
            }
            case 9: {
                int ar = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                rc = String.valueOf(rc) + currentPosition + ": push_argument " + ar;
                currentPosition += 3;
                break;
            }
            case 10: {
                int cp = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                rc = String.valueOf(rc) + currentPosition + ": push_constant " + TermWriter.toString(this.constants[cp]);
                currentPosition += 3;
                break;
            }
            case 11: {
                int ep = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                rc = String.valueOf(rc) + currentPosition + ": push_environment " + ep;
                currentPosition += 3;
                break;
            }
            case 12: {
                int rp = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                rc = String.valueOf(rc) + currentPosition + ": retry_me_else " + rp;
                currentPosition += 3;
                break;
            }
            case 13: {
                rc = String.valueOf(rc) + currentPosition + ": return";
                ++currentPosition;
                break;
            }
            case 14: {
                int ep = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                rc = String.valueOf(rc) + currentPosition + ": save_cut " + ep;
                currentPosition += 3;
                break;
            }
            case 15: {
                int ep = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                rc = String.valueOf(rc) + currentPosition + ": store_environment " + ep;
                currentPosition += 3;
                break;
            }
            case 16: {
                rc = String.valueOf(rc) + currentPosition + ": throw";
                ++currentPosition;
                break;
            }
            case 17: {
                rc = String.valueOf(rc) + currentPosition + ": true";
                ++currentPosition;
                break;
            }
            case 18: {
                rc = String.valueOf(rc) + currentPosition + ": trust_me";
                ++currentPosition;
                break;
            }
            case 19: {
                int rp = ((this.instructions[currentPosition + 1] & 0xFF) << 8) + (this.instructions[currentPosition + 2] & 0xFF);
                rc = String.valueOf(rc) + currentPosition + ": try_me_else " + rp;
                currentPosition += 3;
                break;
            }
            case 20: {
                rc = String.valueOf(rc) + currentPosition + ": unify ";
                ++currentPosition;
                break;
            }
            default: {
                rc = String.valueOf(rc) + currentPosition + ": unknown";
                ++currentPosition;
            }
        }
        return new Pair<String, Integer>(rc, currentPosition);
    }

    public String getIntruction(int currentPosition) {
        int instr = this.instructions[currentPosition] & 0xFF;
        return (String)this.instructionToString((int)instr, (int)currentPosition).left;
    }
}

